/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo;

import com.github.lunatrius.core.client.gui.FontRendererHelper;
import com.github.lunatrius.core.entity.EntityHelper;
import com.github.lunatrius.core.util.vector.Vector3f;
import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.core.world.chunk.ChunkHelper;
import com.github.lunatrius.ingameinfo.Value;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.parser.json.JsonParser;
import com.github.lunatrius.ingameinfo.parser.text.TextParser;
import com.github.lunatrius.ingameinfo.parser.xml.XmlParser;
import com.github.lunatrius.ingameinfo.serializer.ISerializer;
import com.github.lunatrius.ingameinfo.serializer.json.JsonSerializer;
import com.github.lunatrius.ingameinfo.serializer.text.TextSerializer;
import com.github.lunatrius.ingameinfo.serializer.xml.XmlSerializer;
import cpw.mods.fml.common.registry.GameData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.opengl.GL11;

public class InGameInfoCore {
    public static final InGameInfoCore instance = new InGameInfoCore();
    private IParser parser;
    private Minecraft minecraftClient = Minecraft.func_71410_x();
    private MinecraftServer minecraftServer = null;
    private World world = null;
    private EntityClientPlayerMP player = null;
    private ScaledResolution scaledResolution = null;
    private File configDirectory = null;
    private File configFile = null;
    private final Map<String, List<List<Value>>> format = new HashMap<String, List<List<Value>>>();
    private final String[] roughdirection = new String[]{"South", "West", "North", "East"};
    private final String[] finedirection = new String[]{"South", "South West", "West", "North West", "North", "North East", "East", "South East"};
    private final String[] abrroughdirection = new String[]{"S", "W", "N", "E"};
    private final String[] abrfinedirection = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    private final Vector3i playerPosition = new Vector3i();
    private final Vector3f playerMotion = new Vector3f();
    private PotionEffect[] potionEffects = null;
    private boolean hasSeed;
    private long seed = 0L;
    private final Map<String, List<String>> valuePairs = new HashMap<String, List<String>>();

    private InGameInfoCore() {
    }

    public boolean setConfigDirectory(File directory) {
        this.configDirectory = directory;
        return true;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public boolean setConfigFile(String filename) {
        File file = new File(this.configDirectory, filename);
        if (file.exists()) {
            if (filename.endsWith(".xml")) {
                this.configFile = file;
                this.parser = new XmlParser();
                return true;
            }
            if (filename.endsWith(".json")) {
                this.configFile = file;
                this.parser = new JsonParser();
                return true;
            }
            if (filename.endsWith(".txt")) {
                this.configFile = file;
                this.parser = new TextParser();
                return true;
            }
        }
        return false;
    }

    public void setServer(MinecraftServer server) {
        this.minecraftServer = server;
        if (this.minecraftServer != null) {
            try {
                this.hasSeed = true;
                this.seed = this.minecraftServer.func_71218_a(0).func_72905_C();
            }
            catch (Exception e) {
                this.hasSeed = false;
                this.seed = 0L;
            }
        }
    }

    public void onTickClient() {
        this.world = this.minecraftClient.field_71441_e;
        this.player = this.minecraftClient.field_71439_g;
        this.scaledResolution = new ScaledResolution(this.minecraftClient.field_71474_y, this.minecraftClient.field_71443_c, this.minecraftClient.field_71440_d);
        this.playerPosition.setX((int)Math.floor(this.player.field_70165_t));
        this.playerPosition.setY((int)Math.floor(this.player.field_70163_u));
        this.playerPosition.setZ((int)Math.floor(this.player.field_70161_v));
        this.playerMotion.set((float)(this.player.field_70165_t - this.player.field_70169_q), (float)(this.player.field_70163_u - this.player.field_70167_r), (float)(this.player.field_70161_v - this.player.field_70166_s));
        Collection potionEffectCollection = this.player.func_70651_bq();
        this.potionEffects = new PotionEffect[potionEffectCollection.size()];
        if (potionEffectCollection.size() > 0) {
            int index = 0;
            for (PotionEffect potionEffect : potionEffectCollection) {
                this.potionEffects[index++] = potionEffect;
            }
        }
        Set<String> keys = this.format.keySet();
        for (String key : keys) {
            List<List<Value>> lines = this.format.get(key);
            ArrayList<String> stringLines = new ArrayList<String>();
            this.valuePairs.put(key, stringLines);
            for (List<Value> line : lines) {
                String str = "";
                for (int i = 0; i < line.size(); ++i) {
                    str = str + this.getValue(line.get(i));
                }
                if (str.isEmpty()) continue;
                stringLines.add(this.replaceVariables(str));
            }
        }
    }

    public void onTickRender() {
        int x = 0;
        int y = 0;
        int type = -1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Set<String> keys = this.valuePairs.keySet();
        for (String key : keys) {
            List<String> lines = this.valuePairs.get(key);
            if (lines == null) continue;
            if (key.contains("top")) {
                y = 2;
            } else if (key.contains("mid")) {
                y = this.scaledResolution.func_78328_b() / 2 - lines.size() * 10 / 2;
            } else {
                if (!key.contains("bot")) continue;
                y = this.scaledResolution.func_78328_b() - lines.size() * 10 - 2;
            }
            if (key.contains("left")) {
                x = 2;
                type = 0;
            } else if (key.contains("center")) {
                x = this.scaledResolution.func_78326_a() / 2;
                type = 1;
            } else {
                if (!key.contains("right")) continue;
                x = this.scaledResolution.func_78326_a() - 2;
                type = 2;
            }
            for (String line : lines) {
                switch (type) {
                    case 0: {
                        FontRendererHelper.drawLeftAlignedString((FontRenderer)this.minecraftClient.field_71466_p, (String)line, (int)x, (int)y, (int)0xFFFFFF);
                        break;
                    }
                    case 1: {
                        FontRendererHelper.drawCenteredString((FontRenderer)this.minecraftClient.field_71466_p, (String)line, (int)x, (int)y, (int)0xFFFFFF);
                        break;
                    }
                    case 2: {
                        FontRendererHelper.drawRightAlignedString((FontRenderer)this.minecraftClient.field_71466_p, (String)line, (int)x, (int)y, (int)0xFFFFFF);
                    }
                }
                y += 10;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void copyDefaultConfig() {
        File configFile = new File(this.configDirectory, "InGameInfo.xml");
        if (!configFile.exists()) {
            try {
                String line;
                ResourceLocation resourceLocation = new ResourceLocation("ingameinfo", "InGameInfo.xml");
                IResource resource = this.minecraftClient.func_110442_L().func_110536_a(resourceLocation);
                InputStream inputStream = resource.func_110527_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String defaultConfig = "";
                while ((line = reader.readLine()) != null) {
                    defaultConfig = defaultConfig + line + System.getProperty("line.separator");
                }
                inputStream.close();
                FileWriter fileWriter = new FileWriter(configFile);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(defaultConfig);
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean loadConfig(String filename) {
        return this.setConfigFile(filename) && this.reloadConfig();
    }

    public boolean reloadConfig() {
        this.valuePairs.clear();
        this.format.clear();
        if (this.parser == null) {
            return false;
        }
        this.parser.load(this.configFile);
        if (!this.parser.parse(this.format)) {
            this.format.clear();
            return false;
        }
        return true;
    }

    public boolean saveConfig(String filename) {
        ISerializer serializer = null;
        File file = new File(this.configDirectory, filename);
        if (filename.endsWith(".xml")) {
            serializer = new XmlSerializer();
        } else if (filename.endsWith(".json")) {
            serializer = new JsonSerializer();
        } else if (filename.endsWith(".txt")) {
            serializer = new TextSerializer();
        }
        return serializer != null && serializer.save(file, this.format);
    }

    private String replaceVariables(String str) {
        Pattern pattern = Pattern.compile("\\{([a-z0-9]+)\\}", 2);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            str = str.replace(matcher.group(0), this.getVariableValue(matcher.group(1)));
        }
        return str;
    }

    private String getValue(Value value) {
        if (value.type.equals((Object)Value.ValueType.STR)) {
            return value.value;
        }
        if (value.type.equals((Object)Value.ValueType.NUM)) {
            return value.value;
        }
        if (value.type.equals((Object)Value.ValueType.VAR)) {
            return this.getVariableValue(value.value);
        }
        if (value.type.equals((Object)Value.ValueType.IF) && (value.values.size() == 2 || value.values.size() == 3)) {
            try {
                if (Boolean.parseBoolean(this.getValue(value.values.get(0)))) {
                    return this.getValue(value.values.get(1));
                }
                if (value.values.size() > 2) {
                    return this.getValue(value.values.get(2));
                }
                return "";
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.NOT) && value.values.size() == 1) {
            try {
                return Boolean.toString(!Boolean.parseBoolean(this.getValue(value.values.get(0))));
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.AND)) {
            try {
                for (Value operand : value.values) {
                    if (Boolean.parseBoolean(this.getValue(operand))) continue;
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.OR)) {
            try {
                for (Value operand : value.values) {
                    if (!Boolean.parseBoolean(this.getValue(operand))) continue;
                    return Boolean.toString(true);
                }
                return Boolean.toString(false);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.XOR)) {
            try {
                boolean result = false;
                for (Value operand : value.values) {
                    result ^= Boolean.parseBoolean(this.getValue(operand));
                }
                return Boolean.toString(result);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.GREATER) && value.values.size() > 1) {
            try {
                double current = Double.parseDouble(this.getValue(value.values.get(0)));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    double next = Double.parseDouble(this.getValue(operand));
                    if (current > next) {
                        current = next;
                        continue;
                    }
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.LESSER) && value.values.size() > 1) {
            try {
                double current = Double.parseDouble(this.getValue(value.values.get(0)));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    double next = Double.parseDouble(this.getValue(operand));
                    if (current < next) {
                        current = next;
                        continue;
                    }
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                return "?";
            }
        }
        if (value.type.equals((Object)Value.ValueType.EQUAL) && value.values.size() > 1) {
            try {
                double current = Double.parseDouble(this.getValue(value.values.get(0)));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    double next = Double.parseDouble(this.getValue(operand));
                    if (current == next) continue;
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
            catch (Exception e) {
                String current = this.getValue(value.values.get(0));
                for (Value operand : value.values.subList(1, value.values.size())) {
                    String next = this.getValue(operand);
                    if (current.equals(next)) continue;
                    return Boolean.toString(false);
                }
                return Boolean.toString(true);
            }
        }
        if (value.type.equals((Object)Value.ValueType.PCT) && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                return Double.toString(arg0 / arg1 * 100.0);
            }
            catch (Exception e) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.CONCAT)) {
            String str = "";
            for (Value val : value.values) {
                str = str + this.getValue(val);
            }
            return str;
        }
        if (value.type.equals((Object)Value.ValueType.MAX) && (value.values.size() == 2 || value.values.size() == 4)) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                int shift = value.values.size() - 2;
                return arg0 > arg1 ? this.getValue(value.values.get(0 + shift)) : this.getValue(value.values.get(1 + shift));
            }
            catch (Exception e) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.MIN) && (value.values.size() == 2 || value.values.size() == 4)) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                int shift = value.values.size() - 2;
                return arg0 < arg1 ? this.getValue(value.values.get(0 + shift)) : this.getValue(value.values.get(1 + shift));
            }
            catch (Exception e) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.ADD) && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 + arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                    double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                    return Double.toString(arg0 + arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
        if (value.type.equals((Object)Value.ValueType.SUB) && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 - arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                    double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                    return Double.toString(arg0 - arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
        if (value.type.equals((Object)Value.ValueType.MUL) && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 * arg1);
            }
            catch (Exception e1) {
                try {
                    double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                    double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                    return Double.toString(arg0 * arg1);
                }
                catch (Exception e2) {
                    return "0";
                }
            }
        }
        if (value.type.equals((Object)Value.ValueType.DIV) && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                return Double.toString(arg0 / arg1);
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.ROUND) && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                double dec = Math.pow(10.0, arg1);
                if (arg1 > 0) {
                    return String.format(Locale.ENGLISH, "%." + arg1 + "f", arg0);
                }
                return Integer.toString((int)((double)Math.round(arg0 * dec) / dec));
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.MOD) && value.values.size() == 2) {
            try {
                double arg0 = Double.parseDouble(this.getValue(value.values.get(0)));
                double arg1 = Double.parseDouble(this.getValue(value.values.get(1)));
                return Double.toString((double)Math.round(arg0 % arg1 * 1.0E7) / 1.0E7);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.MODI) && value.values.size() == 2) {
            try {
                int arg0 = Integer.parseInt(this.getValue(value.values.get(0)));
                int arg1 = Integer.parseInt(this.getValue(value.values.get(1)));
                return Integer.toString(arg0 % arg1);
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.ITEMQUANTITY) && (value.values.size() == 1 || value.values.size() == 2)) {
            try {
                Item item;
                int itemDamage = -1;
                try {
                    String itemName = this.getValue(value.values.get(0));
                    item = (Item)GameData.itemRegistry.get(itemName);
                }
                catch (Exception e3) {
                    int itemID = Integer.parseInt(this.getValue(value.values.get(0)));
                    item = (Item)GameData.itemRegistry.get(itemID);
                }
                if (value.values.size() == 2) {
                    itemDamage = Integer.parseInt(this.getValue(value.values.get(1)));
                }
                return Integer.toString(EntityHelper.getItemCountInInventory((IInventory)this.player.field_71071_by, (Item)item, (int)itemDamage));
            }
            catch (Exception e2) {
                return "0";
            }
        }
        if (value.type.equals((Object)Value.ValueType.TRANS)) {
            try {
                return StatCollector.func_74838_a((String)value.value);
            }
            catch (Exception e) {
                return "?";
            }
        }
        return "";
    }

    private String getVariableValue(String var) {
        try {
            if (var.equalsIgnoreCase("day")) {
                return String.format(Locale.ENGLISH, "%d", this.world.func_72820_D() / 24000L);
            }
            if (var.equalsIgnoreCase("mctime") || var.equalsIgnoreCase("mctime24")) {
                long time = this.world.func_72820_D();
                long hour = (time / 1000L + 6L) % 24L;
                long minute = time % 1000L * 60L / 1000L;
                return String.format(Locale.ENGLISH, "%02d:%02d", hour, minute);
            }
            if (var.equalsIgnoreCase("mctime12")) {
                long time = this.world.func_72820_D();
                long hour = (time / 1000L + 6L) % 24L;
                long minute = time % 1000L * 60L / 1000L;
                String ampm = "AM";
                if (hour >= 12L) {
                    hour -= 12L;
                    ampm = "PM";
                }
                if (hour == 0L) {
                    hour += 12L;
                }
                return String.format(Locale.ENGLISH, "%02d:%02d %s", hour, minute, ampm);
            }
            if (var.equalsIgnoreCase("mctimeh")) {
                long hour = (this.world.func_72820_D() / 1000L + 6L) % 24L;
                return String.format(Locale.ENGLISH, "%02d", hour);
            }
            if (var.equalsIgnoreCase("mctimem")) {
                long minute = this.world.func_72820_D() % 1000L * 60L / 1000L;
                return String.format(Locale.ENGLISH, "%02d", minute);
            }
            if (var.equalsIgnoreCase("rltime") || var.equalsIgnoreCase("irltime") || var.equalsIgnoreCase("rltime24") || var.equalsIgnoreCase("irltime24")) {
                return new SimpleDateFormat("HH:mm").format(new Date());
            }
            if (var.equalsIgnoreCase("rltime12") || var.equalsIgnoreCase("irltime12")) {
                return new SimpleDateFormat("hh:mm a").format(new Date());
            }
            if (var.equalsIgnoreCase("light")) {
                try {
                    return Integer.toString(this.world.func_72938_d(this.playerPosition.x, this.playerPosition.z).func_76629_c(this.playerPosition.x & 0xF, this.playerPosition.y, this.playerPosition.z & 0xF, this.world.func_72967_a(1.0f)));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("lightfeet")) {
                try {
                    return Integer.toString(this.world.func_72938_d(this.playerPosition.x, this.playerPosition.z).func_76629_c(this.playerPosition.x & 0xF, (int)Math.round(this.player.field_70121_D.field_72338_b), this.playerPosition.z & 0xF, this.world.func_72967_a(1.0f)));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("lightnosun")) {
                try {
                    return Integer.toString(this.world.func_72938_d(this.playerPosition.x, this.playerPosition.z).func_76614_a(EnumSkyBlock.Block, this.playerPosition.x & 0xF, this.playerPosition.y, this.playerPosition.z & 0xF));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("lightnosunfeet")) {
                try {
                    return Integer.toString(this.world.func_72938_d(this.playerPosition.x, this.playerPosition.z).func_76614_a(EnumSkyBlock.Block, this.playerPosition.x & 0xF, (int)Math.round(this.player.field_70121_D.field_72338_b), this.playerPosition.z & 0xF));
                }
                catch (Exception e) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("score")) {
                try {
                    return Integer.toString(this.player.func_71037_bA());
                }
                catch (Exception var12) {
                    return "0";
                }
            }
            if (var.equalsIgnoreCase("x")) {
                return String.format(Locale.ENGLISH, "%.2f", this.player.field_70165_t);
            }
            if (var.equalsIgnoreCase("y")) {
                return String.format(Locale.ENGLISH, "%.2f", this.player.field_70163_u);
            }
            if (var.equalsIgnoreCase("yfeet")) {
                return String.format(Locale.ENGLISH, "%.2f", this.player.field_70121_D.field_72338_b);
            }
            if (var.equalsIgnoreCase("z")) {
                return String.format(Locale.ENGLISH, "%.2f", this.player.field_70161_v);
            }
            if (var.equalsIgnoreCase("xi")) {
                return Integer.toString(this.playerPosition.x);
            }
            if (var.equalsIgnoreCase("yi")) {
                return Integer.toString(this.playerPosition.y);
            }
            if (var.equalsIgnoreCase("yfeeti")) {
                return Integer.toString((int)Math.floor(this.player.field_70121_D.field_72338_b));
            }
            if (var.equalsIgnoreCase("zi")) {
                return Integer.toString(this.playerPosition.z);
            }
            if (var.equalsIgnoreCase("speed")) {
                return String.format("%.2f", Math.sqrt(this.playerMotion.x * this.playerMotion.x + this.playerMotion.y * this.playerMotion.y + this.playerMotion.z * this.playerMotion.z));
            }
            if (var.equalsIgnoreCase("speedx")) {
                return String.format("%.2f", Float.valueOf(Math.abs(this.playerMotion.x)));
            }
            if (var.equalsIgnoreCase("speedy")) {
                return String.format("%.2f", Float.valueOf(Math.abs(this.playerMotion.y)));
            }
            if (var.equalsIgnoreCase("speedz")) {
                return String.format("%.2f", Float.valueOf(Math.abs(this.playerMotion.z)));
            }
            if (var.equalsIgnoreCase("speedxz")) {
                return String.format("%.2f", Math.sqrt(this.playerMotion.x * this.playerMotion.x + this.playerMotion.z * this.playerMotion.z));
            }
            if (var.equalsIgnoreCase("roughdirection")) {
                return this.roughdirection[MathHelper.func_76128_c((double)((double)this.player.field_70177_z * 4.0 / 360.0 + 0.5)) & 3];
            }
            if (var.equalsIgnoreCase("finedirection")) {
                return this.finedirection[MathHelper.func_76128_c((double)((double)this.player.field_70177_z * 8.0 / 360.0 + 0.5)) & 7];
            }
            if (var.equalsIgnoreCase("abrroughdirection")) {
                return this.abrroughdirection[MathHelper.func_76128_c((double)((double)this.player.field_70177_z * 4.0 / 360.0 + 0.5)) & 3];
            }
            if (var.equalsIgnoreCase("abrfinedirection")) {
                return this.abrfinedirection[MathHelper.func_76128_c((double)((double)this.player.field_70177_z * 8.0 / 360.0 + 0.5)) & 7];
            }
            if (var.equalsIgnoreCase("directionhud")) {
                int direction = MathHelper.func_76128_c((double)((double)(this.player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
                if (direction % 2 == 0) {
                    return "\u00a7r" + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length - 1) % this.abrfinedirection.length] + "   \u00a7c" + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length) % this.abrfinedirection.length] + "\u00a7r   " + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length + 1) % this.abrfinedirection.length];
                }
                return "\u00a7r     " + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length) % this.abrfinedirection.length] + "   " + this.abrfinedirection[(direction / 2 + this.abrfinedirection.length + 1) % this.abrfinedirection.length] + "   ";
            }
            if (var.equalsIgnoreCase("fps")) {
                return this.minecraftClient.field_71426_K.substring(0, this.minecraftClient.field_71426_K.indexOf(" fps"));
            }
            if (var.equalsIgnoreCase("mouseovername")) {
                MovingObjectPosition objectMouseOver = this.minecraftClient.field_71476_x;
                if (objectMouseOver != null) {
                    Block block;
                    if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                        return objectMouseOver.field_72308_g.func_145748_c_().func_150254_d();
                    }
                    if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                        ItemStack pickBlock = block.getPickBlock(objectMouseOver, this.world, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
                        if (pickBlock != null) {
                            return pickBlock.func_82833_r();
                        }
                        return block.func_149732_F();
                    }
                }
                return "";
            }
            if (var.equalsIgnoreCase("mouseoveruniquename")) {
                MovingObjectPosition objectMouseOver = this.minecraftClient.field_71476_x;
                if (objectMouseOver != null) {
                    Block block;
                    if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                        return EntityList.func_75621_b((Entity)objectMouseOver.field_72308_g);
                    }
                    if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                        return GameData.blockRegistry.func_148750_c((Object)block);
                    }
                }
                return "";
            }
            if (var.equalsIgnoreCase("mouseoverid")) {
                MovingObjectPosition objectMouseOver = this.minecraftClient.field_71476_x;
                if (objectMouseOver != null) {
                    Block block;
                    if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                        return Integer.toString(objectMouseOver.field_72308_g.func_145782_y());
                    }
                    if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                        return Integer.toString(GameData.blockRegistry.getId((Object)block));
                    }
                }
                return "0";
            }
            if (var.equalsIgnoreCase("mouseoverpowerweak")) {
                Block block;
                MovingObjectPosition objectMouseOver = this.minecraftClient.field_71476_x;
                if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                    int power = -1;
                    for (int side = 0; side < 6; ++side) {
                        power = Math.max(power, block.func_149709_b((IBlockAccess)this.world, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d, side));
                    }
                    return Integer.toString(power);
                }
                return "-1";
            }
            if (var.equalsIgnoreCase("mouseoverpowerstrong")) {
                Block block;
                MovingObjectPosition objectMouseOver = this.minecraftClient.field_71476_x;
                if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                    int power = -1;
                    for (int side = 0; side < 6; ++side) {
                        power = Math.max(power, block.func_149748_c((IBlockAccess)this.world, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d, side));
                    }
                    return Integer.toString(power);
                }
                return "-1";
            }
            if (var.equalsIgnoreCase("mouseoverpowerinput")) {
                MovingObjectPosition objectMouseOver = this.minecraftClient.field_71476_x;
                if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    return Integer.toString(this.world.func_94577_B(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d));
                }
                return "-1";
            }
            if (var.equalsIgnoreCase("worldname")) {
                return this.world.func_72912_H().func_76065_j();
            }
            if (var.equalsIgnoreCase("worldsize")) {
                return Long.toString(this.world.func_72912_H().func_76092_g());
            }
            if (var.equalsIgnoreCase("worldsizemb")) {
                return String.format(Locale.ENGLISH, "%.1f", (double)this.world.func_72912_H().func_76092_g() / 1048576.0);
            }
            if (var.equalsIgnoreCase("seed")) {
                return Long.toString(this.seed);
            }
            if (var.equalsIgnoreCase("difficulty")) {
                return StatCollector.func_74838_a((String)this.minecraftClient.field_71474_y.field_74318_M.func_151526_b());
            }
            if (var.equalsIgnoreCase("difficultyid")) {
                return Integer.toString(this.minecraftClient.field_71474_y.field_74318_M.func_151525_a());
            }
            if (var.equalsIgnoreCase("gamemode")) {
                return StatCollector.func_74838_a((String)("selectWorld.gameMode." + this.world.func_72912_H().func_76077_q().func_77149_b()));
            }
            if (var.equalsIgnoreCase("gamemodeid")) {
                return Integer.toString(this.world.func_72912_H().func_76077_q().func_77148_a());
            }
            if (var.equalsIgnoreCase("healthpoints")) {
                return Float.toString(this.player.func_110143_aJ());
            }
            if (var.equalsIgnoreCase("armorpoints")) {
                return Integer.toString(this.player.func_70658_aO());
            }
            if (var.equalsIgnoreCase("foodpoints")) {
                return Integer.toString(this.player.func_71024_bL().func_75116_a());
            }
            if (var.equalsIgnoreCase("foodsaturation")) {
                return Float.toString(this.player.func_71024_bL().func_75115_e());
            }
            if (var.equalsIgnoreCase("airticks")) {
                return Integer.toString(this.player.func_70086_ai());
            }
            if (var.equalsIgnoreCase("playerlevel")) {
                return Integer.toString(this.player.field_71068_ca);
            }
            if (var.equalsIgnoreCase("xpthislevel")) {
                return Integer.toString((int)Math.ceil(this.player.field_71106_cc * (float)this.player.func_71050_bK()));
            }
            if (var.equalsIgnoreCase("xpuntilnext")) {
                return Integer.toString((int)Math.floor((1.0 - (double)this.player.field_71106_cc) * (double)this.player.func_71050_bK()));
            }
            if (var.equalsIgnoreCase("xpcap")) {
                return Integer.toString(this.player.func_71050_bK());
            }
            if (var.equalsIgnoreCase("dimension")) {
                return this.world.field_73011_w.func_80007_l();
            }
            if (var.equalsIgnoreCase("dimensionid")) {
                return Integer.toString(this.player.field_71093_bK);
            }
            if (var.equalsIgnoreCase("biome")) {
                return this.world.func_72807_a((int)this.playerPosition.x, (int)this.playerPosition.z).field_76791_y;
            }
            if (var.equalsIgnoreCase("biomeid")) {
                return Integer.toString(this.world.func_72807_a((int)this.playerPosition.x, (int)this.playerPosition.z).field_76756_M);
            }
            if (var.equalsIgnoreCase("username")) {
                return this.player.func_146103_bH().getName();
            }
            if (!var.equalsIgnoreCase("texturepack") && !var.equalsIgnoreCase("resourcepack")) {
                if (var.equalsIgnoreCase("entitiesrendered")) {
                    String str = this.minecraftClient.func_71408_n();
                    return str.substring(str.indexOf(32) + 1, str.indexOf(47));
                }
                if (var.equalsIgnoreCase("entitiestotal")) {
                    String str = this.minecraftClient.func_71408_n();
                    return str.substring(str.indexOf(47) + 1, str.indexOf(46));
                }
                if (var.equalsIgnoreCase("daytime")) {
                    return Boolean.toString(this.world.func_72967_a(1.0f) < 4);
                }
                if (var.equalsIgnoreCase("raining")) {
                    return Boolean.toString(this.world.func_72867_j(1.0f) > 0.2f && this.world.func_72807_a(this.playerPosition.x, this.playerPosition.z).func_76738_d());
                }
                if (var.equalsIgnoreCase("thundering")) {
                    return Boolean.toString(this.world.func_72912_H().func_76061_m() && this.world.func_72807_a(this.playerPosition.x, this.playerPosition.z).func_76738_d());
                }
                if (var.equalsIgnoreCase("snowing")) {
                    BiomeGenBase biome = this.world.func_72807_a(this.playerPosition.x, this.playerPosition.z);
                    return Boolean.toString(this.world.func_72896_J() && !biome.func_76738_d() && !biome.equals(BiomeGenBase.field_76769_d) && !biome.equals(BiomeGenBase.field_76786_s));
                }
                if (var.equalsIgnoreCase("nextrain")) {
                    if (this.minecraftServer == null) {
                        return "?";
                    }
                    int seconds = this.minecraftServer.field_71305_c[0].func_72912_H().func_76083_p() / 20;
                    if (seconds < 60) {
                        return String.format(Locale.ENGLISH, "%ds", seconds);
                    }
                    if (seconds < 3600) {
                        return String.format(Locale.ENGLISH, "%dm", seconds / 60);
                    }
                    return String.format(Locale.ENGLISH, "%dh", seconds / 3600);
                }
                if (var.equalsIgnoreCase("slimes")) {
                    return Boolean.toString(this.hasSeed && ChunkHelper.isSlimeChunk((long)this.seed, (int)(this.playerPosition.x >> 4), (int)(this.playerPosition.z >> 4)) || this.world.func_72807_a((int)this.playerPosition.x, (int)this.playerPosition.z).field_76756_M == BiomeGenBase.field_76780_h.field_76756_M);
                }
                if (var.equalsIgnoreCase("hardcore")) {
                    return Boolean.toString(this.world.func_72912_H().func_76093_s());
                }
                if (var.equalsIgnoreCase("underwater") || var.equalsIgnoreCase("inwater")) {
                    return Boolean.toString(this.player.func_70090_H());
                }
                if (var.equalsIgnoreCase("wet")) {
                    return Boolean.toString(this.player.func_70026_G());
                }
                if (var.equalsIgnoreCase("alive")) {
                    return Boolean.toString(this.player.func_70089_S());
                }
                if (var.equalsIgnoreCase("burning")) {
                    return Boolean.toString(this.player.func_70027_ad());
                }
                if (var.equalsIgnoreCase("riding")) {
                    return Boolean.toString(this.player.func_70115_ae());
                }
                if (var.equalsIgnoreCase("sneaking")) {
                    return Boolean.toString(this.player.func_70093_af());
                }
                if (var.equalsIgnoreCase("sprinting")) {
                    return Boolean.toString(this.player.func_70051_ag());
                }
                if (var.equalsIgnoreCase("invisible")) {
                    return Boolean.toString(this.player.func_82150_aj());
                }
                if (var.equalsIgnoreCase("eating")) {
                    return Boolean.toString(this.player.func_70113_ah());
                }
                if (var.equalsIgnoreCase("invulnerable")) {
                    return Boolean.toString(this.player.func_85032_ar());
                }
                if (var.matches("(equipped|helmet|chestplate|leggings|boots)(uniquename|name|maxdamage|damage|damageleft)")) {
                    ItemStack itemStack;
                    if (var.startsWith("equipped")) {
                        itemStack = this.player.func_71045_bC();
                    } else {
                        int slot = -1;
                        if (var.startsWith("helmet")) {
                            slot = 3;
                        } else if (var.startsWith("chestplate")) {
                            slot = 2;
                        } else if (var.startsWith("leggings")) {
                            slot = 1;
                        } else if (var.startsWith("boots")) {
                            slot = 0;
                        }
                        itemStack = this.player.field_71071_by.func_70440_f(slot);
                    }
                    if (var.endsWith("uniquename")) {
                        Item item = itemStack != null ? itemStack.func_77973_b() : null;
                        return item != null ? GameData.itemRegistry.func_148750_c((Object)item) : "";
                    }
                    if (var.endsWith("name")) {
                        String arrows = itemStack != null && itemStack.func_77973_b() == Items.field_151031_f ? " (" + EntityHelper.getItemCountInInventory((IInventory)this.player.field_71071_by, (Item)Items.field_151032_g) + ")" : "";
                        return itemStack != null ? itemStack.func_82833_r() + arrows : "";
                    }
                    if (var.endsWith("maxdamage")) {
                        return Integer.toString(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77958_k() + 1 : 0);
                    }
                    if (var.endsWith("damage")) {
                        return Integer.toString(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77952_i() : 0);
                    }
                    if (var.endsWith("damageleft")) {
                        return Integer.toString(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77958_k() + 1 - itemStack.func_77952_i() : 0);
                    }
                } else {
                    if (var.equalsIgnoreCase("equippedquantity")) {
                        ItemStack item = this.player.func_71045_bC();
                        if (item != null) {
                            return Integer.toString(EntityHelper.getItemCountInInventory((IInventory)this.player.field_71071_by, (Item)item.func_77973_b(), (int)item.func_77960_j()));
                        }
                        return "0";
                    }
                    if (var.matches("potioneffect\\d+")) {
                        int index = Integer.parseInt(var.substring(12));
                        if (this.potionEffects.length > index) {
                            String str = StatCollector.func_74838_a((String)this.potionEffects[index].func_76453_d());
                            switch (this.potionEffects[index].func_76458_c()) {
                                case 1: {
                                    str = str + " II";
                                    break;
                                }
                                case 2: {
                                    str = str + " III";
                                    break;
                                }
                                case 3: {
                                    str = str + " IV";
                                }
                            }
                            return str;
                        }
                        return "";
                    }
                    if (var.matches("potionduration\\d+")) {
                        int index = Integer.parseInt(var.substring(14));
                        if (this.potionEffects.length > index) {
                            return Potion.func_76389_a((PotionEffect)this.potionEffects[index]);
                        }
                        return "0:00";
                    }
                    if (var.matches("potiondurationticks\\d+")) {
                        int index = Integer.parseInt(var.substring(19));
                        if (this.potionEffects.length > index) {
                            return Integer.toString(this.potionEffects[index].func_76459_b());
                        }
                        return "0";
                    }
                    if (var.equalsIgnoreCase("memmax")) {
                        return Long.toString(Runtime.getRuntime().maxMemory());
                    }
                    if (var.equalsIgnoreCase("memtotal")) {
                        return Long.toString(Runtime.getRuntime().totalMemory());
                    }
                    if (var.equalsIgnoreCase("memfree")) {
                        return Long.toString(Runtime.getRuntime().freeMemory());
                    }
                    if (var.equalsIgnoreCase("memused")) {
                        return Long.toString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                    }
                    if (var.equalsIgnoreCase("server")) {
                        String str = this.player.field_71174_a.func_147298_b().func_74430_c().toString();
                        int i = str.indexOf("/");
                        int j = str.indexOf(":");
                        if (i < 0) {
                            return "localhost";
                        }
                        String name = i == 0 ? str.substring(i + 1, j) : str.substring(0, i);
                        String port = str.substring(j + 1);
                        return name + (port.equals("25565") ? "" : ":" + port);
                    }
                    if (var.equalsIgnoreCase("servername")) {
                        String str = this.player.field_71174_a.func_147298_b().func_74430_c().toString();
                        int i = str.indexOf("/");
                        if (i < 0) {
                            return "localhost";
                        }
                        if (i == 0) {
                            return str.substring(i + 1, str.indexOf(":"));
                        }
                        return str.substring(0, i);
                    }
                    if (var.equalsIgnoreCase("serverip")) {
                        String str = this.player.field_71174_a.func_147298_b().func_74430_c().toString();
                        int i = str.indexOf("/");
                        if (i < 0) {
                            return "127.0.0.1";
                        }
                        return str.substring(i + 1, str.indexOf(":"));
                    }
                    if (var.equalsIgnoreCase("serverport")) {
                        String str = this.player.field_71174_a.func_147298_b().func_74430_c().toString();
                        int i = str.indexOf("/");
                        if (i < 0) {
                            return "-1";
                        }
                        return str.substring(str.indexOf(":") + 1);
                    }
                    if (var.equalsIgnoreCase("black")) {
                        return "\u00a70";
                    }
                    if (var.equalsIgnoreCase("darkblue") || var.equalsIgnoreCase("navy")) {
                        return "\u00a71";
                    }
                    if (var.equalsIgnoreCase("darkgreen") || var.equalsIgnoreCase("green")) {
                        return "\u00a72";
                    }
                    if (var.equalsIgnoreCase("darkaqua") || var.equalsIgnoreCase("darkcyan") || var.equalsIgnoreCase("turquoise")) {
                        return "\u00a73";
                    }
                    if (var.equalsIgnoreCase("darkred")) {
                        return "\u00a74";
                    }
                    if (var.equalsIgnoreCase("purple") || var.equalsIgnoreCase("violet")) {
                        return "\u00a75";
                    }
                    if (var.equalsIgnoreCase("orange") || var.equalsIgnoreCase("gold")) {
                        return "\u00a76";
                    }
                    if (var.equalsIgnoreCase("lightgrey") || var.equalsIgnoreCase("lightgray") || var.equalsIgnoreCase("grey") || var.equalsIgnoreCase("gray")) {
                        return "\u00a77";
                    }
                    if (var.equalsIgnoreCase("darkgrey") || var.equalsIgnoreCase("darkgray") || var.equalsIgnoreCase("charcoal")) {
                        return "\u00a78";
                    }
                    if (var.equalsIgnoreCase("blue") || var.equalsIgnoreCase("lightblue") || var.equalsIgnoreCase("indigo")) {
                        return "\u00a79";
                    }
                    if (var.equalsIgnoreCase("brightgreen") || var.equalsIgnoreCase("lightgreen") || var.equalsIgnoreCase("lime")) {
                        return "\u00a7a";
                    }
                    if (var.equalsIgnoreCase("aqua") || var.equalsIgnoreCase("cyan") || var.equalsIgnoreCase("celeste") || var.equalsIgnoreCase("diamond")) {
                        return "\u00a7b";
                    }
                    if (var.equalsIgnoreCase("red") || var.equalsIgnoreCase("lightred") || var.equalsIgnoreCase("salmon")) {
                        return "\u00a7c";
                    }
                    if (var.equalsIgnoreCase("magenta") || var.equalsIgnoreCase("pink")) {
                        return "\u00a7d";
                    }
                    if (var.equalsIgnoreCase("yellow")) {
                        return "\u00a7e";
                    }
                    if (var.equalsIgnoreCase("white")) {
                        return "\u00a7f";
                    }
                    if (var.equalsIgnoreCase("random")) {
                        return "\u00a7k";
                    }
                    if (var.equalsIgnoreCase("bold") || var.equalsIgnoreCase("b")) {
                        return "\u00a7l";
                    }
                    if (var.equalsIgnoreCase("strikethrough") || var.equalsIgnoreCase("strike") || var.equalsIgnoreCase("s")) {
                        return "\u00a7m";
                    }
                    if (var.equalsIgnoreCase("underline") || var.equalsIgnoreCase("u")) {
                        return "\u00a7n";
                    }
                    if (var.equalsIgnoreCase("italic") || var.equalsIgnoreCase("italics") || var.equalsIgnoreCase("i")) {
                        return "\u00a7o";
                    }
                    if (var.equalsIgnoreCase("reset") || var.equalsIgnoreCase("r")) {
                        return "\u00a7r";
                    }
                }
            }
        }
        catch (Exception e) {
            return "null";
        }
        return "{" + var + "}";
    }
}

