/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Value {
    public ValueType type = ValueType.NONE;
    public String value = "";
    public List<Value> values = new ArrayList<Value>();

    public Value(ValueType type, String value) {
        this.type = type;
        this.value = value;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "[%s] '%s'", new Object[]{this.type, this.value});
    }

    public static enum ValueType {
        NONE,
        STR,
        NUM,
        VAR,
        IF,
        NOT,
        AND,
        OR,
        XOR,
        GREATER,
        LESSER,
        EQUAL,
        PCT,
        CONCAT,
        MAX,
        MIN,
        ADD,
        SUB,
        MUL,
        DIV,
        ROUND,
        MOD,
        MODI,
        ITEMQUANTITY,
        TRANS;


        public static ValueType fromString(String str) {
            if (str.matches("(?i)(str|string)")) {
                return STR;
            }
            if (str.matches("(?i)(num|number|int|integer|float|double)")) {
                return NUM;
            }
            if (str.matches("(?i)(var|variable)")) {
                return VAR;
            }
            if (str.matches("(?i)(if)")) {
                return IF;
            }
            if (str.matches("(?i)(not)")) {
                return NOT;
            }
            if (str.matches("(?i)(and)")) {
                return AND;
            }
            if (str.matches("(?i)(or)")) {
                return OR;
            }
            if (str.matches("(?i)(xor)")) {
                return XOR;
            }
            if (str.matches("(?i)(greater)")) {
                return GREATER;
            }
            if (str.matches("(?i)(less|lesser)")) {
                return LESSER;
            }
            if (str.matches("(?i)(equals?)")) {
                return EQUAL;
            }
            if (str.matches("(?i)(pct|percent|percentage)")) {
                return PCT;
            }
            if (str.matches("(?i)(concat)")) {
                return CONCAT;
            }
            if (str.matches("(?i)(max|maximum)")) {
                return MAX;
            }
            if (str.matches("(?i)(min|minimum)")) {
                return MIN;
            }
            if (str.matches("(?i)(add)")) {
                return ADD;
            }
            if (str.matches("(?i)(sub)")) {
                return SUB;
            }
            if (str.matches("(?i)(mul)")) {
                return MUL;
            }
            if (str.matches("(?i)(div)")) {
                return DIV;
            }
            if (str.matches("(?i)(round)")) {
                return ROUND;
            }
            if (str.matches("(?i)(mod|modulo)")) {
                return MOD;
            }
            if (str.matches("(?i)(imod|intmod|imodulo|intmodulo|modi|modint|moduloi|moduloint)")) {
                return MODI;
            }
            if (str.matches("(?i)(itemquantity)")) {
                return ITEMQUANTITY;
            }
            if (str.matches("(?i)(trans|translate)")) {
                return TRANS;
            }
            return NONE;
        }
    }
}

