/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.command;

import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.InGameInfoXML;
import com.github.lunatrius.ingameinfo.Ticker;
import com.github.lunatrius.ingameinfo.config.Config;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class InGameInfoCommand
extends CommandBase {
    private InGameInfoCore core;

    public InGameInfoCommand(InGameInfoCore core) {
        this.core = core;
    }

    public String func_71517_b() {
        return "igi";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "commands.igi.usage";
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return InGameInfoCommand.func_71530_a((String[])args, (String[])new String[]{"reload", "load", "save", "enable", "disable"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("load")) {
                return InGameInfoCommand.func_71531_a((String[])args, this.getFilenames());
            }
            if (args[0].equalsIgnoreCase("save")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"InGameInfo.xml", "InGameInfo.json", "InGameInfo.txt"});
            }
        }
        return null;
    }

    private List<String> getFilenames() {
        File[] files = this.core.getConfigDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("InGameInfo") && (name.endsWith(".xml") || name.endsWith(".json") || name.endsWith(".txt"));
            }
        });
        ArrayList<String> filenames = new ArrayList<String>();
        for (File file : files) {
            filenames.add(file.getName());
        }
        return filenames;
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.igi.reload", new Object[0]));
                this.core.reloadConfig();
                return;
            }
            if (args[0].equalsIgnoreCase("load")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.igi.load", new Object[]{args[1]}));
                if (this.core.loadConfig(args[1])) {
                    Config config = InGameInfoXML.instance.config;
                    config.setConfigName(args[1]);
                    config.save();
                }
                return;
            }
            if (args[0].equalsIgnoreCase("save")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.igi.save", new Object[]{args[1]}));
                this.core.saveConfig(args[1]);
                return;
            }
            if (args[0].equalsIgnoreCase("enable")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.igi.enable", new Object[0]));
                Ticker.enabled = true;
                return;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.igi.disable", new Object[0]));
                Ticker.enabled = false;
                return;
            }
        }
        throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
    }

    public int compareTo(Object obj) {
        return 0;
    }
}

