/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.xml;

import com.github.lunatrius.ingameinfo.InGameInfoXML;
import com.github.lunatrius.ingameinfo.Utils;
import com.github.lunatrius.ingameinfo.Value;
import com.github.lunatrius.ingameinfo.parser.IParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlParser
implements IParser {
    private Document document;

    @Override
    public boolean load(File file) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.document = dBuilder.parse(file);
            this.document.getDocumentElement().normalize();
        }
        catch (Exception e) {
            InGameInfoXML.logger.log(Level.FATAL, "Could not read xml configuration file!", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean parse(Map<String, List<List<Value>>> format) {
        Element documentElement = this.document.getDocumentElement();
        NodeList nodeListLines = documentElement.getChildNodes();
        for (int i = 0; i < nodeListLines.getLength(); ++i) {
            String position;
            Element elementLines = this.getElement(nodeListLines.item(i), "lines");
            if (elementLines == null || (position = Utils.getPosition(elementLines.getAttribute("at"))) == null) continue;
            format.put(position, this.getLines(elementLines));
        }
        return true;
    }

    private List<List<Value>> getLines(Element element) {
        ArrayList<List<Value>> listLines = new ArrayList<List<Value>>();
        NodeList nodeListLine = element.getChildNodes();
        for (int i = 0; i < nodeListLine.getLength(); ++i) {
            Element elementLine = this.getElement(nodeListLine.item(i), "line");
            if (elementLine == null) continue;
            listLines.add(this.getValues(elementLine));
        }
        return listLines;
    }

    private List<Value> getValues(Element element) {
        ArrayList<Value> values = new ArrayList<Value>();
        NodeList nodeListValues = element.getChildNodes();
        for (int i = 0; i < nodeListValues.getLength(); ++i) {
            Value.ValueType type;
            Element elementValue = this.getElement(nodeListValues.item(i));
            if (elementValue == null) continue;
            if (elementValue.getNodeName().equalsIgnoreCase("value")) {
                type = Value.ValueType.fromString(elementValue.getAttribute("type"));
                if (type == Value.ValueType.NONE) {
                    continue;
                }
            } else {
                type = Value.ValueType.fromString(elementValue.getNodeName());
                if (type == Value.ValueType.NONE) {
                    type = Value.ValueType.VAR;
                }
            }
            String value = "";
            if (type == Value.ValueType.STR || type == Value.ValueType.NUM || type == Value.ValueType.VAR || type == Value.ValueType.TRANS) {
                value = Utils.unescapeValue(elementValue.getTextContent(), false);
            }
            Value val = new Value(type, value);
            val.values = this.getValues(elementValue);
            values.add(val);
        }
        return values;
    }

    private Element getElement(Node node) {
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    private Element getElement(Node node, String name) {
        Element element = this.getElement(node);
        if (element != null && element.getNodeName().equalsIgnoreCase(name)) {
            return element;
        }
        return null;
    }
}

