/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.serializer.xml;

import com.github.lunatrius.ingameinfo.InGameInfoXML;
import com.github.lunatrius.ingameinfo.Utils;
import com.github.lunatrius.ingameinfo.Value;
import com.github.lunatrius.ingameinfo.serializer.ISerializer;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSerializer
implements ISerializer {
    @Override
    public boolean save(File file, Map<String, List<List<Value>>> format) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element config = doc.createElement("config");
            this.appendLines(doc, config, format);
            doc.appendChild(config);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(source, streamResult);
            return true;
        }
        catch (Exception e) {
            InGameInfoXML.logger.log(Level.FATAL, "Could not save xml configuration file!", (Throwable)e);
            return false;
        }
    }

    private void appendLines(Document doc, Element config, Map<String, List<List<Value>>> format) {
        for (String alignment : Utils.ALIGNEMENTS) {
            if (!format.containsKey(alignment)) continue;
            Element elementLines = doc.createElement("lines");
            elementLines.setAttribute("at", alignment);
            this.appendLine(doc, elementLines, format.get(alignment));
            config.appendChild(elementLines);
        }
    }

    private void appendLine(Document doc, Element elementLines, List<List<Value>> lines) {
        for (List<Value> line : lines) {
            Element elementLine = doc.createElement("line");
            this.appendValues(doc, elementLine, line);
            elementLines.appendChild(elementLine);
        }
    }

    private void appendValues(Document doc, Element elementValues, List<Value> values) {
        for (Value value : values) {
            Element elementValue = doc.createElement(value.type.toString().toLowerCase());
            elementValue.setTextContent(Utils.escapeValue(value.value, false));
            if (value.values.size() > 0) {
                this.appendValues(doc, elementValue, value.values);
            }
            elementValues.appendChild(elementValue);
        }
    }
}

