/*
 * Decompiled with CFR 0.152.
 */
package assets.quidcraft.entities;

import assets.quidcraft.Quidcraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBroom
extends Entity {
    private int broomPosRotationIncrements;
    private double broomX;
    private double broomY;
    private double broomZ;
    private double broomYaw;
    private double broomPitch;
    public boolean isGoingUp;
    public boolean isGoingDown;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private boolean isEmpty;

    public EntityBroom(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.3f, 0.6f);
        this.isEmpty = true;
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityBroom(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public double func_70042_X() {
        return 0.0;
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + i * 10.0f);
            this.func_70018_K();
            if (damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamageTaken(100.0f);
            }
            if (this.getDamageTaken() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.func_145778_a(Quidcraft.proxy.Broom, 1, 0.0f);
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (this.isEmpty) {
            this.broomPosRotationIncrements = i + 5;
        } else {
            double d3 = d - this.field_70165_t;
            double d4 = d1 - this.field_70163_u;
            double d5 = d2 - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.broomPosRotationIncrements = 3;
        }
        this.broomX = d;
        this.broomY = d1;
        this.broomZ = d2;
        this.broomYaw = f;
        this.broomPitch = f1;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double d, double d1, double d2) {
        this.velocityX = this.field_70159_w = d;
        this.velocityY = this.field_70181_x = d1;
        this.velocityZ = this.field_70179_y = d2;
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != par1EntityPlayer) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            par1EntityPlayer.func_70078_a((Entity)this);
        }
        return true;
    }

    public void setDamageTaken(float par1) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(par1));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double d1 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K && this.isEmpty) {
            if (this.broomPosRotationIncrements > 0) {
                double d4 = this.field_70165_t + (this.broomX - this.field_70165_t) / (double)this.broomPosRotationIncrements;
                double d10 = this.field_70163_u + (this.broomY - this.field_70163_u) / (double)this.broomPosRotationIncrements;
                double d13 = this.field_70161_v + (this.broomZ - this.field_70161_v) / (double)this.broomPosRotationIncrements;
                double d17 = MathHelper.func_76138_g((double)(this.broomYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d17 / (double)this.broomPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.broomPitch - (double)this.field_70125_A) / (double)this.broomPosRotationIncrements);
                --this.broomPosRotationIncrements;
                this.func_70107_b(d4, d10, d13);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double d5 = this.field_70165_t + this.field_70159_w;
                double d11 = this.field_70163_u + this.field_70181_x;
                double d14 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d5, d11, d14);
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        } else {
            double var14;
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                double d4 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
                double d5 = ((EntityLivingBase)this.field_70153_n).field_70702_br;
                double d0 = -Math.sin(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
                double d11 = Math.cos(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
                this.field_70159_w += (d5 * d11 + d0 * d4) * 0.08;
                this.field_70179_y += (d4 * d11 - d0 * d5) * 0.08;
            }
            if (this.field_70153_n != null) {
                double acc = 0.05;
                if (this.field_70123_F) {
                    this.field_70181_x += acc;
                }
                if (Math.abs(this.field_70181_x) <= 1.0) {
                    if (this.isGoingUp) {
                        this.field_70181_x += acc;
                    } else if (!this.field_70122_E && this.isGoingDown) {
                        this.field_70181_x -= acc;
                    }
                } else if (this.field_70181_x < 0.0) {
                    this.field_70181_x += acc;
                } else if (this.field_70181_x > 0.0) {
                    this.field_70181_x -= acc;
                }
                if (!(this.isGoingUp || this.isGoingDown || this.field_70123_F)) {
                    if (this.field_70181_x > 0.0) {
                        this.field_70181_x -= acc;
                        if (this.field_70181_x < 0.0) {
                            this.field_70181_x = 0.0;
                        }
                    } else {
                        this.field_70181_x += acc;
                        if (this.field_70181_x > 0.0) {
                            this.field_70181_x = 0.0;
                        }
                    }
                }
            } else {
                if (!this.field_70122_E) {
                    this.field_70181_x -= 0.1;
                    if (this.field_70181_x < -0.5) {
                        this.field_70181_x = -0.5;
                    }
                }
                this.field_70159_w *= 0.5;
                this.field_70179_y *= 0.5;
                this.isGoingDown = false;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && d1 > 1.0 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                this.func_145778_a(Items.field_151015_O, 1, 0.0f);
                this.func_145778_a(Items.field_151055_y, 2, 0.0f);
            }
            this.field_70125_A = 0.0f;
            double rot = this.field_70177_z;
            double difX = this.field_70169_q - this.field_70165_t;
            double difZ = this.field_70166_s - this.field_70161_v;
            if (difX * difX + difZ * difZ > 0.001) {
                rot = (float)(Math.atan2(difZ, difX) * 180.0 / Math.PI);
            }
            if ((var14 = MathHelper.func_76138_g((double)(rot - (double)this.field_70177_z))) > 20.0) {
                var14 = 20.0;
            }
            if (var14 < -20.0) {
                var14 = -20.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + var14);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
                if (list != null && !list.isEmpty()) {
                    for (int j1 = 0; j1 < list.size(); ++j1) {
                        Entity entity = (Entity)list.get(j1);
                        if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityBroom)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean par1) {
        this.isEmpty = par1;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }
}

