/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.slimemodssp.platform;

import com.chunkbase.mod.forge.mods.slimemodssp.ModSettings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModSettingsForge
implements ModSettings {
    private static final String COMMENT_LOGGING = "Enable logging to file";
    private static final String KEY_LOGGING = "logging";
    public static final String KEY_SEED = "seed";
    public static final String COMMENT_SEED = "Seed to use in multiplayer";
    private Configuration forgeConfig;
    private boolean advancedLogging = false;
    private Long fallbackSeed = null;

    public ModSettingsForge(Configuration forgeConfig) {
        this.forgeConfig = forgeConfig;
        forgeConfig.load();
        this.syncWithForge();
    }

    @Override
    public boolean isAdvancedLoggingEnabled() {
        return this.advancedLogging;
    }

    @Override
    public Long getFallbackSeed() {
        return this.fallbackSeed;
    }

    private void saveToForge() {
        this.forgeConfig.removeCategory(this.forgeConfig.getCategory("general"));
        this.syncWithForge();
    }

    private void syncWithForge() {
        Property logging = this.forgeConfig.get("general", KEY_LOGGING, this.advancedLogging);
        logging.comment = COMMENT_LOGGING;
        this.advancedLogging = logging.getBoolean(this.advancedLogging);
        String curSeed = "";
        if (this.fallbackSeed != null) {
            curSeed = "" + this.fallbackSeed;
        }
        Property seed = this.forgeConfig.get("general", KEY_SEED, curSeed);
        seed.comment = COMMENT_SEED;
        String newSeed = seed.getString();
        if (newSeed.length() < 1) {
            this.fallbackSeed = null;
        } else {
            try {
                long tmp = Long.parseLong(newSeed);
                if (tmp != 0L) {
                    this.fallbackSeed = tmp;
                }
            }
            catch (NumberFormatException numberformatexception) {
                this.fallbackSeed = newSeed.hashCode();
            }
        }
        this.forgeConfig.save();
    }
}

