/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica;

import com.github.lunatrius.schematica.BlockInfo;
import com.github.lunatrius.schematica.Settings;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandlerMP;
import org.lwjgl.util.vector.Vector3f;

public class SchematicWorld
extends World {
    private static final AnvilSaveHandler anvilSaveHandler = new AnvilSaveHandler(Minecraft.func_71410_x().field_71412_D, "tmp/schematica", false);
    private static final WorldSettings worldSettings = new WorldSettings(0L, WorldSettings.GameType.CREATIVE, false, false, WorldType.field_77138_c);
    private static final Comparator<ItemStack> blockListComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStackA, ItemStack itemStackB) {
            return itemStackA.func_77977_a().compareTo(itemStackB.func_77977_a());
        }
    };
    protected static final List<Integer> blockListIgnoreID = new ArrayList<Integer>();
    protected static final List<Integer> blockListIgnoreMetadata = new ArrayList<Integer>();
    protected static final Map<Integer, Integer> blockListMapping = new HashMap<Integer, Integer>();
    private final Settings settings = Settings.instance();
    private ItemStack icon;
    private int[][][] blocks = null;
    private int[][][] metadata = null;
    private final List<TileEntity> tileEntities = new ArrayList<TileEntity>();
    private final List<ItemStack> blockList = new ArrayList<ItemStack>();
    private short width;
    private short length;
    private short height;

    public SchematicWorld() {
        super((ISaveHandler)new SaveHandlerMP(), "Schematica", null, worldSettings, null);
        this.icon = Settings.defaultIcon.func_77946_l();
        this.tileEntities.clear();
        this.width = 0;
        this.length = 0;
        this.height = 0;
    }

    public SchematicWorld(String icon, int[][][] blocks, int[][][] metadata, List<TileEntity> tileEntities, short width, short height, short length) {
        this();
        try {
            String[] parts = icon.split(",");
            if (parts.length == 1) {
                this.icon = new ItemStack((Item)GameData.itemRegistry.get(parts[0]), 1, 0);
            } else if (parts.length == 2) {
                this.icon = new ItemStack((Item)GameData.itemRegistry.get(parts[0]), 1, Integer.parseInt(parts[1]));
            }
        }
        catch (Exception e) {
            Settings.logger.error("Failed to assign an icon!", (Throwable)e);
            this.icon = Settings.defaultIcon.func_77946_l();
        }
        this.blocks = (int[][][])blocks.clone();
        this.metadata = (int[][][])metadata.clone();
        if (tileEntities != null) {
            this.tileEntities.addAll(tileEntities);
            for (TileEntity tileEntity : this.tileEntities) {
                tileEntity.func_145834_a((World)this);
                tileEntity.func_145829_t();
            }
        }
        this.width = width;
        this.length = length;
        this.height = height;
        this.generateBlockList();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("Icon")) {
            this.icon.func_77963_c(tagCompound.func_74775_l("Icon"));
        } else {
            this.icon = Settings.defaultIcon.func_77946_l();
        }
        byte[] localBlocks = tagCompound.func_74770_j("Blocks");
        byte[] localMetadata = tagCompound.func_74770_j("Data");
        boolean extra = tagCompound.func_74764_b("Add") || tagCompound.func_74764_b("AddBlocks");
        byte[] extraBlocks = null;
        byte[] extraBlocksNibble = null;
        if (tagCompound.func_74764_b("AddBlocks")) {
            extraBlocksNibble = tagCompound.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2 + 0] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.func_74764_b("Add")) {
            extraBlocks = tagCompound.func_74770_j("Add");
        }
        this.width = tagCompound.func_74765_d("Width");
        this.length = tagCompound.func_74765_d("Length");
        this.height = tagCompound.func_74765_d("Height");
        this.blocks = new int[this.width][this.height][this.length];
        this.metadata = new int[this.width][this.height][this.length];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    this.blocks[x][y][z] = localBlocks[x + (y * this.length + z) * this.width] & 0xFF;
                    this.metadata[x][y][z] = localMetadata[x + (y * this.length + z) * this.width] & 0xFF;
                    if (!extra) continue;
                    int[] nArray = this.blocks[x][y];
                    int n = z;
                    nArray[n] = nArray[n] | (extraBlocks[x + (y * this.length + z) * this.width] & 0xFF) << 8;
                }
            }
        }
        this.tileEntities.clear();
        NBTTagList tileEntitiesList = tagCompound.func_150295_c("TileEntities", 9);
        for (int i = 0; i < tileEntitiesList.func_74745_c(); ++i) {
            TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntitiesList.func_150305_b(i));
            if (tileEntity == null) continue;
            tileEntity.func_145834_a((World)this);
            tileEntity.func_145829_t();
            this.tileEntities.add(tileEntity);
        }
        this.refreshChests();
        this.generateBlockList();
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagCompound tagCompoundIcon = new NBTTagCompound();
        this.icon.func_77955_b(tagCompoundIcon);
        tagCompound.func_74782_a("Icon", (NBTBase)tagCompoundIcon);
        tagCompound.func_74777_a("Width", this.width);
        tagCompound.func_74777_a("Length", this.length);
        tagCompound.func_74777_a("Height", this.height);
        int size = this.width * this.length * this.height;
        byte[] localBlocks = new byte[size];
        byte[] localMetadata = new byte[size];
        byte[] extraBlocks = new byte[size];
        byte[] extraBlocksNibble = new byte[(int)Math.ceil((double)size / 2.0)];
        boolean extra = false;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    localBlocks[x + (y * this.length + z) * this.width] = (byte)this.blocks[x][y][z];
                    localMetadata[x + (y * this.length + z) * this.width] = (byte)this.metadata[x][y][z];
                    extraBlocks[x + (y * this.length + z) * this.width] = (byte)(this.blocks[x][y][z] >> 8);
                    if (extraBlocks[x + (y * this.length + z) * this.width] <= 0) continue;
                    extra = true;
                }
            }
        }
        for (int i = 0; i < extraBlocksNibble.length; ++i) {
            extraBlocksNibble[i] = i * 2 + 1 < extraBlocks.length ? (byte)(extraBlocks[i * 2 + 0] << 4 | extraBlocks[i * 2 + 1]) : (byte)(extraBlocks[i * 2 + 0] << 4);
        }
        int count = 20;
        NBTTagList tileEntitiesList = new NBTTagList();
        for (TileEntity tileEntity : this.tileEntities) {
            NBTTagCompound tileEntityTagCompound = new NBTTagCompound();
            try {
                tileEntity.func_145841_b(tileEntityTagCompound);
                tileEntitiesList.func_74742_a((NBTBase)tileEntityTagCompound);
            }
            catch (Exception e) {
                int pos = tileEntity.field_145851_c + (tileEntity.field_145848_d * this.length + tileEntity.field_145849_e) * this.width;
                if (--count > 0) {
                    Block block = (Block)GameData.blockRegistry.get((int)localBlocks[pos]);
                    Settings.logger.error(String.format("Block %s[%s] with TileEntity %s failed to save! Replacing with bedrock...", block, block != null ? GameData.blockRegistry.func_148750_c((Object)block) : "?", tileEntity.getClass().getName()), (Throwable)e);
                }
                localBlocks[pos] = (byte)GameData.blockRegistry.getId((Object)Blocks.field_150357_h);
                localMetadata[pos] = 0;
                extraBlocks[pos] = 0;
            }
        }
        tagCompound.func_74778_a("Materials", "Alpha");
        tagCompound.func_74773_a("Blocks", localBlocks);
        tagCompound.func_74773_a("Data", localMetadata);
        if (extra) {
            tagCompound.func_74773_a("AddBlocks", extraBlocksNibble);
        }
        tagCompound.func_74782_a("Entities", (NBTBase)new NBTTagList());
        tagCompound.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
    }

    private void generateBlockList() {
        this.blockList.clear();
    }

    private int getBlockId(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return 0;
        }
        return this.blocks[x][y][z] & 0xFFF;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            TileEntity tileEntity = this.tileEntities.get(i);
            if (tileEntity.field_145851_c != x || tileEntity.field_145848_d != y || tileEntity.field_145849_e != z) continue;
            return tileEntity;
        }
        return null;
    }

    public int func_72925_a(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        return 15;
    }

    public float func_72801_o(int x, int y, int z) {
        return 1.0f;
    }

    public int func_72805_g(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.width || y >= this.height || z >= this.length) {
            return 0;
        }
        return this.metadata[x][y][z];
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public BiomeGenBase func_72807_a(int var1, int var2) {
        return BiomeGenBase.field_76767_f;
    }

    public int func_72800_K() {
        return this.height + 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return false;
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    public Entity func_73045_a(int var1) {
        return null;
    }

    public boolean func_72899_e(int x, int y, int z) {
        return false;
    }

    public boolean func_72921_c(int x, int y, int z, int metadata, int flag) {
        this.metadata[x][y][z] = metadata;
        return true;
    }

    public Block func_147439_a(int x, int y, int z) {
        return (Block)GameData.blockRegistry.get(this.getBlockId(x, y, z));
    }

    public void setTileEntities(List<TileEntity> tileEntities) {
        this.tileEntities.clear();
        this.tileEntities.addAll(tileEntities);
        for (TileEntity tileEntity : this.tileEntities) {
            tileEntity.func_145834_a((World)this);
            tileEntity.func_145829_t();
        }
    }

    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    public List<ItemStack> getBlockList() {
        return this.blockList;
    }

    public void refreshChests() {
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            TileEntity tileEntity = this.tileEntities.get(i);
            if (!(tileEntity instanceof TileEntityChest)) continue;
            this.checkForAdjacentChests((TileEntityChest)tileEntity);
        }
    }

    private void checkForAdjacentChests(TileEntityChest tileEntityChest) {
        tileEntityChest.field_145984_a = true;
        tileEntityChest.field_145992_i = null;
        tileEntityChest.field_145990_j = null;
        tileEntityChest.field_145991_k = null;
        tileEntityChest.field_145988_l = null;
        if (this.func_147439_a(tileEntityChest.field_145851_c - 1, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e) == Blocks.field_150486_ae) {
            tileEntityChest.field_145991_k = (TileEntityChest)this.func_147438_o(tileEntityChest.field_145851_c - 1, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e);
        }
        if (this.func_147439_a(tileEntityChest.field_145851_c + 1, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e) == Blocks.field_150486_ae) {
            tileEntityChest.field_145990_j = (TileEntityChest)this.func_147438_o(tileEntityChest.field_145851_c + 1, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e);
        }
        if (this.func_147439_a(tileEntityChest.field_145851_c, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e - 1) == Blocks.field_150486_ae) {
            tileEntityChest.field_145992_i = (TileEntityChest)this.func_147438_o(tileEntityChest.field_145851_c, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e - 1);
        }
        if (this.func_147439_a(tileEntityChest.field_145851_c, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e + 1) == Blocks.field_150486_ae) {
            tileEntityChest.field_145988_l = (TileEntityChest)this.func_147438_o(tileEntityChest.field_145851_c, tileEntityChest.field_145848_d, tileEntityChest.field_145849_e + 1);
        }
    }

    public void flip() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < (this.length + 1) / 2; ++z) {
                    int tmp = this.blocks[x][y][z];
                    this.blocks[x][y][z] = this.blocks[x][y][this.length - 1 - z];
                    this.blocks[x][y][this.length - 1 - z] = tmp;
                    if (z == this.length - 1 - z) {
                        this.metadata[x][y][z] = BlockInfo.getTransformedMetadataFlip(this.blocks[x][y][z], this.metadata[x][y][z]);
                        continue;
                    }
                    tmp = this.metadata[x][y][z];
                    this.metadata[x][y][z] = BlockInfo.getTransformedMetadataFlip(this.blocks[x][y][z], this.metadata[x][y][this.length - 1 - z]);
                    this.metadata[x][y][this.length - 1 - z] = BlockInfo.getTransformedMetadataFlip(this.blocks[x][y][this.length - 1 - z], tmp);
                }
            }
        }
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            TileEntity tileEntity = this.tileEntities.get(i);
            tileEntity.field_145849_e = this.length - 1 - tileEntity.field_145849_e;
            tileEntity.field_145847_g = this.metadata[tileEntity.field_145851_c][tileEntity.field_145848_d][tileEntity.field_145849_e];
            if (!(tileEntity instanceof TileEntitySkull) || tileEntity.field_145847_g != 1) continue;
            TileEntitySkull skullTileEntity = (TileEntitySkull)tileEntity;
            int angle = skullTileEntity.func_145906_b();
            int base = 0;
            base = angle <= 7 ? 4 : 12;
            skullTileEntity.func_145903_a(2 * base - angle & 0xF);
        }
        this.refreshChests();
    }

    public void rotate() {
        int[][][] localBlocks = new int[this.length][this.height][this.width];
        int[][][] localMetadata = new int[this.length][this.height][this.width];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    localBlocks[z][y][x] = this.blocks[this.width - 1 - x][y][z];
                    localMetadata[z][y][x] = BlockInfo.getTransformedMetadataRotation(this.blocks[this.width - 1 - x][y][z], this.metadata[this.width - 1 - x][y][z]);
                }
            }
        }
        this.blocks = localBlocks;
        this.metadata = localMetadata;
        for (int i = 0; i < this.tileEntities.size(); ++i) {
            TileEntity tileEntity = this.tileEntities.get(i);
            int coord = tileEntity.field_145851_c;
            tileEntity.field_145851_c = tileEntity.field_145849_e;
            tileEntity.field_145849_e = this.width - 1 - coord;
            tileEntity.field_145847_g = this.metadata[tileEntity.field_145851_c][tileEntity.field_145848_d][tileEntity.field_145849_e];
            if (!(tileEntity instanceof TileEntitySkull) || tileEntity.field_145847_g != 1) continue;
            TileEntitySkull skullTileEntity = (TileEntitySkull)tileEntity;
            skullTileEntity.func_145903_a(skullTileEntity.func_145906_b() + 12 & 0xF);
        }
        short tmp = this.width;
        this.width = this.length;
        this.length = tmp;
        this.refreshChests();
    }

    public int width() {
        return this.width;
    }

    public int length() {
        return this.length;
    }

    public int height() {
        return this.height;
    }

    public Vector3f dimensions() {
        return new Vector3f((float)this.width, (float)this.height, (float)this.length);
    }
}

