/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.gui;

import com.github.lunatrius.schematica.FileFilterSchematic;
import com.github.lunatrius.schematica.Settings;
import com.github.lunatrius.schematica.client.gui.GuiSchematicEntry;
import com.github.lunatrius.schematica.client.gui.GuiSchematicLoadSlot;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.Sys;

public class GuiSchematicLoad
extends GuiScreen {
    private static final FileFilterSchematic FILE_FILTER_FOLDER = new FileFilterSchematic(true);
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);
    private final Settings settings = Settings.instance();
    private final GuiScreen prevGuiScreen;
    private GuiSchematicLoadSlot guiSchematicLoadSlot;
    private GuiButton btnOpenDir = null;
    private GuiButton btnDone = null;
    private final String strTitle = I18n.func_135052_a((String)"schematica.gui.title", (Object[])new Object[0]);
    private final String strFolderInfo = I18n.func_135052_a((String)"schematica.gui.folderInfo", (Object[])new Object[0]);
    protected File currentDirectory = Settings.schematicDirectory;
    protected final List<GuiSchematicEntry> schematicFiles = new ArrayList<GuiSchematicEntry>();

    public GuiSchematicLoad(GuiScreen guiScreen) {
        this.prevGuiScreen = guiScreen;
    }

    public void func_73866_w_() {
        int id = 0;
        this.btnOpenDir = new GuiButton(id++, this.field_146294_l / 2 - 154, this.field_146295_m - 36, 150, 20, I18n.func_135052_a((String)"schematica.gui.openFolder", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnOpenDir);
        this.btnDone = new GuiButton(id++, this.field_146294_l / 2 + 4, this.field_146295_m - 36, 150, 20, I18n.func_135052_a((String)"schematica.gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnDone);
        this.guiSchematicLoadSlot = new GuiSchematicLoadSlot(this);
        this.reloadSchematics();
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l) {
            if (guiButton.field_146127_k == this.btnOpenDir.field_146127_k) {
                boolean success = false;
                try {
                    Class<?> c = Class.forName("java.awt.Desktop");
                    Object m = c.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
                    c.getMethod("browse", URI.class).invoke(m, Settings.schematicDirectory.toURI());
                }
                catch (Throwable e) {
                    success = true;
                }
                if (success) {
                    Settings.logger.info("Opening via Sys class!");
                    Sys.openURL((String)("file://" + Settings.schematicDirectory.getAbsolutePath()));
                }
            } else if (guiButton.field_146127_k == this.btnDone.field_146127_k) {
                if (this.settings.isLoadEnabled) {
                    this.loadSchematic();
                }
                this.field_146297_k.func_147108_a(this.prevGuiScreen);
            } else {
                this.guiSchematicLoadSlot.func_148147_a(guiButton);
            }
        }
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.guiSchematicLoadSlot.func_148128_a(x, y, partialTicks);
        this.func_73732_a(this.field_146289_q, this.strTitle, this.field_146294_l / 2, 4, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.strFolderInfo, this.field_146294_l / 2 - 78, this.field_146295_m - 12, 0x808080);
        super.func_73863_a(x, y, partialTicks);
    }

    public void func_146281_b() {
    }

    protected void changeDirectory(String directory) {
        this.currentDirectory = new File(this.currentDirectory, directory);
        this.reloadSchematics();
    }

    protected void reloadSchematics() {
        String name = null;
        Item item = null;
        this.schematicFiles.clear();
        try {
            if (!this.currentDirectory.getCanonicalPath().equals(Settings.schematicDirectory.getCanonicalPath())) {
                this.schematicFiles.add(new GuiSchematicEntry("..", Items.field_151129_at, 0, true));
            }
        }
        catch (IOException e) {
            Settings.logger.error("Failed to add GuiSchematicEntry!", (Throwable)e);
        }
        for (File file : this.currentDirectory.listFiles(FILE_FILTER_FOLDER)) {
            name = file.getName();
            item = file.listFiles().length == 0 ? Items.field_151133_ar : Items.field_151131_as;
            this.schematicFiles.add(new GuiSchematicEntry(name, item, 0, file.isDirectory()));
        }
        File[] files = this.currentDirectory.listFiles(FILE_FILTER_SCHEMATIC);
        if (files.length == 0) {
            this.schematicFiles.add(new GuiSchematicEntry(I18n.func_135052_a((String)"schematica.gui.noschematic", (Object[])new Object[0]), Blocks.field_150346_d, 0, false));
        } else {
            for (File file : files) {
                name = file.getName();
                this.schematicFiles.add(new GuiSchematicEntry(name, this.readSchematicIcon(file.getAbsolutePath()), file.isDirectory()));
            }
        }
    }

    private ItemStack readSchematicIcon(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            if (tagCompound != null && tagCompound.func_74764_b("Icon")) {
                ItemStack itemStack = Settings.defaultIcon.func_77946_l();
                itemStack.func_77963_c(tagCompound.func_74775_l("Icon"));
                return itemStack;
            }
        }
        catch (Exception e) {
            Settings.logger.error("Failed to read schematic icon!", (Throwable)e);
        }
        return Settings.defaultIcon.func_77946_l();
    }

    private void loadSchematic() {
        int selectedIndex = this.guiSchematicLoadSlot.selectedIndex;
        try {
            if (selectedIndex >= 0 && selectedIndex < this.schematicFiles.size()) {
                GuiSchematicEntry schematic = this.schematicFiles.get(selectedIndex);
                this.settings.loadSchematic(new File(this.currentDirectory, schematic.getName()).getCanonicalPath());
            }
        }
        catch (Exception e) {
            Settings.logger.error("Failed to load schematic!", (Throwable)e);
        }
        this.settings.moveHere();
    }
}

