/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.interfaces;

import com.minimap.interfaces.CursorBox;
import com.minimap.interfaces.InterfaceHandler;
import com.minimap.interfaces.Preset;
import com.minimap.settings.ModOptions;

public abstract class Interface {
    public CursorBox cBox;
    public String iname;
    public int id;
    public int bx;
    public int by;
    public int x;
    public int y;
    public int actualx;
    public int actualy;
    public int w0;
    public int h0;
    public int w;
    public int h;
    public int wc;
    public int hc;
    public boolean multi;
    public boolean centered;
    public boolean bcentered;
    public boolean flipped;
    public boolean bflipped;
    public boolean cflipped;
    public boolean fromRight;
    public boolean bfromRight;
    public ModOptions option;

    public Interface(String name, int w, int h, ModOptions option) {
        this(name, w, h, w, h, option);
    }

    public Interface(String name, int w, int h, int wc, int hc, ModOptions option) {
        this.iname = name;
        this.w0 = this.w = w;
        this.h0 = this.h = h;
        this.wc = wc;
        this.hc = hc;
        this.multi = wc != w || hc != h;
        this.flipped = false;
        this.cflipped = false;
        this.bflipped = false;
        InterfaceHandler.list.add(this);
        this.id = InterfaceHandler.list.indexOf(this);
        Preset preset = InterfaceHandler.presets.get(0);
        this.actualx = this.x = preset.coords[this.id][0];
        this.bx = this.x;
        this.actualy = this.y = preset.coords[this.id][1];
        this.by = this.y;
        this.bcentered = this.centered = preset.types[this.id][0];
        this.bfromRight = this.fromRight = preset.types[this.id][1];
        this.option = option;
        this.cBox = new CursorBox(3){

            @Override
            public String getString(int line) {
                switch (line) {
                    case 0: {
                        return Interface.this.iname;
                    }
                    case 1: {
                        return "Centered: " + Interface.this.centered + " (pr. C)";
                    }
                    case 2: {
                        return "Flipped: " + Interface.this.flipped + " (pr. F)";
                    }
                }
                return "";
            }
        };
    }

    public int getW(int scale) {
        return this.w;
    }

    public int getH(int scale) {
        return this.h;
    }

    public int getWC(int scale) {
        return this.wc;
    }

    public int getHC(int scale) {
        return this.hc;
    }

    public int getW0(int scale) {
        return this.w0;
    }

    public int getH0(int scale) {
        return this.h0;
    }

    public int getSize() {
        return this.w * this.h;
    }

    public void drawInterface(int width, int height, int scale) {
        if (this.fromRight) {
            this.x = width - this.x;
        }
    }
}

