/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import foxz.commandhelper.permissions.PlayerOnly;
import foxz.utils.Utils;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;

@Command(name="clone", desc="Clone operation (server side)")
public class CmdClone
extends ChMcLogger {
    public CmdClone(Object sender) {
        super(sender);
    }

    @SubCommand(desc="Add NPC(s) to clone storage", usage="<npc> <tab> [clonedname]", permissions={OpOnly.class, PlayerOnly.class, ParamCheck.class})
    public Boolean add(String[] args) {
        EntityPlayerMP player = (EntityPlayerMP)this.pcParam;
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        List<EntityNPCInterface> list = Utils.getNearbeEntityFromPlayer(EntityNPCInterface.class, player, 80);
        for (EntityNPCInterface npc : list) {
            NBTTagCompound compound;
            if (!npc.display.name.equalsIgnoreCase(args[0])) continue;
            String name = npc.display.name;
            if (args.length > 2) {
                name = args[2];
            }
            if (!npc.func_70039_c(compound = new NBTTagCompound())) {
                return false;
            }
            ServerCloneController.Instance.addClone(compound, name, tab);
            return true;
        }
        return true;
    }

    @SubCommand(desc="List NPC from clone storage", usage="<tab>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean list(String[] args) {
        this.sendmessage("--- Stored NPCs --- (server side)");
        int tab = 0;
        try {
            tab = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        for (String name : ServerCloneController.Instance.getClones(tab)) {
            this.sendmessage(name);
        }
        this.sendmessage("------------------------------------");
        return true;
    }

    @SubCommand(desc="Remove NPC from clone storage", usage="<name> <tab>", permissions={OpOnly.class, ParamCheck.class})
    public Boolean del(String[] args) {
        String nametodel = args[0];
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        boolean deleted = false;
        for (String name : ServerCloneController.Instance.getClones(tab)) {
            if (!nametodel.equalsIgnoreCase(name)) continue;
            ServerCloneController.Instance.removeClone(name, tab);
            deleted = true;
            break;
        }
        if (!ServerCloneController.Instance.removeClone(nametodel, tab)) {
            this.sendmessage(String.format("Npc '%s' wasn't found", nametodel));
            return false;
        }
        return true;
    }

    @SubCommand(desc="Spawn cloned NPC", usage="<name> <tab> [[world:]x,y,z]] [newname]", permissions={OpOnly.class, ParamCheck.class})
    public boolean spawn(String[] args) {
        String name = args[0].replaceAll("%", " ");
        int tab = 0;
        try {
            tab = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        String newname = null;
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(this.pcParam, name, tab);
        if (compound == null) {
            this.sendmessage("Unknown npc");
            return false;
        }
        World world = this.pcParam.func_130014_f_();
        BlockPos pos = this.pcParam.func_180425_c();
        if (args.length > 2) {
            String[] par;
            String location = args[2];
            if (location.contains(":")) {
                par = location.split(":");
                location = par[1];
                world = Utils.getWorld(par[0]);
                if (world == null) {
                    this.sendmessage(String.format("'%s' is an unknown world", par[0]));
                    return false;
                }
            }
            if (location.contains(",")) {
                par = location.split(",");
                if (par.length != 3) {
                    this.sendmessage("Location need be x,y,z");
                    return false;
                }
                try {
                    pos = CommandBase.func_175757_a((ICommandSender)this.pcParam, (String[])args, (int)0, (boolean)false);
                }
                catch (NumberInvalidException e) {
                    this.sendmessage("Location should be in numbers");
                    return false;
                }
                if (args.length > 3) {
                    newname = args[3];
                }
            } else {
                newname = location;
            }
        }
        if (pos.func_177958_n() == 0 && pos.func_177956_o() == 0 && pos.func_177952_p() == 0) {
            this.sendmessage("Location needed");
            return false;
        }
        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ai.setStartPos(pos);
            if (newname != null && !newname.isEmpty()) {
                npc.display.name = newname.replaceAll("%", " ");
            }
        }
        world.func_72838_d(entity);
        return true;
    }
}

