/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import foxz.command.CommandNoppes;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.enchants.EnchantInterface;
import noppes.npcs.entity.EntityChairMount;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.old.EntityNPCDwarfFemale;
import noppes.npcs.entity.old.EntityNPCDwarfMale;
import noppes.npcs.entity.old.EntityNPCElfFemale;
import noppes.npcs.entity.old.EntityNPCElfMale;
import noppes.npcs.entity.old.EntityNPCEnderman;
import noppes.npcs.entity.old.EntityNPCFurryFemale;
import noppes.npcs.entity.old.EntityNPCFurryMale;
import noppes.npcs.entity.old.EntityNPCHumanFemale;
import noppes.npcs.entity.old.EntityNPCHumanMale;
import noppes.npcs.entity.old.EntityNPCOrcFemale;
import noppes.npcs.entity.old.EntityNPCOrcMale;
import noppes.npcs.entity.old.EntityNPCVillager;
import noppes.npcs.entity.old.EntityNpcEnderchibi;
import noppes.npcs.entity.old.EntityNpcMonsterFemale;
import noppes.npcs.entity.old.EntityNpcMonsterMale;
import noppes.npcs.entity.old.EntityNpcNagaFemale;
import noppes.npcs.entity.old.EntityNpcNagaMale;
import noppes.npcs.entity.old.EntityNpcSkeleton;

@Mod(modid="customnpcs", name="CustomNpcs", version="1.8.0_alpha")
public class CustomNpcs {
    @ConfigProp(info="Disable Chat Bubbles")
    public static boolean EnableChatBubbles = true;
    @ConfigProp(info="Uses unique entities ids")
    public static boolean UseUniqueEntities = true;
    @ConfigProp(info="To use this UseUniqueEntities has to be false")
    public static int EntityStartId = 120;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    @ConfigProp
    public static boolean DisableExtraItems = false;
    @ConfigProp
    public static boolean DisableExtraBlock = false;
    public static boolean PixelMonEnabled = false;
    public static long ticks;
    @SidedProxy(clientSide="noppes.npcs.client.ClientProxy", serverSide="noppes.npcs.CommonProxy")
    public static CommonProxy proxy;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    @ConfigProp(info="Only ops can create and edit npcs")
    public static boolean OpsOnly;
    @ConfigProp(info="Default interact line. Leave empty to not have one")
    public static String DefaultInteractLine;
    @ConfigProp
    public static boolean DisableEnchants;
    @ConfigProp(info="Start Id for enchants. IDs can only range from 0-256")
    public static int EnchantStartId;
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time")
    public static int ChuckLoaders;
    public static File Dir;
    @ConfigProp(info="Set to false if you want to disable guns")
    public static boolean GunsEnabled;
    @ConfigProp(info="Enables leaves decay")
    public static boolean LeavesDecayEnabled;
    @ConfigProp(info="Enables Vine Growth")
    public static boolean VineGrowthEnabled;
    @ConfigProp(info="Enables Ice Melting")
    public static boolean IceMeltsEnabled;
    @ConfigProp(info="Normal players can use soulstone on animals")
    public static boolean SoulStoneAnimals;
    @ConfigProp(info="Type 0 = Normal, Type 1 = Solid")
    public static int HeadWearType;
    public static FMLEventChannel Channel;
    public static FMLEventChannel ChannelPlayer;
    public static ConfigLoader Config;

    public CustomNpcs() {
        instance = this;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent ev) {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCs");
        ChannelPlayer = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCsPlayer");
        MinecraftServer server = MinecraftServer.func_71276_C();
        String dir = "";
        dir = server != null ? new File(".").getAbsolutePath() : Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
        Dir = new File(dir, "customnpcs");
        Dir.mkdir();
        Config = new ConfigLoader(this.getClass(), new File(dir, "config"), "CustomNpcs");
        Config.loadConfig();
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScriptController());
        FMLCommonHandler.instance().bus().register((Object)new ServerTickHandler());
        PixelMonEnabled = Loader.isModLoaded((String)"pixelmon");
        this.registerNpc(EntityNPCHumanMale.class, "npchumanmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCVillager.class, "npcvillager", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcPony.class, "npcpony", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCHumanFemale.class, "npchumanfemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCDwarfMale.class, "npcdwarfmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCFurryMale.class, "npcfurrymale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcMonsterMale.class, "npczombiemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcMonsterFemale.class, "npczombiefemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcSkeleton.class, "npcskeleton", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCDwarfFemale.class, "npcdwarffemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCFurryFemale.class, "npcfurryfemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCOrcMale.class, "npcorcfmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCOrcFemale.class, "npcorcfemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCElfMale.class, "npcelfmale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCElfFemale.class, "npcelffemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcCrystal.class, "npccrystal", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcEnderchibi.class, "npcenderchibi", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcNagaMale.class, "npcnagamale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcNagaFemale.class, "npcnagafemale", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcSlime.class, "NpcSlime", CustomNpcs.getEntityId());
        this.registerNpc(EntityNpcDragon.class, "NpcDragon", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCEnderman.class, "npcEnderman", CustomNpcs.getEntityId());
        this.registerNpc(EntityNPCGolem.class, "npcGolem", CustomNpcs.getEntityId());
        this.registerNpc(EntityCustomNpc.class, "CustomNpc", CustomNpcs.getEntityId());
        this.registerNpc(EntityChairMount.class, "CustomNpcChairMount", CustomNpcs.getEntityId());
        ArrayList<BiomeGenBase> list = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase base : BiomeGenBase.func_150565_n()) {
            if (base == null) continue;
            list.add(base);
        }
        int thowid = CustomNpcs.getEntityId();
        EntityRegistry.registerGlobalEntityID(EntityProjectile.class, (String)"throwableitem", (int)thowid);
        EntityRegistry.registerModEntity(EntityProjectile.class, (String)"throwableitem", (int)thowid, (Object)this, (int)64, (int)3, (boolean)true);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkController());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent ev) {
        EnchantInterface.load();
        CustomItems.load();
        proxy.load();
        new RecipeController();
    }

    @Mod.EventHandler
    public void setAboutToStart(FMLServerAboutToStartEvent event) {
        ChunkController.instance.clear();
        new QuestController();
        new PlayerDataController();
        new FactionController();
        new TransportController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        ScriptController.Instance.loadCategories();
        ScriptController.HasStart = false;
        Set names = Block.field_149771_c.func_148742_b();
        for (Object name : names) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)name.toString());
            if (block instanceof BlockLeavesBase) {
                block.func_149675_a(LeavesDecayEnabled);
            }
            if (block instanceof BlockVine) {
                block.func_149675_a(VineGrowthEnabled);
            }
            if (!(block instanceof BlockIce)) continue;
            block.func_149675_a(IceMeltsEnabled);
        }
    }

    @Mod.EventHandler
    public void started(FMLServerStartedEvent event) {
        RecipeController.instance.load();
        new DialogController();
        new BankController();
        QuestController.instance.load();
        ScriptController.HasStart = true;
        ServerCloneController.Instance = new ServerCloneController();
    }

    @Mod.EventHandler
    public void stopped(FMLServerStoppedEvent event) {
        ServerCloneController.Instance = null;
    }

    @Mod.EventHandler
    public void serverstart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandNoppes());
    }

    public static int getEntityId() {
        if (UseUniqueEntities) {
            return EntityRegistry.findGlobalUniqueEntityId();
        }
        return EntityStartId++;
    }

    private void registerNpc(Class<? extends Entity> cl, String name, int id) {
        EntityRegistry.registerGlobalEntityID(cl, (String)name, (int)id);
        EntityRegistry.registerModEntity(cl, (String)name, (int)id, (Object)this, (int)80, (int)3, (boolean)true);
    }

    public static File getWorldSaveDirectory() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        File saves = new File(".");
        if (server != null && !server.func_71262_S()) {
            saves = new File(Minecraft.func_71410_x().field_71412_D, "saves");
        }
        if (server != null) {
            File savedir = new File(new File(saves, server.func_71270_I()), "customnpcs");
            if (!savedir.exists()) {
                savedir.mkdir();
            }
            return savedir;
        }
        return null;
    }

    static {
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = false;
        DefaultInteractLine = "Hello @p";
        DisableEnchants = false;
        EnchantStartId = 100;
        ChuckLoaders = 20;
        GunsEnabled = true;
        LeavesDecayEnabled = true;
        VineGrowthEnabled = true;
        IceMeltsEnabled = true;
        SoulStoneAnimals = true;
        HeadWearType = 1;
    }
}

