/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class DataDisplay {
    EntityNPCInterface npc;
    public String name;
    public String title = "";
    public byte skinType = 0;
    public String url = "";
    public GameProfile playerProfile;
    public String texture = "customnpcs:textures/entity/humanmale/Steve.png";
    public String cloakTexture = "";
    public String glowTexture = "";
    public int visible = 0;
    public int modelSize = 5;
    public int showName = 0;
    public boolean NoLivingAnimation = false;
    public byte showBossBar = 0;

    public DataDisplay(EntityNPCInterface npc) {
        this.npc = npc;
        String[] names = new String[]{"Noppes", "Noppes", "Noppes", "Noppes", "Atesson", "Rothcersul", "Achdranys", "Pegato", "Chald", "Gareld", "Nalworche", "Ineald", "Tia'kim", "Torerod", "Turturdar", "Ranler", "Dyntan", "Oldrake", "Gharis", "Elmn", "Tanal", "Waran-ess", "Ach-aldhat", "Athi", "Itageray", "Tasr", "Ightech", "Gakih", "Adkal", "Qua'an", "Sieq", "Urnp", "Rods", "Vorbani", "Smaik", "Fian", "Hir", "Ristai", "Kineth", "Naif", "Issraya", "Arisotura", "Honf", "Rilfom", "Estz", "Ghatroth", "Yosil", "Darage", "Aldny", "Tyltran", "Armos", "Loxiku", "Burhat", "Tinlt", "Ightyd", "Mia", "Ken", "Karla", "Lily", "Carina", "Daniel", "Slater", "Zidane", "Valentine", "Eirina", "Carnow", "Grave", "Shadow", "Drakken", "Kaoz", "Silk", "Drake", "Oldam", "Lynxx", "Lenyx", "Winter", "Seth", "Apolitho", "Amethyst", "Ankin", "Seinkan", "Ayumu", "Sakamoto", "Divina", "Div", "Magia", "Magnus", "Tiakono", "Ruin", "Hailinx", "Ethan", "Wate", "Carter", "William", "Brion", "Sparrow", "Basrrelen", "Gyaku", "Claire", "Crowfeather", "Blackwell", "Raven", "Farcri", "Lucas", "Bangheart", "Kamoku", "Kyoukan", "Blaze", "Benjamin", "Larianne", "Kakaragon", "Melancholy", "Epodyno", "Thanato", "Mika", "Dacks", "Ylander", "Neve", "Meadow", "Cuero", "Embrera", "Eldamore", "Faolan", "Chim", "Nasu", "Kathrine", "Ariel", "Arei", "Demytrix", "Kora", "Ava", "Larson", "Leonardo", "Wyrl", "Sakiama", "Lambton", "Kederath", "Malus", "Riplette", "Andern", "Ezall", "Lucien", "Droco", "Cray", "Tymen", "Zenix", "Entranger", "Saenorath", "Chris", "Christine", "Marble", "Mable", "Ross", "Rose", "Xalgan ", "Kennet"};
        this.name = names[new Random().nextInt(names.length)];
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Name", this.name);
        nbttagcompound.func_74778_a("Title", this.title);
        nbttagcompound.func_74778_a("SkinUrl", this.url);
        nbttagcompound.func_74778_a("Texture", this.texture);
        nbttagcompound.func_74778_a("CloakTexture", this.cloakTexture);
        nbttagcompound.func_74778_a("GlowTexture", this.glowTexture);
        nbttagcompound.func_74774_a("UsingSkinUrl", this.skinType);
        if (this.playerProfile != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)nbttagcompound1, (GameProfile)this.playerProfile);
            nbttagcompound.func_74782_a("SkinUsername", (NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74768_a("Size", this.modelSize);
        nbttagcompound.func_74768_a("ShowName", this.showName);
        nbttagcompound.func_74768_a("NpcVisible", this.visible);
        nbttagcompound.func_74757_a("NoLivingAnimation", this.NoLivingAnimation);
        nbttagcompound.func_74774_a("BossBar", this.showBossBar);
        return nbttagcompound;
    }

    public void readToNBT(NBTTagCompound nbttagcompound) {
        this.name = nbttagcompound.func_74779_i("Name");
        this.title = nbttagcompound.func_74779_i("Title");
        this.url = nbttagcompound.func_74779_i("SkinUrl");
        if (nbttagcompound.func_150297_b("SkinUsername", 10)) {
            this.playerProfile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkinUsername"));
        } else if (nbttagcompound.func_150297_b("SkinUsername", 8) && !StringUtils.func_151246_b((String)nbttagcompound.func_74779_i("SkinUsername"))) {
            this.playerProfile = new GameProfile(null, nbttagcompound.func_74779_i("SkinUsername"));
            this.loadProfile();
        }
        this.texture = nbttagcompound.func_74779_i("Texture");
        this.cloakTexture = nbttagcompound.func_74779_i("CloakTexture");
        this.glowTexture = nbttagcompound.func_74779_i("GlowTexture");
        this.skinType = nbttagcompound.func_74771_c("UsingSkinUrl");
        this.modelSize = ValueUtil.CorrectInt(nbttagcompound.func_74762_e("Size"), 1, 30);
        this.showName = nbttagcompound.func_74762_e("ShowName");
        this.visible = nbttagcompound.func_74762_e("NpcVisible");
        this.NoLivingAnimation = nbttagcompound.func_74767_n("NoLivingAnimation");
        this.showBossBar = nbttagcompound.func_74771_c("BossBar");
        this.npc.textureLocation = null;
        this.npc.textureGlowLocation = null;
        this.npc.textureCloakLocation = null;
        this.npc.updateHitbox();
    }

    public void loadProfile() {
        GameProfile gameprofile;
        if (!(this.playerProfile == null || StringUtils.func_151246_b((String)this.playerProfile.getName()) || MinecraftServer.func_71276_C() == null || this.playerProfile.isComplete() && this.playerProfile.getProperties().containsKey((Object)"textures") || (gameprofile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(this.playerProfile.getName())) == null)) {
            Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
            if (property == null) {
                gameprofile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(gameprofile, true);
            }
            this.playerProfile = gameprofile;
        }
    }

    public boolean showName() {
        if (this.npc.isKilled()) {
            return false;
        }
        return this.showName == 0 || this.showName == 2 && this.npc.isAttacking();
    }
}

