/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogWriter {
    private static final String name = "CustomNPCs";
    private static final Logger logger = Logger.getLogger("CustomNPCs");
    private static final SimpleDateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

    public static void info(Object msg) {
        logger.log(Level.FINE, msg.toString());
    }

    public static void error(Object msg) {
        logger.log(Level.SEVERE, msg.toString());
    }

    public static void error(Object msg, Exception e) {
        logger.log(Level.SEVERE, msg.toString(), e);
    }

    public static void except(Exception e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    static {
        try {
            File file = new File("logs/CustomNPCs-latest.log");
            File file1 = new File("logs/CustomNPCs-1.log");
            File file2 = new File("logs/CustomNPCs-2.log");
            File file3 = new File("logs/CustomNPCs-3.log");
            if (file3.exists()) {
                file3.delete();
            }
            if (file2.exists()) {
                file2.renameTo(file3);
            }
            if (file1.exists()) {
                file1.renameTo(file2);
            }
            if (file.exists()) {
                file.renameTo(file1);
            }
            new SimpleFormatter();
            FileHandler handler = new FileHandler("logs/CustomNPCs-latest.log");
            handler.setLevel(Level.ALL);
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    String time = "[" + dateformat.format(new Date(record.getMillis())) + "][" + LogWriter.name + "/" + record.getLevel() + "] ";
                    if (record.getThrown() != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        return time + sw.toString();
                    }
                    return time + record.getMessage() + "\n";
                }
            });
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(handler.getFormatter());
            consoleHandler.setLevel(Level.ALL);
            logger.addHandler(consoleHandler);
            logger.setLevel(Level.ALL);
            LogWriter.info(new Date().toString());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

