/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import noppes.npcs.entity.EntityNPCInterface;

public class NoppesStringUtils {
    public static String formatText(String text, Object ... obs) {
        for (Object ob : obs) {
            if (ob instanceof EntityPlayer) {
                String username = ((EntityPlayer)ob).getDisplayNameString();
                text = text.replace("{player}", username);
                text = text.replace("@p", username);
                continue;
            }
            if (!(ob instanceof EntityNPCInterface)) continue;
            text = text.replace("@npc", ((EntityNPCInterface)((Object)ob)).func_70005_c_());
        }
        text = text.replace("&", Character.toChars(167)[0] + "");
        return text;
    }

    public static void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard arg0, Transferable arg1) {
            }
        });
    }

    public static String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
            catch (IOException ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static int nextNewLine(String s) {
        int index = s.indexOf("\n");
        int indexR = s.indexOf("\r");
        if (indexR < index) {
            index = indexR;
        }
        return 0;
    }

    public static String translate(Object ... arr) {
        String s = "";
        for (Object str : arr) {
            s = s + StatCollector.func_74838_a((String)str.toString());
        }
        return s;
    }
}

