/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NPCSpawning;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.blocks.tiles.TileBanner;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.Line;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemExcalibur;
import noppes.npcs.items.ItemShield;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.quests.QuestKill;
import noppes.npcs.roles.RoleFollower;

public class ServerEventsHandler {
    public static EntityVillager Merchant;
    public static Entity mounted;

    @SubscribeEvent
    public void invoke(EntityInteractEvent event) {
        ItemStack item = event.entityPlayer.func_71045_bC();
        if (item == null) {
            return;
        }
        boolean isRemote = event.entityPlayer.field_70170_p.field_72995_K;
        boolean npcInteracted = event.target instanceof EntityNPCInterface;
        if (!isRemote && CustomNpcs.OpsOnly && !MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(event.entityPlayer.func_146103_bH())) {
            return;
        }
        if (!isRemote && item.func_77973_b() == CustomItems.soulstoneEmpty && event.target instanceof EntityLivingBase) {
            ((ItemSoulstoneEmpty)item.func_77973_b()).store((EntityLivingBase)event.target, item, event.entityPlayer);
        }
        if (item.func_77973_b() == CustomItems.wand && npcInteracted && !isRemote) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, "customnpcs.npc.gui")) {
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.entityPlayer, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.target);
        } else if (item.func_77973_b() == CustomItems.cloner && !isRemote && !(event.target instanceof EntityPlayer)) {
            NBTTagCompound compound = new NBTTagCompound();
            if (!event.target.func_70039_c(compound)) {
                return;
            }
            PlayerData data = PlayerDataController.instance.getPlayerData(event.entityPlayer);
            ServerCloneController.Instance.cleanTags(compound);
            if (!Server.sendDataChecked((EntityPlayerMP)event.entityPlayer, EnumPacketClient.CLONE, compound)) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Entity too big to clone"));
            }
            data.cloned = compound;
            event.setCanceled(true);
        } else if (item.func_77973_b() == CustomItems.scripter && !isRemote && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, "customnpcs.npc.gui")) {
                return;
            }
            NoppesUtilServer.setEditingNpc(event.entityPlayer, (EntityNPCInterface)event.target);
            event.setCanceled(true);
            Server.sendData((EntityPlayerMP)event.entityPlayer, EnumPacketClient.GUI, EnumGuiType.Script.ordinal());
        } else if (item.func_77973_b() == CustomItems.mount) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, "customnpcs.mounter")) {
                return;
            }
            event.setCanceled(true);
            mounted = event.target;
            if (isRemote) {
                CustomNpcs.proxy.openGui(MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70165_t), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70163_u), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70161_v), EnumGuiType.MobSpawnerMounter, event.entityPlayer);
            }
        } else if (item.func_77973_b() == CustomItems.wand && event.target instanceof EntityVillager) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, "customnpcs.villager")) {
                return;
            }
            event.setCanceled(true);
            Merchant = (EntityVillager)event.target;
            if (!isRemote) {
                EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.MerchantAdd.ordinal(), player.field_70170_p, 0, 0, 0);
                MerchantRecipeList merchantrecipelist = Merchant.func_70934_b((EntityPlayer)player);
                if (merchantrecipelist != null) {
                    Server.sendData(player, EnumPacketClient.VILLAGER_LIST, merchantrecipelist);
                }
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingHurtEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (event.source.func_76363_c() || event.source.func_76347_k()) {
            return;
        }
        if (!player.func_70632_aY()) {
            return;
        }
        ItemStack item = player.func_71045_bC();
        if (item == null || !(item.func_77973_b() instanceof ItemShield)) {
            return;
        }
        if (((ItemShield)item.func_77973_b()).material.getDamageVsEntity() < player.func_70681_au().nextInt(9)) {
            return;
        }
        float damage = (float)item.func_77952_i() + event.ammount;
        item.func_77972_a((int)event.ammount, (EntityLivingBase)player);
        if (damage > (float)item.func_77958_k()) {
            event.ammount = damage - (float)item.func_77958_k();
        } else {
            event.ammount = 0.0f;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent event) {
        NBTTagCompound compound;
        NBTTagCompound compound2;
        int i;
        NBTTagList list;
        RecipeController controller;
        EntityPlayer player = event.entityPlayer;
        BlockPos pos = event.pos;
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == CustomItems.teleporter) {
            event.setCanceled(true);
        }
        if (block == Blocks.field_150462_ai && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !player.field_70170_p.field_72995_K) {
            controller = RecipeController.instance;
            list = new NBTTagList();
            i = 0;
            for (RecipeCarpentry recipe : controller.globalRecipes.values()) {
                list.func_74742_a((NBTBase)recipe.writeNBT());
                if (++i % 10 != 0) continue;
                compound2 = new NBTTagCompound();
                compound2.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound2);
                list = new NBTTagList();
            }
            if (i % 10 != 0) {
                compound = new NBTTagCompound();
                compound.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound);
            }
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_WORKBENCH, new Object[0]);
        }
        if (block == CustomItems.carpentyBench && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !player.field_70170_p.field_72995_K) {
            controller = RecipeController.instance;
            list = new NBTTagList();
            i = 0;
            for (RecipeCarpentry recipe : controller.anvilRecipes.values()) {
                list.func_74742_a((NBTBase)recipe.writeNBT());
                if (++i % 10 != 0) continue;
                compound2 = new NBTTagCompound();
                compound2.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound2);
                list = new NBTTagList();
            }
            if (i % 10 != 0) {
                compound = new NBTTagCompound();
                compound.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound);
            }
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_CARPENTRYBENCH, new Object[0]);
        }
        if ((block == CustomItems.banner || block == CustomItems.wallBanner || block == CustomItems.sign) && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            TileBanner tile;
            ItemStack item = player.field_71071_by.func_70448_g();
            if (item == null || item.func_77973_b() == null) {
                return;
            }
            int meta = block.func_176201_c(state);
            if (meta >= 7) {
                pos = pos.func_177977_b();
            }
            if (!(tile = (TileBanner)player.field_70170_p.func_175625_s(pos)).canEdit()) {
                if (item.func_77973_b() == CustomItems.wand && CustomNpcsPermissions.hasPermission(player, "customnpcs.editblocks")) {
                    tile.time = System.currentTimeMillis();
                    if (player.field_70170_p.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("availability.editIcon", new Object[0]));
                    }
                }
                return;
            }
            if (!player.field_70170_p.field_72995_K) {
                tile.icon = item.func_77946_l();
                player.field_70170_p.func_175689_h(pos);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (event.source.func_76346_g() != null) {
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                this.doExcalibur((EntityPlayer)event.source.func_76346_g(), event.entityLiving);
            }
            if (event.source.func_76346_g() instanceof EntityNPCInterface && event.entityLiving != null) {
                EntityNPCInterface npc = (EntityNPCInterface)event.source.func_76346_g();
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(line.formatTarget(event.entityLiving));
                }
                npc.script.callScript(EnumScriptType.KILLS, "target", event.entityLiving);
            }
            EntityPlayer player = null;
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                player = (EntityPlayer)event.source.func_76346_g();
            } else if (event.source.func_76346_g() instanceof EntityNPCInterface && ((EntityNPCInterface)event.source.func_76346_g()).advanced.role == EnumRoleType.Follower) {
                player = ((RoleFollower)((EntityNPCInterface)event.source.func_76346_g()).roleInterface).owner;
            }
            if (player != null) {
                this.doQuest(player, event.entityLiving, true);
                if (event.entityLiving instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)event.entityLiving);
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)event.entityLiving);
            data.saveNBTData(null);
        }
    }

    private void doExcalibur(EntityPlayer player, EntityLivingBase entity) {
        ItemStack item = player.func_71045_bC();
        if (item == null || item.func_77973_b() != CustomItems.excalibur) {
            return;
        }
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.PLAY_MUSIC, "customnpcs:songs.excalibur");
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("<" + StatCollector.func_74838_a((String)(item.func_77973_b().func_77658_a() + ".name")) + "> " + ItemExcalibur.quotes[player.func_70681_au().nextInt(ItemExcalibur.quotes.length)], new Object[0]));
    }

    private void doFactionPoints(EntityPlayer player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(EntityPlayer player, EntityLivingBase entity, boolean all) {
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        boolean change = false;
        String entityName = EntityList.func_75621_b((Entity)entity);
        for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.type != EnumQuestType.Kill && data.quest.type != EnumQuestType.AreaKill) continue;
            if (data.quest.type == EnumQuestType.AreaKill && all) {
                List list = player.field_70170_p.func_72872_a(EntityPlayer.class, entity.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
                for (EntityPlayer pl : list) {
                    if (pl == player) continue;
                    this.doQuest(pl, entity, false);
                }
            }
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            if (quest.targets.containsKey(entity.func_70005_c_())) {
                name = entity.func_70005_c_();
            } else if (!quest.targets.containsKey(name)) continue;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (killed.containsKey(name) && killed.get(name) >= quest.targets.get(name)) continue;
            int amount = 0;
            if (killed.containsKey(name)) {
                amount = killed.get(name);
            }
            killed.put(name, amount + 1);
            quest.setKilled(data, killed);
            change = true;
        }
        if (!change) {
            return;
        }
        playerdata.checkQuestCompletion(player, EnumQuestType.Kill);
    }

    @SubscribeEvent
    public void pickUp(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)event.entityPlayer).questData;
        playerdata.checkQuestCompletion(event.entityPlayer, EnumQuestType.Item);
    }

    @SubscribeEvent
    public void construct(EntityEvent.EntityConstructing event) {
        if (event.entity.field_70170_p == null || !(event.entity instanceof EntityPlayer)) {
            return;
        }
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Post event) {
        NPCSpawning.performWorldGenSpawning(event.world, event.chunkX, event.chunkZ, event.rand);
    }
}

