/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockRotated;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.client.renderer.ITileRenderer;
import noppes.npcs.constants.EnumGuiType;

public class BlockBigSign
extends BlockContainer
implements ITileRenderer {
    public int renderId = -1;
    private TileEntity renderTile;

    public BlockBigSign() {
        super(Material.field_151575_d);
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockRotated.DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BlockRotated.DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockRotated.DAMAGE);
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (par1World.field_72995_K) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && currentItem.func_77973_b() == CustomItems.wand && CustomNpcsPermissions.hasPermission(player, "customnpcs.editblocks")) {
            TileBigSign tile = (TileBigSign)par1World.func_175625_s(pos);
            tile.canEdit = true;
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.BigSign, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileBigSign tile = (TileBigSign)world.func_175625_s(pos);
        tile.rotation = l %= 4;
        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockRotated.DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            CustomNpcs.proxy.openGui(pos, EnumGuiType.BigSign, (EntityPlayer)entity);
        }
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileColorable)) {
            super.func_180654_a(world, pos);
            return;
        }
        TileColorable tile = (TileColorable)tileentity;
        int meta = tile.func_145832_p();
        float xStart = 0.0f;
        float zStart = 0.0f;
        float xEnd = 1.0f;
        float zEnd = 1.0f;
        if (tile.rotation == 0) {
            zStart = 0.87f;
        } else if (tile.rotation == 2) {
            zEnd = 0.13f;
        } else if (tile.rotation == 3) {
            xStart = 0.87f;
        } else if (tile.rotation == 1) {
            xEnd = 0.13f;
        }
        this.func_149676_a(xStart, 0.0f, zStart, xEnd, 1.0f, zEnd);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileBigSign();
    }

    @Override
    public TileEntity getTile() {
        if (this.renderTile == null) {
            this.renderTile = this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

