/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.blocks.tiles.TileWallBanner;
import noppes.npcs.client.renderer.ITileRenderer;

public class BlockWallBanner
extends BlockContainer
implements ITileRenderer {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)6);
    public int renderId = -1;
    private TileColorable renderTile;

    public BlockWallBanner() {
        super(Material.field_151576_e);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null) {
            return false;
        }
        TileWallBanner tile = (TileWallBanner)par1World.func_175625_s(pos);
        if (tile.canEdit()) {
            return true;
        }
        if (item.func_77973_b() != Items.field_151100_aR) {
            return false;
        }
        int color = EnumDyeColor.func_176766_a((int)item.func_77952_i()).func_176765_a();
        if (tile.color != color) {
            NoppesUtilServer.consumeItemStack(1, player);
            tile.color = color;
            par1World.func_175689_h(pos);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileWallBanner tile = (TileWallBanner)world.func_175625_s(pos);
        tile.rotation = l %= 4;
        tile.color = 15 - stack.func_77952_i();
        tile.time = System.currentTimeMillis();
        world.func_180501_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            ((EntityPlayer)entity).func_146105_b((IChatComponent)new ChatComponentTranslation("availability.editIcon", new Object[0]));
        }
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return this.renderId;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileWallBanner();
    }

    @Override
    public TileColorable getTile() {
        if (this.renderTile == null) {
            this.renderTile = (TileColorable)this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

