/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.blocks.BlockTrigger;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.blocks.tiles.TileNpcContainer;
import noppes.npcs.blocks.tiles.TileWeaponRack;

public class BlockWeaponRack
extends BlockTrigger {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)6);
    public static final PropertyBool IS_TOP = PropertyBool.func_177716_a((String)"istop");

    public BlockWeaponRack() {
        super(Blocks.field_150344_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (par1World.field_72995_K) {
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)IS_TOP)).booleanValue()) {
            pos = pos.func_177977_b();
        }
        TileWeaponRack tile = (TileWeaponRack)par1World.func_175625_s(pos);
        float hit = hitX;
        if (tile.rotation == 2) {
            hit = 1.0f - hitX;
        }
        if (tile.rotation == 3) {
            hit = 1.0f - hitZ;
        }
        if (tile.rotation == 1) {
            hit = hitZ;
        }
        int selected = 2 - (int)((double)hit / 0.34);
        ItemStack item = player.func_71045_bC();
        ItemStack weapon = tile.func_70301_a(selected);
        if (item == null && weapon != null) {
            tile.func_70299_a(selected, null);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, weapon);
            par1World.func_175689_h(pos);
            this.updateSurrounding(par1World, pos);
        } else {
            if (item == null || item.func_77973_b() == null || item.func_77973_b() instanceof ItemBlock) {
                return true;
            }
            if (item != null && weapon == null) {
                tile.func_70299_a(selected, item);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                par1World.func_175689_h(pos);
                this.updateSurrounding(par1World, pos);
            }
        }
        return true;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE) + ((Boolean)state.func_177229_b((IProperty)IS_TOP) != false ? 7 : 0);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta % 7)).func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(meta >= 7));
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE, IS_TOP});
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.func_175623_d(pos.func_177984_a())) {
            world.func_175698_g(pos);
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())).func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(false)), 2);
            world.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())).func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(true)), 2);
            int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            TileColorable tile = (TileColorable)world.func_175625_s(pos);
            tile.rotation = l %= 4;
        }
    }

    @Override
    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        this.func_180654_a((IBlockAccess)world, pos);
        return super.func_180640_a(world, pos, state);
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        TileEntity tileentity;
        boolean isTop = false;
        try {
            isTop = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)IS_TOP);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (isTop) {
            pos = pos.func_177977_b();
        }
        if (!((tileentity = world.func_175625_s(pos)) instanceof TileColorable)) {
            super.func_180654_a(world, pos);
            return;
        }
        TileColorable tile = (TileColorable)tileentity;
        float xStart = 0.0f;
        float zStart = 0.0f;
        float xEnd = 1.0f;
        float zEnd = 1.0f;
        if (tile.rotation == 0) {
            zStart = 0.7f;
        } else if (tile.rotation == 2) {
            zEnd = 0.3f;
        } else if (tile.rotation == 3) {
            xStart = 0.7f;
        } else if (tile.rotation == 1) {
            xEnd = 0.3f;
        }
        if (isTop) {
            this.func_149676_a(xStart, -1.0f, zStart, xEnd, 0.8f, zEnd);
        } else {
            this.func_149676_a(xStart, 0.0f, zStart, xEnd, 1.8f, zEnd);
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        if (var2 < 7) {
            return new TileWeaponRack();
        }
        return null;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)IS_TOP)).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177977_b());
        } else if (!((Boolean)state.func_177229_b((IProperty)IS_TOP)).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileNpcContainer tile = (TileNpcContainer)world.func_175625_s(pos);
        if (tile == null) {
            return;
        }
        tile.dropItems(world, pos);
        world.func_175666_e(pos, state.func_177230_c());
        super.func_180663_b(world, pos, state);
    }
}

