/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.NPCGuiHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.inventory.NPCGuiContainerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.player.GuiFaction;
import noppes.npcs.client.gui.player.GuiQuestLog;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiMenuTopIconButton;
import noppes.npcs.client.gui.util.IButtonListener;
import noppes.npcs.constants.EnumPlayerPacket;

public class ClientTickHandler {
    private World prevWorld;
    private boolean otherContainer = false;
    private GuiMenuTopButton inv;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof ContainerPlayer) {
            if (this.otherContainer) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.CheckQuestCompletion, new Object[0]);
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        GuiScreen guiscreen = mc.field_71462_r;
        if (CustomNpcs.InventoryGuiEnabled && guiscreen instanceof GuiInventory && !this.guiHasButtons(guiscreen)) {
            IButtonListener listener = new IButtonListener(){

                @Override
                public void actionPerformed(GuiButton button) {
                    Minecraft mc = Minecraft.func_71410_x();
                    if (button.field_146127_k == 112) {
                        mc.func_147108_a((GuiScreen)new GuiQuestLog((EntityPlayer)mc.field_71439_g));
                    }
                    if (button.field_146127_k == 113) {
                        mc.func_147108_a((GuiScreen)new GuiFaction());
                    }
                }
            };
            GuiInventory guiinv = (GuiInventory)guiscreen;
            int guiTop = NPCGuiContainerHelper.getTop((GuiContainer)guiinv);
            int guiLeft = NPCGuiContainerHelper.getLeft((GuiContainer)guiinv);
            List<GuiButton> list = NPCGuiHelper.getButtonList(guiscreen);
            for (GuiButton button : list) {
                if (button.field_146129_i >= guiTop || button.field_146128_h + button.func_146117_b() <= guiLeft) continue;
                guiLeft = button.field_146128_h + button.func_146117_b();
            }
            if (Loader.isModLoaded((String)"TConstruct")) {
                this.inv = new GuiMenuTopIconButton(112, guiLeft + 3, guiTop - 27, "quest.quests", listener, new ItemStack(CustomItems.letter));
                GuiMenuTopIconButton factions = new GuiMenuTopIconButton(113, this.inv, "menu.factions", listener, new ItemStack(CustomItems.wallBanner, 1, 1));
                list.add(this.inv);
                list.add(factions);
            } else {
                this.inv = new GuiMenuTopIconButton(111, guiLeft + 3, guiTop - 27, "menu.inventory", new ItemStack(Blocks.field_150462_ai));
                GuiMenuTopIconButton quests = new GuiMenuTopIconButton(112, this.inv, "quest.quests", listener, new ItemStack(CustomItems.letter));
                GuiMenuTopIconButton factions = new GuiMenuTopIconButton(113, quests, "menu.factions", listener, new ItemStack(CustomItems.wallBanner, 1, 1));
                this.inv.active = true;
                list.add(this.inv);
                list.add(quests);
                list.add(factions);
            }
        }
        ++CustomNpcs.ticks;
        if (this.prevWorld != mc.field_71441_e) {
            this.prevWorld = mc.field_71441_e;
            MusicController.Instance.stopMusic();
        }
    }

    public boolean guiHasButtons(GuiScreen guiscreen) {
        if (this.inv == null) {
            return false;
        }
        return NPCGuiHelper.getButtonList(guiscreen).contains((Object)this.inv);
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (ClientProxy.QuestLog.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r == null) {
                NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, new GuiQuestLog((EntityPlayer)mc.field_71439_g));
            } else if (mc.field_71462_r instanceof GuiQuestLog) {
                mc.func_71381_h();
            }
        }
    }
}

