/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.client.gui.model.GuiCreationParts;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.entity.EntityFakeLiving;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiCreationExtra
extends GuiCreationScreenInterface
implements ICustomScrollListener {
    private final String[] ignoredTags = new String[]{"CanBreakDoors", "Bred", "PlayerCreated", "HasReproduced"};
    private final String[] booleanTags = new String[0];
    private GuiCustomScroll scroll;
    private Map<String, GuiType> data = new HashMap<String, GuiType>();
    private GuiType selected;

    public GuiCreationExtra(EntityNPCInterface npc) {
        super(npc);
        this.active = 2;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.entity == null) {
            this.openGui(new GuiCreationParts(this.npc));
            return;
        }
        if (this.scroll == null) {
            this.data = this.getData(this.entity);
            this.scroll = new GuiCustomScroll(this, 0);
            ArrayList<String> list = new ArrayList<String>(this.data.keySet());
            this.scroll.setList(list);
            if (list.isEmpty()) {
                return;
            }
            this.scroll.setSelected((String)list.get(0));
        }
        this.selected = this.data.get(this.scroll.getSelected());
        this.scroll.guiLeft = this.guiLeft;
        this.scroll.guiTop = this.guiTop + 46;
        this.scroll.setSize(100, this.ySize - 74);
        this.addScroll(this.scroll);
        this.selected.initGui();
    }

    public Map<String, GuiType> getData(EntityLivingBase entity) {
        HashMap<String, GuiType> data = new HashMap<String, GuiType>();
        NBTTagCompound compound = this.getExtras(entity);
        Set keys = compound.func_150296_c();
        for (String name : keys) {
            byte b;
            if (this.isIgnored(name)) continue;
            NBTBase base = compound.func_74781_a(name);
            if (name.equals("Age")) {
                data.put("Child", new GuiTypeBoolean("Child", entity.func_70631_g_()));
                continue;
            }
            if (base.func_74732_a() != 1 || (b = ((NBTTagByte)base).func_150290_f()) != 0 && b != 1) continue;
            if (this.playerdata.extra.func_74764_b(name)) {
                b = this.playerdata.extra.func_74771_c(name);
            }
            data.put(name, new GuiTypeBoolean(name, b == 1));
        }
        return data;
    }

    private boolean isIgnored(String tag) {
        for (String s : this.ignoredTags) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound getExtras(EntityLivingBase entity) {
        NBTTagCompound fake = new NBTTagCompound();
        new EntityFakeLiving(entity.field_70170_p).func_70014_b(fake);
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_70014_b(compound);
        Set keys = fake.func_150296_c();
        for (String name : keys) {
            compound.func_82580_o(name);
        }
        return compound;
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll scroll) {
        this.func_73866_w_();
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        this.selected.actionPerformed(btn);
    }

    class GuiTypeByte
    extends GuiType {
        private byte b;

        public GuiTypeByte(String name, byte b) {
            super(name);
            this.b = b;
        }

        @Override
        public void initGui() {
        }

        @Override
        public void actionPerformed(GuiButton button) {
        }
    }

    class GuiTypeBoolean
    extends GuiType {
        private boolean bo;

        public GuiTypeBoolean(String name, boolean bo) {
            super(name);
            this.bo = bo;
        }

        @Override
        public void initGui() {
            GuiCreationExtra.this.addButton(new GuiNpcButtonYesNo(11, GuiCreationExtra.this.guiLeft + 120, GuiCreationExtra.this.guiTop + 50, 60, 20, this.bo));
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button.field_146127_k != 11) {
                return;
            }
            this.bo = ((GuiNpcButtonYesNo)button).getBoolean();
            if (this.name.equals("Child")) {
                GuiCreationExtra.this.playerdata.extra.func_74768_a("Age", this.bo ? -24000 : 0);
                GuiCreationExtra.this.playerdata.clearEntity();
            } else {
                GuiCreationExtra.this.playerdata.extra.func_74757_a(this.name, this.bo);
                GuiCreationExtra.this.playerdata.clearEntity();
            }
        }
    }

    abstract class GuiType {
        public String name;

        public GuiType(String name) {
            this.name = name;
        }

        public abstract void initGui();

        public abstract void actionPerformed(GuiButton var1);
    }
}

