/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import org.apache.logging.log4j.LogManager;

public class PixelmonHelper {
    public static List<String> getPixelmonList() {
        ArrayList<String> list = new ArrayList<String>();
        if (!CustomNpcs.PixelMonEnabled) {
            return list;
        }
        try {
            ?[] array;
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.enums.EnumPokemon");
            for (Object ob : array = c.getEnumConstants()) {
                list.add(ob.toString());
            }
        }
        catch (Exception e) {
            LogManager.getLogger().error("getPixelmonList", (Throwable)e);
        }
        return list;
    }

    public static boolean isPixelmon(EntityLivingBase entity) {
        if (!CustomNpcs.PixelMonEnabled) {
            return false;
        }
        return EntityList.func_75621_b((Entity)entity).equals("pixelmon.Pixelmon");
    }

    public static void setName(EntityLivingBase entity, String name) {
        if (!CustomNpcs.PixelMonEnabled || !PixelmonHelper.isPixelmon(entity)) {
            return;
        }
        try {
            Method m = entity.getClass().getMethod("init", String.class);
            m.invoke((Object)entity, name);
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity2HasModel");
            m = c.getDeclaredMethod("loadModel", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            LogManager.getLogger().error("setName", (Throwable)e);
        }
    }

    public static String getName(EntityLivingBase entity) {
        if (!CustomNpcs.PixelMonEnabled || !PixelmonHelper.isPixelmon(entity)) {
            return "";
        }
        try {
            Method m = entity.getClass().getMethod("getName", new Class[0]);
            return m.invoke((Object)entity, new Object[0]).toString();
        }
        catch (Exception e) {
            LogManager.getLogger().error("getName", (Throwable)e);
            return "";
        }
    }

    public static void debug(EntityLivingBase entity) {
        if (!CustomNpcs.PixelMonEnabled || !PixelmonHelper.isPixelmon(entity)) {
            return;
        }
        try {
            Method m = entity.getClass().getMethod("getModel", new Class[0]);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText((String)m.invoke((Object)entity, new Object[0])));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isTrainer(EntityLivingBase entity) {
        if (!CustomNpcs.PixelMonEnabled) {
            return false;
        }
        return EntityList.func_75621_b((Entity)entity).equals("pixelmon.Trainer");
    }

    public static boolean isBattling(EntityPlayerMP player) {
        if (!CustomNpcs.PixelMonEnabled) {
            return false;
        }
        try {
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.battles.BattleRegistry");
            Method m = c.getMethod("getBattle", EntityPlayer.class);
            return m.invoke(null, player) == null;
        }
        catch (Exception e) {
            LogManager.getLogger().error("canBattle", (Throwable)e);
            return false;
        }
    }

    public static boolean isBattling(EntityLivingBase trainer) {
        if (!CustomNpcs.PixelMonEnabled || !PixelmonHelper.isTrainer(trainer)) {
            return false;
        }
        try {
            Field f = trainer.getClass().getField("battleController");
            return f.get(trainer) != null;
        }
        catch (Exception e) {
            LogManager.getLogger().error("canBattle", (Throwable)e);
            return false;
        }
    }

    public static boolean canBattle(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!CustomNpcs.PixelMonEnabled || npc.advanced.job != EnumJobType.Spawner || PixelmonHelper.isBattling(player)) {
            return false;
        }
        try {
            JobSpawner spawner = (JobSpawner)npc.jobInterface;
            if (spawner.isOnCooldown(player.func_70005_c_())) {
                return false;
            }
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.storage.PixelmonStorage");
            Field f = c.getField("PokeballManager");
            Object ob = f.get(null);
            c = Class.forName("com.pixelmonmod.pixelmon.storage.PokeballManager");
            Method m = c.getMethod("getPlayerStorage", EntityPlayerMP.class);
            ob = m.invoke(ob, player);
            c = Class.forName("com.pixelmonmod.pixelmon.storage.PlayerStorage");
            m = c.getMethod("countAblePokemon", new Class[0]);
            return (Integer)m.invoke(ob, new Object[0]) != 0;
        }
        catch (Exception e) {
            LogManager.getLogger().error("canBattle", (Throwable)e);
            return false;
        }
    }

    public static boolean startBattle(EntityPlayerMP player, EntityLivingBase trainer) {
        if (!CustomNpcs.PixelMonEnabled) {
            return false;
        }
        try {
            Class<?> c = Class.forName("com.pixelmonmod.pixelmon.storage.PixelmonStorage");
            Field f = c.getField("PokeballManager");
            Object ob = f.get(null);
            c = Class.forName("com.pixelmonmod.pixelmon.storage.PokeballManager");
            Method m = c.getMethod("getPlayerStorage", EntityPlayerMP.class);
            ob = m.invoke(ob, player);
            c = Class.forName("com.pixelmonmod.pixelmon.storage.PlayerStorage");
            m = c.getMethod("getFirstAblePokemon", World.class);
            Entity pixelmon = (Entity)m.invoke(ob, player.field_70170_p);
            Class<?> cEntity = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon");
            m = c.getMethod("EntityAlreadyExists", cEntity);
            if (!((Boolean)m.invoke(ob, pixelmon)).booleanValue()) {
                m = cEntity.getMethod("releaseFromPokeball", new Class[0]);
                pixelmon.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
            }
            c = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant");
            Object parTrainer = c.getConstructor(trainer.getClass(), EntityPlayer.class, Integer.TYPE).newInstance(trainer, player, 1);
            Object[] pixelmonArray = (Object[])Array.newInstance(cEntity, 1);
            pixelmonArray[0] = pixelmon;
            c = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant");
            Object parPlayer = c.getConstructor(EntityPlayerMP.class, pixelmonArray.getClass()).newInstance(player, pixelmonArray);
            cEntity = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle");
            c = Class.forName("com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant");
            m = cEntity.getMethod("StartBattle", c, c);
            m.invoke((Object)pixelmon, parTrainer, parPlayer);
            return true;
        }
        catch (Exception e) {
            LogManager.getLogger().error("startBattle", (Throwable)e);
            return false;
        }
    }
}

