/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptLivingBase;
import noppes.npcs.util.ValueUtil;

public class ScriptPlayer
extends ScriptLivingBase {
    protected EntityPlayerMP player;

    public ScriptPlayer(EntityPlayerMP player) {
        super((EntityLivingBase)player);
        this.player = player;
    }

    public String getDisplayName() {
        return this.player.getDisplayNameString();
    }

    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        NoppesUtilPlayer.teleportPlayer(this.player, new BlockPos(x, y, z), this.player.field_71093_bK);
    }

    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).questData;
        return data.finishedQuests.containsKey(id);
    }

    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).questData;
        return data.activeQuests.containsKey(id);
    }

    public boolean hasReadDialog(int id) {
        PlayerDialogData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).dialogData;
        return data.dialogsRead.contains(id);
    }

    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        QuestData questdata = new QuestData(quest);
        data.questData.activeQuests.put(id, questdata);
    }

    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.finishedQuests.put(id, System.currentTimeMillis());
    }

    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.activeQuests.remove(id);
    }

    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.activeQuests.remove(id);
        data.questData.finishedQuests.remove(id);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 ? true : super.typeOf(type);
    }

    public void addFactionPoints(int faction, int points) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.factionData.increasePoints(faction, points);
    }

    public int getFactionPoints(int faction) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        return data.factionData.getFactionPoints(faction);
    }

    public void sendMessage(String message) {
        this.player.func_145747_a((IChatComponent)new ChatComponentTranslation(NoppesStringUtils.formatText(message, this.player), new Object[0]));
    }

    public int getMode() {
        return this.player.field_71134_c.func_73081_b().func_77148_a();
    }

    public void setMode(int type) {
        this.player.func_71033_a(WorldSettings.func_77161_a((int)type));
    }

    public int inventoryItemCount(ScriptItemStack item) {
        int i = 0;
        for (ItemStack is : this.player.field_71071_by.field_70462_a) {
            if (is == null || !is.func_77969_a(item.item)) continue;
            i += is.field_77994_a;
        }
        return i;
    }

    public boolean removeItem(ScriptItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack is = this.player.field_71071_by.field_70462_a[i];
                if (is == null || !is.func_77969_a(item.item)) continue;
                if (amount > is.field_77994_a) {
                    this.player.field_71071_by.field_70462_a[i] = null;
                    amount -= is.field_77994_a;
                    continue;
                }
                is.func_77979_a(amount);
                break;
            }
        }
        return true;
    }

    public boolean removeItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)id);
        if (item == null) {
            return false;
        }
        return this.removeItem(new ScriptItemStack(new ItemStack(item, 1, damage)), amount);
    }

    public boolean giveItem(ScriptItemStack item, int amount) {
        String itemname = Item.field_150901_e.func_177774_c((Object)item.getMCItemStack().func_77973_b()) + "";
        return this.giveItem(itemname, item.getItemDamage(), amount);
    }

    public boolean giveItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)id);
        if (item == null) {
            return false;
        }
        return this.player.field_71071_by.func_70441_a(new ItemStack(item, amount, damage));
    }

    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        this.player.func_180473_a(new BlockPos(x, y, z), true);
    }

    public void resetSpawnpoint() {
        this.player.func_180473_a(null, false);
    }

    public void removeAllItems(ScriptItemStack item) {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = this.player.field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77969_a(item.item)) continue;
            this.player.field_71071_by.field_70462_a[i] = null;
        }
    }

    public boolean hasAchievement(String achievement) {
        StatBase statbase = StatList.func_151177_a((String)achievement);
        if (statbase == null || !(statbase instanceof Achievement)) {
            return false;
        }
        return this.player.func_147099_x().func_77443_a((Achievement)statbase);
    }

    public boolean hasBukkitPermission(String permission) {
        return CustomNpcsPermissions.hasPermission((EntityPlayer)this.player, permission);
    }

    public int getExpLevel() {
        return this.player.field_71068_ca;
    }

    public void setExpLevel(int level) {
        this.player.field_71068_ca = level;
    }
}

