/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.common;

import com.slatebit.paintball.common.EnumColor;
import com.slatebit.paintball.common.ItemMetadataBlock;
import com.slatebit.paintball.common.ItemPaintbrush;
import com.slatebit.paintball.common.Paintball;
import com.slatebit.paintball.common.SoundBlock;
import com.slatebit.paintball.common.TileEntityC4;
import com.slatebit.paintball.common.TileEntityClaymore;
import com.slatebit.paintball.common.TileEntityFlag;
import com.slatebit.paintball.common.TileEntityGearRack;
import com.slatebit.paintball.common.TileEntityMedKit;
import com.slatebit.paintball.common.TileEntityObject;
import com.slatebit.paintball.common.TileEntityPod;
import com.slatebit.paintball.common.TileEntityWeaponRack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockObject
extends BlockContainer {
    public static final PropertyEnum COLOR = PropertyEnum.func_177709_a((String)"color", EnumColor.class);
    private String type;

    public BlockObject(String type) {
        super(Material.field_151575_d);
        if (type != "Flag") {
            this.func_149711_c(2.5f);
        } else {
            this.func_149711_c(0.0f);
        }
        this.func_149647_a(Paintball.TAB);
        GameRegistry.registerBlock((Block)this, ItemMetadataBlock.class, (String)type.toLowerCase());
        this.type = type;
        if (type == "Claymore") {
            this.func_149672_a(new SoundBlock(Paintball.CLAYMORE_PLACE, 1.0f, 1.0f));
        } else if (type == "C4") {
            this.func_149672_a(new SoundBlock(Paintball.C4_PLACE, 1.0f, 1.0f));
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        if (this.type == "Claymore") {
            return new TileEntityClaymore();
        }
        if (this.type == "C4") {
            return new TileEntityC4();
        }
        if (this.type == "Pod") {
            return new TileEntityPod();
        }
        if (this.type == "Med Kit") {
            return new TileEntityMedKit();
        }
        if (this.type == "Weapon Rack") {
            return new TileEntityWeaponRack();
        }
        if (this.type == "Gear Rack") {
            return new TileEntityGearRack();
        }
        if (this.type == "Flag") {
            return new TileEntityFlag();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumFacing face, float xPosition, float yPosition, float zPosition) {
        InventoryPlayer inventory = entityPlayer.field_71071_by;
        boolean isCreative = entityPlayer.field_71075_bZ.field_75098_d;
        pos.func_177958_n();
        pos.func_177956_o();
        pos.func_177952_p();
        int metadata = this.func_176201_c(state);
        if (this.type == "Pod") {
            TileEntityPod tileEntityPod = (TileEntityPod)world.func_175625_s(pos);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                boolean isSameTeam = Paintball.isSameTeam(metadata, inventory.field_70460_b);
                if (isSameTeam && (isCreative || tileEntityPod.cooldown == 0)) {
                    boolean add1 = inventory.func_70441_a(new ItemStack(Paintball.pellet, 64, metadata));
                    boolean add2 = inventory.func_70441_a(new ItemStack(Paintball.pellet, 64, metadata));
                    boolean add3 = inventory.func_70441_a(new ItemStack(Paintball.pellet, 64, metadata));
                    if (add1 || add2 || add3) {
                        if (!isCreative) {
                            tileEntityPod.cooldown = 1200;
                        }
                        world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                } else if (!world.field_72995_K && !isSameTeam) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(metadata).toLowerCase() + " team."));
                }
                return true;
            }
        } else if (this.type == "Med Kit") {
            TileEntityMedKit tileEntityMedKit = (TileEntityMedKit)world.func_175625_s(pos);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                boolean isSameTeam = Paintball.isSameTeam(metadata, inventory.field_70460_b);
                if (isSameTeam && (isCreative || tileEntityMedKit.cooldown == 0 && entityPlayer.func_110143_aJ() < 20.0f)) {
                    entityPlayer.func_70691_i(10.0f);
                    if (!isCreative) {
                        tileEntityMedKit.cooldown = 1200;
                    }
                    world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                } else if (!world.field_72995_K && !isSameTeam) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(metadata).toLowerCase() + " team."));
                }
                return true;
            }
        } else if (this.type == "Weapon Rack") {
            TileEntityWeaponRack tileEntityWeaponRack = (TileEntityWeaponRack)world.func_175625_s(pos);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                boolean isSameTeam = Paintball.isSameTeam(metadata, inventory.field_70460_b);
                if (isSameTeam && (isCreative || tileEntityWeaponRack.cooldown == 0)) {
                    boolean add1 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.remote, 1, metadata));
                    boolean add2 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.pistol, 1, metadata));
                    boolean add3 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.shotgun, 1, metadata));
                    boolean add4 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.rifle, 1, metadata));
                    boolean add5 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.sniper, 1, metadata));
                    boolean add6 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.launcher, 1, metadata));
                    boolean add7 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.grenade, 2, metadata));
                    boolean add8 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.claymore, 2, metadata));
                    boolean add9 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.c4, 2, metadata));
                    if (add1 || add2 || add3 || add4 || add5 || add6 || add7 || add8 || add9) {
                        if (!isCreative) {
                            tileEntityWeaponRack.cooldown = 1200;
                        }
                        world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                } else if (!world.field_72995_K && !isSameTeam) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(metadata).toLowerCase() + " team."));
                }
                return true;
            }
        } else if (this.type == "Gear Rack") {
            TileEntityGearRack tileEntityGearRack = (TileEntityGearRack)world.func_175625_s(pos);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                if (tileEntityGearRack.cooldown == 0) {
                    Item[] armor = new Item[]{Paintball.shoes, Paintball.pants, Paintball.chest, Paintball.helmet};
                    boolean[] success = new boolean[4];
                    for (int i = 3; i > -1; --i) {
                        ItemStack itemStack = new ItemStack(armor[i], 1, metadata);
                        if (inventory.func_70440_f(i) == null) {
                            entityPlayer.func_70062_b(i + 1, itemStack);
                            success[i] = true;
                            continue;
                        }
                        success[i] = entityPlayer.field_71071_by.func_70441_a(itemStack);
                    }
                    if (success[0] || success[1] || success[2] || success[3]) {
                        if (!isCreative) {
                            tileEntityGearRack.cooldown = 1200;
                        }
                        world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                }
                return true;
            }
        } else if (this.type == "Flag") {
            if (!isCreative) {
                world.func_175698_g(pos);
            }
            this.func_176226_b(world, pos, state, 0);
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntityObject tileEntityObject = (TileEntityObject)world.func_175625_s(pos);
        if (this.type == "Claymore") {
            tileEntityObject.direction = MathHelper.func_76128_c((double)((double)((entityLivingBase.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            tileEntityObject.owner = (EntityPlayer)entityLivingBase;
        } else {
            tileEntityObject.direction = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        }
    }

    public void func_180654_a(IBlockAccess iBlockAccess, BlockPos pos) {
        if (this.type == "Claymore") {
            this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
        } else if (this.type == "C4") {
            this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
        } else if (this.type == "Pod") {
            this.func_149676_a(0.34375f, 0.0f, 0.34375f, 0.65625f, 0.5625f, 0.65625f);
        } else if (this.type == "Med Kit") {
            this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.6875f, 0.875f);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer entityPlayer) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Paintball.c4) {
            TileEntityC4 tileEntityC4 = (TileEntityC4)world.func_175625_s(pos);
            InventoryPlayer inventory = entityPlayer.field_71071_by;
            if (inventory != null && inventory.field_70460_b != null) {
                ItemStack itemStack = inventory.func_70448_g();
                int color = block.func_176201_c(state);
                boolean isSameTeam = Paintball.isSameTeam(itemStack.func_77952_i(), entityPlayer.field_71071_by.field_70460_b);
                if (!world.field_72995_K) {
                    if (isSameTeam && color == itemStack.func_77952_i() && (tileEntityC4.owner == null || tileEntityC4.owner == entityPlayer)) {
                        String key = entityPlayer.func_145748_c_() + " " + itemStack.func_77952_i();
                        ArrayList<Object> tileEntitiesC4 = Paintball.C4_REMOTE.get(key);
                        if (tileEntitiesC4 == null) {
                            tileEntitiesC4 = new ArrayList();
                            Paintball.C4_REMOTE.put(key, tileEntitiesC4);
                        }
                        if (!tileEntitiesC4.contains((Object)tileEntityC4)) {
                            tileEntitiesC4.add((TileEntity)tileEntityC4);
                            tileEntityC4.owner = entityPlayer;
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The C4 is now connected to the remote."));
                        } else if (tileEntitiesC4.contains((Object)tileEntityC4)) {
                            tileEntitiesC4.remove((Object)tileEntityC4);
                            tileEntityC4.owner = null;
                            tileEntitiesC4 = null;
                            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The C4 is no longer connected to the remote."));
                        }
                    } else if (isSameTeam && tileEntityC4.owner != null && tileEntityC4.owner != entityPlayer) {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The C4 is already connected to another remote."));
                    } else {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(color).toLowerCase() + " team."));
                    }
                }
            }
        }
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighbor) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (!world.func_180495_p(new BlockPos(x, (y = pos.func_177956_o()) - 1, z = pos.func_177952_p())).func_177230_c().func_149688_o().func_76220_a()) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return World.func_175683_a((IBlockAccess)world, (BlockPos)new BlockPos(x, y - 1, z));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        int color;
        IBlockState state = world.func_180495_p(pos);
        switch ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))) {
            case RED: {
                color = 14;
                break;
            }
            case ORANGE: {
                color = 1;
                break;
            }
            case YELLOW: {
                color = 4;
                break;
            }
            case GREEN: {
                color = 13;
                break;
            }
            default: {
                color = 11;
                break;
            }
            case PURPLE: {
                color = 10;
            }
        }
        effectRenderer.func_180533_a(pos, Blocks.field_150325_L.func_176203_a(color));
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))).getMetadata();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 6; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))).getMapColor();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)((Object)EnumColor.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{COLOR});
    }
}

