/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHelper {
    private final FMLEmbeddedChannel clientOutboundChannel;
    private final FMLEmbeddedChannel serverOutboundChannel;

    @SafeVarargs
    public NetworkHelper(String channelName, Class<? extends IPacket> ... handledPacketClasses) {
        EnumMap channelPair = NetworkRegistry.INSTANCE.newChannel(channelName, new io.netty.channel.ChannelHandler[]{new ChannelHandler(handledPacketClasses)});
        this.clientOutboundChannel = (FMLEmbeddedChannel)channelPair.get(Side.CLIENT);
        this.serverOutboundChannel = (FMLEmbeddedChannel)channelPair.get(Side.SERVER);
    }

    public void sendPacketToServer(IPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.clientOutboundChannel.writeOutbound(new Object[]{packet});
        }
    }

    public void sendPacketToPlayer(IPacket packet, EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        }
    }

    public void sendPacketToAllPlayers(IPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        }
    }

    public void sendPacketToAllAroundPoint(IPacket packet, NetworkRegistry.TargetPoint tp) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)tp);
            this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        }
    }

    public void sendPacketToAllInDimension(IPacket packet, int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
            this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        }
    }

    private class ChannelHandler
    extends FMLIndexedMessageToMessageCodec<IPacket> {
        @SafeVarargs
        public ChannelHandler(Class<? extends IPacket> ... handledPacketClasses) {
            for (int i = 0; i < handledPacketClasses.length; ++i) {
                this.addDiscriminator(i, handledPacketClasses[i]);
            }
        }

        public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf bytes) throws Exception {
            msg.writeBytes(ctx, bytes);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf bytes, IPacket msg) {
            msg.readBytes(ctx, bytes);
        }
    }

    public static interface IPacket {
        public void writeBytes(ChannelHandlerContext var1, ByteBuf var2);

        public void readBytes(ChannelHandlerContext var1, ByteBuf var2);
    }
}

