/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.minecraft;

import com.slatebit.paintball.common.BlockScanner;
import com.slatebit.paintball.common.CommonProxy;
import com.slatebit.paintball.common.EntityGrenade;
import com.slatebit.paintball.common.EntityPellet;
import com.slatebit.paintball.common.ItemGun;
import com.slatebit.paintball.common.Paintball;
import com.slatebit.paintball.common.TileEntityC4;
import com.slatebit.paintball.common.TileEntityClaymore;
import com.slatebit.paintball.common.TileEntityFlag;
import com.slatebit.paintball.common.TileEntityGearRack;
import com.slatebit.paintball.common.TileEntityMedKit;
import com.slatebit.paintball.common.TileEntityPod;
import com.slatebit.paintball.common.TileEntityWeaponRack;
import com.slatebit.paintball.minecraft.ModelC4;
import com.slatebit.paintball.minecraft.ModelClaymore;
import com.slatebit.paintball.minecraft.ModelFlag;
import com.slatebit.paintball.minecraft.ModelMedKit;
import com.slatebit.paintball.minecraft.ModelPod;
import com.slatebit.paintball.minecraft.ModelRack;
import com.slatebit.paintball.minecraft.RenderObject;
import com.slatebit.paintball.minecraft.RenderProjectile;
import com.slatebit.paintball.minecraft.StateMapper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    private ResourceLocation hitMarker = new ResourceLocation("paintball", "textures/overlays/Hit Marker.png");

    @Override
    public void addRenders() {
        Paintball.mouseSensitivity = Minecraft.func_71410_x().field_71474_y.field_74341_c;
        RenderManager renderManager = FMLClientHandler.instance().getClient().func_175598_ae();
        RenderingRegistry.registerEntityRenderingHandler(EntityPellet.class, (Render)new RenderProjectile(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderProjectile(renderManager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityClaymore.class, (TileEntitySpecialRenderer)new RenderObject(new ModelClaymore(), "Claymore"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityC4.class, (TileEntitySpecialRenderer)new RenderObject(new ModelC4(), "C4"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlag.class, (TileEntitySpecialRenderer)new RenderObject(new ModelFlag(), "Flag"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPod.class, (TileEntitySpecialRenderer)new RenderObject(new ModelPod(), "Pod"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWeaponRack.class, (TileEntitySpecialRenderer)new RenderObject(new ModelRack(), "Weapon Rack"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGearRack.class, (TileEntitySpecialRenderer)new RenderObject(new ModelRack(), "Gear Rack"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMedKit.class, (TileEntitySpecialRenderer)new RenderObject(new ModelMedKit(), "Med Kit"));
        BlockModelShapes blockModelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        blockModelShapes.func_178121_a(Paintball.scanner, (IStateMapper)new StateMapper.Builder().setProperty((IProperty)BlockScanner.COLOR).setBuilderSuffix("Scanner").build());
        blockModelShapes.func_178123_a(new Block[]{Paintball.claymore});
        blockModelShapes.func_178123_a(new Block[]{Paintball.c4});
        blockModelShapes.func_178123_a(new Block[]{Paintball.flag});
        blockModelShapes.func_178123_a(new Block[]{Paintball.pod});
        blockModelShapes.func_178123_a(new Block[]{Paintball.weaponRack});
        blockModelShapes.func_178123_a(new Block[]{Paintball.gearRack});
        blockModelShapes.func_178123_a(new Block[]{Paintball.medKit});
        String[] colors = new String[]{"R", "O", "Y", "G", "B", "P"};
        for (int i = 0; i < 6; ++i) {
            this.registerBlockTexture(Paintball.instaBase, i, "Insta-Base" + colors[i]);
            this.registerBlockTexture(Paintball.scanner, i, "Scanner" + colors[i]);
            this.registerItemTexture(Paintball.helmet, i, "Helmet" + colors[i]);
            this.registerItemTexture(Paintball.chest, i, "Chest" + colors[i]);
            this.registerItemTexture(Paintball.pants, i, "Pants" + colors[i]);
            this.registerItemTexture(Paintball.shoes, i, "Shoes" + colors[i]);
            this.registerItemTexture(Paintball.remote, i, "Remote" + colors[i]);
            this.registerItemTexture(Paintball.paintbrush, i, "Paintbrush" + colors[i]);
            this.registerItemTexture(Paintball.pellet, i, "Pellet" + colors[i]);
            this.registerItemTexture(Paintball.pistol, i, "Pistol" + colors[i]);
            this.registerItemTexture(Paintball.shotgun, i, "Shotgun" + colors[i]);
            this.registerItemTexture(Paintball.rifle, i, "Rifle" + colors[i]);
            this.registerItemTexture(Paintball.sniper, i, "Sniper" + colors[i]);
            this.registerItemTexture(Paintball.launcher, i, "Launcher" + colors[i]);
            this.registerItemTexture(Paintball.grenade, i, "Grenade" + colors[i]);
            this.registerBlockTexture(Paintball.claymore, i, "Claymore" + colors[i]);
            this.registerBlockTexture(Paintball.c4, i, "C4" + colors[i]);
            this.registerBlockTexture(Paintball.flag, i, "Flag" + colors[i]);
            this.registerBlockTexture(Paintball.pod, i, "Pod" + colors[i]);
            this.registerBlockTexture(Paintball.weaponRack, i, "Weapon Rack" + colors[i]);
            this.registerBlockTexture(Paintball.gearRack, i, "Gear Rack" + colors[i]);
            this.registerBlockTexture(Paintball.medKit, i, "Med Kit" + colors[i]);
        }
    }

    public void registerBlockTexture(Block block, String blockName) {
        this.registerBlockTexture(block, 0, blockName);
    }

    public void registerBlockTexture(Block block, int meta, String blockName) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)block), meta, new ModelResourceLocation("paintball:" + blockName, "inventory"));
        ModelBakery.addVariantName((Item)Item.func_150898_a((Block)block), (String[])new String[]{"paintball:" + blockName});
    }

    public void registerItemTexture(Item item, String itemName) {
        this.registerItemTexture(item, 0, itemName);
    }

    public void registerItemTexture(Item item, int meta, String itemName) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_175037_a().func_178086_a(item, meta, new ModelResourceLocation("paintball:" + itemName, "inventory"));
        ModelBakery.addVariantName((Item)item, (String[])new String[]{"paintball:" + itemName});
    }

    @Override
    public void renderHitMarker() {
        if (Paintball.hitMarker > 0) {
            --Paintball.hitMarker;
            Minecraft client = FMLClientHandler.instance().getClient();
            ScaledResolution scale = new ScaledResolution(client, client.field_71443_c, client.field_71440_d);
            int xCenter = scale.func_78326_a() / 2;
            int offset = scale.func_78328_b() * 2;
            client.func_110434_K().func_110577_a(this.hitMarker);
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_178970_b();
            worldrenderer.func_178985_a((double)(xCenter - offset), (double)scale.func_78328_b(), 1.0, 0.0, 1.0);
            worldrenderer.func_178985_a((double)(xCenter + offset), (double)scale.func_78328_b(), 1.0, 1.0, 1.0);
            worldrenderer.func_178985_a((double)(xCenter + offset), 0.0, 1.0, 1.0, 0.0);
            worldrenderer.func_178985_a((double)(xCenter - offset), 0.0, 1.0, 0.0, 0.0);
            tessellator.func_78381_a();
        }
    }

    @Override
    public void renderSight() {
        Minecraft client = FMLClientHandler.instance().getClient();
        if (client.field_71439_g != null) {
            InventoryPlayer inventory = client.field_71439_g.field_71071_by;
            if (Mouse.isButtonDown((int)0) && inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemGun && client.field_71462_r == null) {
                ItemGun gun = (ItemGun)inventory.func_70448_g().func_77973_b();
                float newZoom = gun.type != "Sniper" ? 2.5f : 5.0f;
                if (Paintball.zoomLevel <= newZoom) {
                    Paintball.zoomLevel = (float)((double)Paintball.zoomLevel + 0.25);
                }
                if (Paintball.zoomLevel > newZoom) {
                    Paintball.zoomLevel = (float)((double)Paintball.zoomLevel - 0.25);
                }
                client.field_71474_y.field_74341_c = Paintball.mouseSensitivity / (1.0f + (Paintball.zoomLevel - 1.0f) / Paintball.zoomLevel);
                ScaledResolution scale = new ScaledResolution(client, client.field_71443_c, client.field_71440_d);
                int xCenter = scale.func_78326_a() / 2;
                int offset = scale.func_78328_b() * 2;
                client.func_110434_K().func_110577_a(new ResourceLocation("paintball", "textures/overlays/" + gun.type + " Sight.png"));
                Tessellator tessellator = Tessellator.func_178181_a();
                WorldRenderer worldrenderer = tessellator.func_178180_c();
                worldrenderer.func_178970_b();
                worldrenderer.func_178985_a((double)(xCenter - offset), (double)scale.func_78328_b(), -100.0, 0.0, 1.0);
                worldrenderer.func_178985_a((double)(xCenter + offset), (double)scale.func_78328_b(), -100.0, 1.0, 1.0);
                worldrenderer.func_178985_a((double)(xCenter + offset), 0.0, -100.0, 1.0, 0.0);
                worldrenderer.func_178985_a((double)(xCenter - offset), 0.0, -100.0, 0.0, 0.0);
                tessellator.func_78381_a();
            } else {
                if ((double)Paintball.zoomLevel >= 1.0) {
                    Paintball.zoomLevel = (float)((double)Paintball.zoomLevel - 0.25);
                }
                if ((double)Paintball.zoomLevel < 1.0) {
                    Paintball.zoomLevel = 1.0f;
                }
                client.field_71474_y.field_74341_c = (float)((double)Paintball.mouseSensitivity / (1.0 + ((double)Paintball.zoomLevel - 1.0) / (double)Paintball.zoomLevel));
            }
        }
    }
}

