/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.block;

import com.jaquadro.minecraft.extrabuttons.client.ClientProxy;
import com.jaquadro.minecraft.extrabuttons.tileentity.TileEntityDelayButton;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DelayButton
extends BlockContainer {
    private static final float PIXEL_UNIT = 0.0625f;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconButton;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconPanelBack;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconPanelFront;
    @SideOnly(value=Side.CLIENT)
    private boolean renderPanel;
    public static TileEntityDelayButton defaultTileEntity;

    public DelayButton() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78028_d);
        defaultTileEntity = new TileEntityDelayButton();
        defaultTileEntity.setDirection(3);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.delayButtonRenderID;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH);
    }

    public boolean hasTileEntity(int data) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityDelayButton te = (TileEntityDelayButton)world.func_147438_o(x, y, z);
        int dir = te != null ? te.getDirection() : 0;
        boolean invalid = false;
        if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) && dir == 1) {
            invalid = true;
        }
        if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) && dir == 2) {
            invalid = true;
        }
        if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) && dir == 3) {
            invalid = true;
        }
        if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) && dir == 4) {
            invalid = true;
        }
        if (invalid) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityDelayButton te = (TileEntityDelayButton)blockAccess.func_147438_o(x, y, z);
        if (te != null) {
            this.setBlockBoundsByTileEntity(te, 8.0f, 8.0f, te.isDepressed() ? 1.0f : 2.0f, 0, 1, 0);
        }
    }

    private void setBlockBoundsByTileEntity(TileEntityDelayButton te, float width, float height, float depth, int offsetX, int offsetY, int offsetZ) {
        int dir = te.getDirection();
        float heightHalf = height / 2.0f * 0.0625f;
        float widthHalf = width / 2.0f * 0.0625f;
        float depthMin = (float)offsetZ * 0.0625f;
        float depthMax = depthMin + depth * 0.0625f;
        float offsetYF = (float)offsetY * 0.0625f;
        if (dir == 1) {
            this.func_149676_a((float)offsetX + depthMin, offsetYF + 0.5f - heightHalf, 0.5f - widthHalf, (float)offsetX + depthMax, offsetYF + 0.5f + heightHalf, 0.5f + widthHalf);
        } else if (dir == 2) {
            this.func_149676_a((float)offsetX + 1.0f - depthMax, offsetYF + 0.5f - heightHalf, 0.5f - widthHalf, (float)offsetX + 1.0f - depthMin, offsetYF + 0.5f + heightHalf, 0.5f + widthHalf);
        } else if (dir == 3) {
            this.func_149676_a((float)offsetX + 0.5f - widthHalf, offsetYF + 0.5f - heightHalf, depthMin, (float)offsetX + 0.5f + widthHalf, offsetYF + 0.5f + heightHalf, depthMax);
        } else if (dir == 4) {
            this.func_149676_a((float)offsetX + 0.5f - widthHalf, offsetYF + 0.5f - heightHalf, (float)offsetX + 1.0f - depthMax, 0.5f + widthHalf, offsetYF + 0.5f + heightHalf, 1.0f - depthMin);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityDelayButton te = (TileEntityDelayButton)world.func_147438_o(x, y, z);
        if (te == null) {
            return false;
        }
        if (te.isDepressed()) {
            return true;
        }
        if (player.func_70093_af()) {
            this.cycleDelaySetting(te);
        } else {
            this.activateButton(te);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
            this.updateNeighbors(world, x, y, z, te.getDirection());
        }
        world.func_147458_c(x, y, z, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        return true;
    }

    private void cycleDelaySetting(TileEntityDelayButton te) {
        int cycle;
        if (te.isShowingDelay()) {
            te.setUpdateTime(te.func_145831_w().func_82737_E() + (long)this.func_149738_a(te.func_145831_w()));
        }
        if ((cycle = te.getDelay() + 1) > 3) {
            cycle = 0;
        }
        te.setDelay(cycle);
        te.setShowingDelay(true);
    }

    private void activateButton(TileEntityDelayButton te) {
        te.setIsDepressed(true);
        te.setState(te.getDelay());
        te.setIsLatched(true);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        TileEntityDelayButton te = (TileEntityDelayButton)world.func_147438_o(x, y, z);
        if (te != null && te.isLatched()) {
            this.updateNeighbors(world, x, y, z, te.getDirection());
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityDelayButton te = (TileEntityDelayButton)blockAccess.func_147438_o(x, y, z);
        return te != null && te.isLatched() ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityDelayButton te = (TileEntityDelayButton)blockAccess.func_147438_o(x, y, z);
        if (te == null || !te.isLatched()) {
            return 0;
        }
        int dir = te.getDirection();
        return dir == 5 && side == 1 ? 15 : (dir == 4 && side == 2 ? 15 : (dir == 3 && side == 3 ? 15 : (dir == 2 && side == 4 ? 15 : (dir == 1 && side == 5 ? 15 : 0))));
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileEntityDelayButton te = (TileEntityDelayButton)world.func_147438_o(x, y, z);
        if (te == null) {
            return;
        }
        if (te.getUpdateTime() > 0L) {
            int tick = (int)(te.getUpdateTime() - world.func_82737_E());
            te.setUpdateTime(0L);
            if (tick > 0) {
                world.func_147464_a(x, y, z, (Block)this, tick);
                world.func_147471_g(x, y, z);
                return;
            }
        }
        if ((te.isDepressed() || te.isLatched() || te.isShowingDelay()) && !world.field_72995_K) {
            if (te.isShowingDelay()) {
                te.setShowingDelay(false);
            }
            if (te.isLatched()) {
                if (te.getState() > 0) {
                    te.setState(te.getState() - 1);
                    world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
                } else {
                    te.setIsLatched(false);
                    te.setIsDepressed(false);
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
                    this.updateNeighbors(world, x, y, z, te.getDirection());
                }
            }
            world.func_147471_g(x, y, z);
        }
    }

    public void func_149683_g() {
        float hx = 0.1875f;
        float hy = 0.125f;
        float hz = 0.125f;
        this.func_149676_a(0.5f - hx, 0.5f - hy, 0.5f - hz, 0.5f + hx, 0.5f + hy, 0.5f + hz);
    }

    private void updateNeighbors(World world, int x, int y, int z, int dir) {
        world.func_147459_d(x, y, z, (Block)this);
        if (dir == 1) {
            world.func_147459_d(x - 1, y, z, (Block)this);
        } else if (dir == 2) {
            world.func_147459_d(x + 1, y, z, (Block)this);
        } else if (dir == 3) {
            world.func_147459_d(x, y, z - 1, (Block)this);
        } else if (dir == 4) {
            world.func_147459_d(x, y, z + 1, (Block)this);
        } else {
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
    }

    public TileEntity func_149915_a(World world, int data) {
        return new TileEntityDelayButton();
    }

    @SideOnly(value=Side.CLIENT)
    public void setBlockForPanelRender(TileEntity tileEntity) {
        TileEntityDelayButton te = (TileEntityDelayButton)tileEntity;
        if (te != null) {
            this.setBlockBoundsByTileEntity(te, 8.0f, 8.0f, 1.0f, 0, 1, 0);
        }
        this.renderPanel = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setBlockForButtonRender(TileEntity tileEntity) {
        TileEntityDelayButton te = (TileEntityDelayButton)tileEntity;
        if (te != null) {
            this.setBlockBoundsByTileEntity(te, 6.0f, 4.0f, te.isDepressed() ? 0.1f : 1.0f, 0, 0, 1);
        }
        this.renderPanel = false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity baseTE = world.func_147438_o(x, y, z);
        if (baseTE != null && baseTE.getClass().isAssignableFrom(TileEntityDelayButton.class)) {
            return this.getIcon((TileEntityDelayButton)baseTE, side);
        }
        return this.getIcon(null, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.getIcon(defaultTileEntity, side);
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIcon(TileEntityDelayButton te, int side) {
        if (this.renderPanel) {
            if (te == null || side == 0 || side == 1) {
                return this.iconPanelBack;
            }
            boolean renderBack = false;
            switch (te.getDirection()) {
                case 1: {
                    renderBack = side == 4;
                    break;
                }
                case 2: {
                    renderBack = side == 5;
                    break;
                }
                case 3: {
                    renderBack = side == 2;
                    break;
                }
                case 4: {
                    boolean bl = renderBack = side == 3;
                }
            }
            if (renderBack) {
                return this.iconPanelBack;
            }
            int level = te.isShowingDelay() ? te.getDelay() : te.getState();
            return this.iconPanelFront[Math.max(0, Math.min(3, level))];
        }
        return this.iconButton;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconButton = iconRegister.func_94245_a("extrabuttons:delay_button_button");
        this.iconPanelBack = iconRegister.func_94245_a("extrabuttons:delay_button_back");
        this.iconPanelFront = new IIcon[4];
        for (int i = 0; i < 4; ++i) {
            this.iconPanelFront[i] = iconRegister.func_94245_a("extrabuttons:delay_button_" + i);
        }
    }
}

