/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PlayerDetectorRail
extends BlockRailDetector {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public PlayerDetectorRail() {
        this.func_149675_a(true);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        int data;
        if (!world.field_72995_K && ((data = world.func_72805_g(x, y, z)) & 8) == 0) {
            this.setStateIfMinecartInteractsWithRail(world, x, y, z, data);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int data;
        if (!world.field_72995_K && ((data = world.func_72805_g(x, y, z)) & 8) != 0) {
            this.setStateIfMinecartInteractsWithRail(world, x, y, z, data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int data) {
        if ((data & 8) != 0) {
            return this.iconArray[1];
        }
        return this.iconArray[0];
    }

    private void setStateIfMinecartInteractsWithRail(World world, int x, int y, int z, int data) {
        boolean isPowerBitSet = (data & 8) != 0;
        boolean isValidTarget = false;
        float boundAdjust = 0.125f;
        List entities = world.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + boundAdjust), (double)y, (double)((float)z + boundAdjust), (double)((float)(x + 1) - boundAdjust), (double)((float)(y + 1) - boundAdjust), (double)((float)(z + 1) - boundAdjust)));
        if (!entities.isEmpty()) {
            for (Object item : entities) {
                EntityMinecart minecart = (EntityMinecart)item;
                if (minecart.field_70153_n == null) continue;
                isValidTarget = true;
            }
        }
        if (isValidTarget && !isPowerBitSet) {
            world.func_72921_c(x, y, z, data | 8, 3);
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
            world.func_147458_c(x, y, z, x, y, z);
        }
        if (!isValidTarget && isPowerBitSet) {
            world.func_72921_c(x, y, z, data & 7, 3);
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
            world.func_147458_c(x, y, z, x, y, z);
        }
        if (isValidTarget) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconArray = new IIcon[]{iconRegister.func_94245_a("extrabuttons:player_detector_rail_off"), iconRegister.func_94245_a("extrabuttons:player_detector_rail_on")};
    }
}

