/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.AnimatedPlayer;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import thehippomaster.AnimatedPlayer.AnimatedPlayer;

public class PlayerData {
    public int exhaustionTick = 0;
    public int prevExhaustionTick = 0;
    public int exhaustionOffset = 0;
    public int browTick = 0;
    public int prevBrowTick = 0;
    public int sprintTick = 0;
    public int prevSprintTick = 0;
    public int sneakTick = 0;
    public int prevSneakTick = 0;
    public int jumpTick = 0;
    public int prevJumpTick = 0;
    public int swimTick = 0;
    public int prevSwimTick = 0;
    public int blockTick = 0;
    public int prevBlockTick = 0;
    public int climbingTick = 0;
    public int prevClimbingTick = 0;
    public int eatTick = 0;
    public int prevEatTick = 0;
    public int drinkTick = 0;
    public int prevDrinkTick = 0;
    public float climbingOffset = 0.0f;
    public float prevClimbingOffset = 0.0f;
    public float swimPitch = 0.0f;
    public float prevSwimPitch = 0.0f;
    public boolean moveBackwards = false;
    public boolean moveBackwards2 = false;
    public boolean isAirborne = false;
    public boolean jumpRight = false;
    public boolean holdingSword = false;
    public TextureInfo textureInfo = new TextureInfo();
    private static HashMap<EntityPlayer, PlayerData> playerMap = new HashMap();

    private PlayerData() {
    }

    public void initTextureInfo(AbstractClientPlayer player) {
        if (this.textureInfo.init) {
            return;
        }
        if (!AnimatedPlayer.animateFace) {
            this.textureInfo.init = true;
            return;
        }
        TextureManager engine = RenderManager.field_78727_a.field_78724_e;
        boolean fail = false;
        int[] data = null;
        ThreadDownloadImageData imgData = player.func_110309_l();
        BufferedImage img = null;
        boolean textureUploaded = imgData.func_110557_a();
        if (imgData != null) {
            img = (BufferedImage)ReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imgData, (String[])AnimatedPlayer.fPlayerImgBuffer);
        }
        if (imgData == null || img == null || !textureUploaded) {
            fail = true;
        } else {
            int h;
            int w = img.getWidth();
            data = img.getRGB(0, 0, w, h = img.getHeight(), data, 0, w);
            if (data == null) {
                fail = true;
            }
        }
        if (fail) {
            this.textureInfo.setDefault();
            this.textureInfo.initAttempts = Math.max(0, this.textureInfo.initAttempts - 1);
            if (this.textureInfo.initAttempts == 0) {
                System.out.println("[AnimatedPlayer] Cannot find texture: " + player.func_110306_p());
                System.out.println("[AnimatedPlayer] Using default texture.");
                this.textureInfo.defaultTexture = true;
                this.textureInfo.init = true;
            }
            return;
        }
        this.checkTextureForEyes(1, data);
        this.checkTextureForEyes(2, data);
        this.checkTextureForEyes(3, data);
        this.checkTextureForEyebrows(data);
        this.checkTextureForMouth(data);
        this.textureInfo.init = true;
    }

    private void checkTextureForEyes(int position, int[] data) {
        boolean flag = false;
        for (int x = 0; x < 5; ++x) {
            int i = data[x + 27 + (position - 1) * 64];
            if (i == 0 || i == -16777216) continue;
            flag = true;
            break;
        }
        if (position == 1) {
            this.textureInfo.animateEyes1 = flag;
        }
        if (position == 2) {
            this.textureInfo.animateEyes2 = flag;
        }
        if (position == 3) {
            this.textureInfo.animateEyes3 = flag;
        }
    }

    private void checkTextureForEyebrows(int[] data) {
        boolean flag = false;
        for (int x = 0; x < 3; ++x) {
            int i = data[x + 24];
            if (i == 0 || i == -16777216) continue;
            flag = true;
            break;
        }
        this.textureInfo.animateEyebrows = flag;
    }

    private void checkTextureForMouth(int[] data) {
        boolean flag = false;
        block0: for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                int i = data[x + 24 + (y + 1) * 64];
                if (i == 0 || i == -16777216) continue;
                flag = true;
                continue block0;
            }
        }
        this.textureInfo.animateMouth = flag;
    }

    public boolean updateExhaustion(EntityPlayer player) {
        boolean flag = false;
        boolean jump = false;
        if (player instanceof EntityPlayerSP) {
            EntityPlayerSP playerSP = (EntityPlayerSP)player;
            jump = playerSP.field_71158_b.field_78901_c;
        }
        if (player.func_70051_ag() || jump || player.func_70090_H() || player.field_70737_aN > 0) {
            flag = true;
        }
        if (player.func_70644_a(Potion.field_76421_d) || player.func_70644_a(Potion.field_76438_s)) {
            flag = true;
        }
        this.exhaustionOffset = flag ? Math.min(160, this.exhaustionOffset + 3) : Math.max(0, this.exhaustionOffset - 1);
        if (player.func_70090_H()) {
            return false;
        }
        return this.exhaustionOffset > 0;
    }

    public boolean shouldArchBrows(EntityPlayer player, ItemStack stack) {
        if (player.field_82175_bq || player.func_70093_af()) {
            return true;
        }
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemSword) {
                return true;
            }
            if (player.func_71052_bv() > 0 && stack.func_77975_n() == EnumAction.bow) {
                return true;
            }
        }
        return false;
    }

    public boolean isAirborne(EntityPlayer player) {
        this.isAirborne = !player.field_70122_E && !player.func_70090_H() && !player.func_70055_a(Material.field_151587_i) && !player.func_70608_bn();
        return this.isAirborne;
    }

    public boolean isBlocking(EntityPlayer player, ItemStack stack) {
        return stack != null && player.func_71052_bv() > 0 && stack.func_77975_n() == EnumAction.block;
    }

    public boolean isEating(EntityPlayer player, ItemStack stack) {
        return stack != null && player.func_71052_bv() > 0 && stack.func_77975_n() == EnumAction.eat;
    }

    public boolean isDrinking(EntityPlayer player, ItemStack stack) {
        return stack != null && player.func_71052_bv() > 0 && stack.func_77975_n() == EnumAction.drink;
    }

    public static PlayerData getPlayerData(EntityPlayer player) {
        PlayerData data = playerMap.get(player);
        if (data == null) {
            data = new PlayerData();
            playerMap.put(player, data);
        }
        return data;
    }

    public static void recycleMap(World world) {
        Iterator<EntityPlayer> iterator = playerMap.keySet().iterator();
        ArrayList<EntityPlayer> removeList = new ArrayList<EntityPlayer>();
        while (iterator.hasNext()) {
            EntityPlayer player = iterator.next();
            if (world.field_73010_i.contains(player)) continue;
            removeList.add(player);
        }
        playerMap.keySet().removeAll(removeList);
    }

    public static class TextureInfo {
        private int initAttempts = 10;
        private boolean init = false;
        public boolean defaultTexture = false;
        public boolean animateEyes1 = false;
        public boolean animateEyes2 = false;
        public boolean animateEyes3 = false;
        public boolean animateEyebrows = false;
        public boolean animateMouth = false;

        public void setDefault() {
            this.animateEyes3 = false;
            this.animateEyes1 = false;
            this.animateEyes2 = true;
            this.animateEyebrows = true;
            this.animateMouth = true;
        }
    }
}

