/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.AnimatedPlayer.client;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import thehippomaster.AnimatedPlayer.AnimatedPlayer;
import thehippomaster.AnimatedPlayer.CommonProxy;
import thehippomaster.AnimatedPlayer.PlayerData;
import thehippomaster.AnimatedPlayer.client.RenderPlayer;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private Timer mcTimer;
    public static IModelCustom forearm1;
    public static IModelCustom forearm2;
    public static IModelCustom foot1;
    public static IModelCustom foot2;
    public static IModelCustom chest;

    @Override
    public void registerRenderers() {
        forearm1 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("AnimatedPlayer:models/forearm/SteveRightForeArm.obj"));
        forearm2 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("AnimatedPlayer:models/forearm/SteveLeftForeArm.obj"));
        foot1 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("AnimatedPlayer:models/legs/SteveRightLeg.obj"));
        foot2 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("AnimatedPlayer:models/legs/SteveLeftLeg.obj"));
        chest = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("AnimatedPlayer:models/body/SteveBody.obj"));
        this.addRenderer(EntityPlayer.class, (Render)new RenderPlayer());
    }

    private void addRenderer(Class<? extends Entity> class1, Render renderer) {
        RenderingRegistry.registerEntityRenderingHandler(class1, (Render)renderer);
    }

    @Override
    public void initTimer() {
        this.mcTimer = (Timer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])AnimatedPlayer.fTimer);
    }

    @Override
    public float getPartialTick() {
        return this.mcTimer.field_74281_c;
    }

    @Override
    public void onClientTick() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (++AnimatedPlayer.clientTick % 200L == 0L) {
            PlayerData.recycleMap((World)world);
        }
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            Item item;
            float yaw;
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            PlayerData data = PlayerData.getPlayerData(player);
            ItemStack currentItem = player.func_71045_bC();
            if (player.field_70173_aa > 0 && player.field_70173_aa % 15 == 0) {
                data.initTextureInfo((AbstractClientPlayer)player);
            }
            if (player != Minecraft.func_71410_x().field_71439_g) {
                boolean prevNoClip = player.field_70145_X;
                double oldX = player.field_70165_t;
                double oldY = player.field_70163_u;
                double oldZ = player.field_70161_v;
                player.field_70145_X = false;
                player.func_70091_d(0.0, (double)-0.04f, 0.0);
                if (!player.field_70122_E) {
                    player.func_70091_d(0.0, (double)0.04f, 0.0);
                }
                player.field_70145_X = prevNoClip;
            }
            double dX = player.field_70165_t - player.field_70169_q;
            double dZ = player.field_70161_v - player.field_70166_s;
            double motion = dX * dX + dZ * dZ;
            for (yaw = -((float)Math.atan2(dX, dZ)) * 180.0f / (float)Math.PI; yaw <= player.field_70177_z - 180.0f; yaw += 360.0f) {
            }
            while (yaw > player.field_70177_z + 180.0f) {
                yaw -= 360.0f;
            }
            float tempYaw = player.field_70177_z - yaw;
            float tempSign = tempYaw / Math.abs(tempYaw);
            data.moveBackwards = motion > 1.0E-4 && Math.abs(tempYaw) > 100.0f;
            boolean bl = data.moveBackwards2 = motion > 1.0E-4 && Math.abs(tempYaw) > 100.0f || motion < 1.0E-4 && data.moveBackwards2;
            if (data.moveBackwards) {
                float addYaw = (180.0f * tempSign - tempYaw) * 0.7f;
                player.field_70761_aq = player.field_70177_z + addYaw;
            }
            data.holdingSword = false;
            if (currentItem != null && (item = currentItem.func_77973_b()) != null && item instanceof ItemSword) {
                data.holdingSword = true;
            }
            data.prevExhaustionTick = data.exhaustionTick;
            data.exhaustionTick = data.updateExhaustion(player) ? Math.min(10, data.exhaustionTick + 1) : Math.max(0, data.exhaustionTick - 1);
            data.prevBrowTick = data.browTick;
            data.browTick = data.shouldArchBrows(player, currentItem) ? Math.min(8, data.browTick + 1) : Math.max(0, data.browTick - 1);
            data.prevSprintTick = data.sprintTick;
            data.sprintTick = player.func_70051_ag() ? Math.min(8, data.sprintTick + 1) : Math.max(0, data.sprintTick - 1);
            data.prevSneakTick = data.sneakTick;
            data.sneakTick = player.func_70093_af() ? Math.min(6, data.sneakTick + 1) : Math.max(0, data.sneakTick - 1);
            data.prevJumpTick = data.jumpTick;
            data.jumpTick = data.isAirborne(player) ? Math.min(10, data.jumpTick + 1) : 0;
            if (data.jumpTick == 0 && data.prevJumpTick != 0) {
                data.jumpRight = !data.jumpRight;
            }
            data.prevSwimTick = data.swimTick;
            data.prevSwimPitch = data.swimPitch;
            if (player.func_70090_H() && !player.field_70122_E) {
                double x = player.field_70165_t - player.field_70169_q;
                double y = player.field_70163_u - player.field_70167_r;
                double z = player.field_70161_v - player.field_70166_s;
                float pitch = (float)Math.atan2(-y, Math.sqrt(x * x + z * z));
                data.swimPitch = data.prevSwimPitch + (pitch - data.prevSwimPitch) * 0.1f;
                data.swimTick = Math.min(16, data.swimTick + 1);
            } else {
                data.swimTick = data.swimTick > 12 ? Math.max(0, data.swimTick - 1) : Math.max(0, data.swimTick - 2);
            }
            data.prevBlockTick = data.blockTick;
            data.blockTick = data.isBlocking(player, currentItem) ? 1 : 0;
            data.prevClimbingTick = data.climbingTick;
            data.prevClimbingOffset = data.climbingOffset;
            if (player.func_70617_f_()) {
                data.climbingTick = Math.min(8, data.climbingTick + 1);
                data.climbingOffset = (float)((double)data.climbingOffset + (player.field_70163_u - player.field_70167_r) / 0.2);
            } else {
                data.climbingTick = Math.max(0, data.climbingTick - 1);
            }
            data.prevEatTick = data.eatTick;
            data.eatTick = data.isEating(player, currentItem) ? Math.min(8, data.eatTick + 1) : Math.max(0, data.eatTick - 1);
            data.prevDrinkTick = data.drinkTick;
            data.drinkTick = data.isDrinking(player, currentItem) ? Math.min(8, data.drinkTick + 1) : Math.max(0, data.drinkTick - 1);
        }
    }
}

