/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.AnimatedPlayer.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.MathHelper;
import thehippomaster.AnimatedPlayer.AnimatedPlayer;
import thehippomaster.AnimatedPlayer.PlayerData;
import thehippomaster.AnimatedPlayer.client.ClientProxy;
import thehippomaster.AnimatedPlayer.client.ModelBoxUV;
import thehippomaster.AnimationAPI.client.ModelJoint;
import thehippomaster.AnimationAPI.client.ModelObjRenderer;

@SideOnly(value=Side.CLIENT)
public class ModelPlayer
extends ModelBiped {
    public int field_78119_l = 0;
    public int field_78120_m = 0;
    public int field_78118_o = 0;
    public boolean isArmor;
    public ModelJoint head;
    public ModelRenderer headwear;
    public ModelRenderer brow1;
    public ModelRenderer brow2;
    public ModelRenderer[][] iris;
    public ModelRenderer[] rightEye;
    public ModelRenderer[] leftEye;
    public ModelRenderer upperLip;
    public ModelRenderer lowerLip;
    public ModelRenderer insideMouth;
    public ModelRenderer mouth;
    public ModelRenderer upperTeeth;
    public ModelRenderer lowerTeeth;
    public ModelRenderer chest;
    public ModelRenderer pelvis;
    public ModelRenderer arm1;
    public ModelRenderer arm2;
    public ModelObjRenderer forearm1;
    public ModelObjRenderer forearm2;
    public ModelJoint leg1;
    public ModelJoint leg2;
    public ModelJoint foot1;
    public ModelJoint foot2;
    public ModelObjRenderer footObj1;
    public ModelObjRenderer footObj2;
    private float partialTick = 0.0f;
    public static final float PI = (float)Math.PI;

    private void initImprovedHat(float f) {
        ModelBoxUV box = null;
        for (int x = -4; x < 4; ++x) {
            for (int y = -8; y < 0; ++y) {
                for (int z = -4; z < 4; ++z) {
                    boolean bottom;
                    boolean right = x == -4;
                    boolean left = x == 3;
                    boolean front = z == -4;
                    boolean back = z == 3;
                    boolean top = y == -8;
                    boolean bl = bottom = y == -1;
                    if (!right && !left && !front && !back && !top && !bottom) continue;
                    float scale = 1.14f;
                    box = ModelBoxUV.addBox(this.headwear, (float)x * scale, ((float)y + 0.5f) * scale, (float)z * scale, 1, 1, 1, f + 0.07f);
                    if (right) {
                        box.setAllUV(36 - z - 1, 16 + y);
                    }
                    if (left) {
                        box.setAllUV(52 + z, 16 + y);
                    }
                    if (front) {
                        box.setAllUV(44 + x, 16 + y);
                    }
                    if (back) {
                        box.setAllUV(60 + x, 16 + y);
                    }
                    if (top) {
                        box.setAllUV(44 + x, 3 - z);
                    }
                    if (bottom) {
                        box.setAllUV(52 + x, 3 - z);
                    }
                    if (right && front) {
                        box.setSideUV(0, 36 - z - 1, 16 + y);
                        box.setSideUV(4, 44 + x, 16 + y);
                    }
                    if (right && back) {
                        box.setSideUV(0, 36 - z - 1, 16 + y);
                        box.setSideUV(5, 60 + x, 16 + y);
                    }
                    if (right && top) {
                        box.setSideUV(0, 36 - z - 1, 16 + y);
                        box.setSideUV(2, 44 + x, 3 - z);
                    }
                    if (right && bottom) {
                        box.setSideUV(0, 36 - z - 1, 16 + y);
                        box.setSideUV(3, 52 + x, 3 - z);
                    }
                    if (left && front) {
                        box.setSideUV(1, 52 + z, 16 + y);
                        box.setSideUV(4, 44 + x, 16 + y);
                    }
                    if (left && back) {
                        box.setSideUV(1, 52 + z, 16 + y);
                        box.setSideUV(5, 60 + x, 16 + y);
                    }
                    if (left && top) {
                        box.setSideUV(1, 52 + z, 16 + y);
                        box.setSideUV(2, 44 + x, 3 - z);
                    }
                    if (left && bottom) {
                        box.setSideUV(1, 52 + z, 16 + y);
                        box.setSideUV(3, 52 + x, 3 - z);
                    }
                    if (front && top) {
                        box.setSideUV(4, 44 + x, 16 + y);
                        box.setSideUV(2, 44 + x, 3 - z);
                    }
                    if (front && bottom) {
                        box.setSideUV(4, 44 + x, 16 + y);
                        box.setSideUV(3, 52 + x, 3 - z);
                    }
                    if (back && top) {
                        box.setSideUV(5, 60 + x, 16 + y);
                        box.setSideUV(2, 44 + x, 3 - z);
                    }
                    if (back && bottom) {
                        box.setSideUV(5, 60 + x, 16 + y);
                        box.setSideUV(3, 52 + x, 3 - z);
                    }
                    box.initQuads();
                }
            }
        }
    }

    private void initEyes(int position, float f) {
        int index = position - 1;
        int yOffset = position - 2;
        ModelBoxUV box = null;
        this.iris[0][index] = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.iris[0][index], -2.0f, -4.0f + (float)yOffset, -4.001f, 1, 1, 1, f);
        box.setAllUV(27, index).initQuads();
        this.head.func_78792_a(this.iris[0][index]);
        this.iris[1][index] = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.iris[1][index], -3.0f, -4.0f + (float)yOffset, -4.001f, 1, 1, 1, f);
        box.setAllUV(27, index).initQuads();
        this.head.func_78792_a(this.iris[1][index]);
        this.iris[2][index] = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.iris[2][index], 1.0f, -4.0f + (float)yOffset, -4.001f, 1, 1, 1, f);
        box.setAllUV(31, index).initQuads();
        this.head.func_78792_a(this.iris[2][index]);
        this.iris[3][index] = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.iris[3][index], 2.0f, -4.0f + (float)yOffset, -4.001f, 1, 1, 1, f);
        box.setAllUV(31, index).initQuads();
        this.head.func_78792_a(this.iris[3][index]);
        this.rightEye[index] = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.rightEye[index], -0.5f, 0.0f, 0.0f, 1, 1, 1, f);
        box.setAllUV(28, index).initQuads();
        this.rightEye[index].func_78793_a(-1.7f, -4.0f + (float)yOffset, -4.002f);
        this.head.func_78792_a(this.rightEye[index]);
        this.leftEye[index] = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.leftEye[index], -0.5f, 0.0f, 0.0f, 1, 1, 1, f);
        box.setAllUV(30, index).initQuads();
        this.leftEye[index].func_78793_a(1.7f, -4.0f + (float)yOffset, -4.002f);
        this.head.func_78792_a(this.leftEye[index]);
    }

    public ModelPlayer(float f) {
        this(f, false);
    }

    public ModelPlayer(float f, boolean armor) {
        this.isArmor = armor;
        ModelBoxUV box = null;
        this.pelvis = new ModelRenderer((ModelBase)this);
        this.pelvis.func_78793_a(0.0f, 12.0f, 0.0f);
        if (armor) {
            this.chest = new ModelRenderer((ModelBase)this, 16, 16);
            this.chest.func_78790_a(-4.0f, -12.0f, -2.0f, 8, 12, 4, f);
        } else {
            this.chest = new ModelObjRenderer((ModelBase)this, ClientProxy.chest);
        }
        this.pelvis.func_78792_a(this.chest);
        this.head = new ModelJoint((ModelBase)this, 0, 0);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, f);
        this.head.func_78793_a(0.0f, -12.0f, 0.0f);
        this.chest.func_78792_a((ModelRenderer)this.head);
        this.headwear = new ModelRenderer((ModelBase)this, 32, 0);
        if (!AnimatedPlayer.betterHat) {
            this.headwear.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, f + 0.5f);
        } else {
            this.initImprovedHat(f);
        }
        this.head.func_78792_a(this.headwear);
        this.iris = new ModelRenderer[4][3];
        this.rightEye = new ModelRenderer[3];
        this.leftEye = new ModelRenderer[3];
        this.initEyes(1, f);
        this.initEyes(2, f);
        this.initEyes(3, f);
        this.brow1 = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.brow1, -1.5f, -0.5f, 0.0f, 3, 1, 1, f - 0.24f);
        box.setAllUV(24, 0).initQuads();
        this.brow1.func_78793_a(-2.0f, -4.6f, -4.3f);
        this.head.func_78792_a(this.brow1);
        this.brow2 = new ModelRenderer((ModelBase)this);
        this.brow2.field_78809_i = true;
        box = ModelBoxUV.addBox(this.brow2, -1.5f, -0.5f, 0.0f, 3, 1, 1, f - 0.24f);
        box.setAllUV(24, 0).initQuads();
        this.brow2.func_78793_a(2.0f, -4.6f, -4.3f);
        this.head.func_78792_a(this.brow2);
        this.upperLip = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.upperLip, -1.0f, -1.0f, 0.0f, 2, 1, 1, f);
        box.setAllUV(11, 13).initQuads();
        this.upperLip.func_78793_a(0.0f, -2.0f, -4.004f);
        this.head.func_78792_a(this.upperLip);
        this.lowerLip = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.lowerLip, -1.0f, -1.0f, 0.0f, 2, 1, 1, f);
        box.setAllUV(11, 15).initQuads();
        this.lowerLip.func_78793_a(0.0f, 0.0f, -4.004f);
        this.head.func_78792_a(this.lowerLip);
        this.insideMouth = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.insideMouth, -1.0f, -1.0f, 0.0f, 2, 1, 1, f);
        box.setAllUV(24, 2).initQuads();
        this.insideMouth.func_78793_a(0.0f, -1.0f, -4.001f);
        this.head.func_78792_a(this.insideMouth);
        this.mouth = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.mouth, -1.0f, -1.0f, 0.0f, 2, 1, 1, f);
        box.setAllUV(11, 14).initQuads();
        this.mouth.func_78793_a(0.0f, -1.2f, -4.003f);
        this.head.func_78792_a(this.mouth);
        this.upperTeeth = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.upperTeeth, -1.0f, -1.0f, 0.0f, 2, 1, 1, f);
        box.setAllUV(24, 1).initQuads();
        this.upperTeeth.func_78793_a(0.0f, 0.1f, 0.001f);
        this.mouth.func_78792_a(this.upperTeeth);
        this.lowerTeeth = new ModelRenderer((ModelBase)this);
        box = ModelBoxUV.addBox(this.lowerTeeth, -1.0f, -1.0f, 0.0f, 2, 1, 1, f);
        box.setAllUV(24, 3).initQuads();
        this.lowerTeeth.func_78793_a(0.0f, -0.1f, -4.002f);
        this.head.func_78792_a(this.lowerTeeth);
        this.arm1 = new ModelRenderer((ModelBase)this, 40, 16);
        box = ModelBoxUV.addBox(this.arm1, -2.0f, -2.0f, -2.0f, 4, 6, 4, f + 0.01f);
        box.setSideUV(3, 52, 16).initQuads();
        this.arm1.func_78793_a(-6.0f, -10.0f, 0.0f);
        this.chest.func_78792_a(this.arm1);
        this.arm2 = new ModelRenderer((ModelBase)this, 40, 16);
        this.arm2.field_78809_i = true;
        box = ModelBoxUV.addBox(this.arm2, -2.0f, -2.0f, -2.0f, 4, 6, 4, f + 0.01f);
        box.setSideUV(3, 52, 16).initQuads();
        this.arm2.func_78793_a(6.0f, -10.0f, 0.0f);
        this.chest.func_78792_a(this.arm2);
        this.forearm1 = new ModelObjRenderer((ModelBase)this);
        this.forearm1.func_78793_a(0.0f, 4.0f, 0.0f);
        this.arm1.func_78792_a((ModelRenderer)this.forearm1);
        this.forearm2 = new ModelObjRenderer((ModelBase)this);
        this.forearm2.func_78793_a(0.0f, 4.0f, 0.0f);
        this.arm2.func_78792_a((ModelRenderer)this.forearm2);
        this.leg1 = new ModelJoint((ModelBase)this, 0, 16);
        box = ModelBoxUV.addBox(this.leg1.getModel(), -2.0f, 0.0f, -2.0f, 4, 6, 4, f + 0.1f);
        box.setSideUV(3, 12, 16).initQuads();
        this.leg1.func_78793_a(-2.0f, 0.0f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg1);
        this.leg2 = new ModelJoint((ModelBase)this, 0, 16);
        this.leg2.getModel().field_78809_i = true;
        box = ModelBoxUV.addBox(this.leg2.getModel(), -2.0f, 0.0f, -2.0f, 4, 6, 4, f + 0.1f);
        box.setSideUV(3, 12, 16).initQuads();
        this.leg2.func_78793_a(2.0f, 0.0f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg2);
        this.foot1 = new ModelJoint((ModelBase)this, 0, 22);
        if (armor) {
            box = ModelBoxUV.addBox(this.foot1.getModel(), -2.0f, 0.0f, -2.0f, 4, 6, 4, f);
            box.setSideUV(2, 0, 16).setSideUV(3, 8, 16).initQuads();
        } else {
            this.footObj1 = new ModelObjRenderer((ModelBase)this, ClientProxy.foot1);
            this.foot1.setModel((ModelRenderer)this.footObj1);
        }
        this.foot1.func_78793_a(0.0f, 6.0f, 0.0f);
        this.leg1.func_78792_a((ModelRenderer)this.foot1);
        this.foot2 = new ModelJoint((ModelBase)this, 0, 22);
        this.foot2.getModel().field_78809_i = true;
        if (armor) {
            box = ModelBoxUV.addBox(this.foot2.getModel(), -2.0f, 0.0f, -2.0f, 4, 6, 4, f);
            box.setSideUV(2, 0, 16).setSideUV(3, 8, 16).initQuads();
        } else {
            this.footObj2 = new ModelObjRenderer((ModelBase)this, ClientProxy.foot2);
            this.foot2.setModel((ModelRenderer)this.footObj2);
        }
        this.foot2.func_78793_a(0.0f, 6.0f, 0.0f);
        this.leg2.func_78792_a((ModelRenderer)this.foot2);
        this.field_78122_k.func_78793_a(0.0f, -12.0f, 2.0f);
    }

    private void initModels() {
        if (this.forearm1.model == null) {
            this.forearm1.model = ClientProxy.forearm1;
        }
        if (this.forearm2.model == null) {
            this.forearm2.model = ClientProxy.forearm2;
        }
        if (!this.isArmor) {
            if (this.footObj1.model == null) {
                this.footObj1.model = ClientProxy.foot1;
            }
            if (this.footObj2.model == null) {
                this.footObj2.model = ClientProxy.foot2;
            }
            ModelObjRenderer chestObj = (ModelObjRenderer)this.chest;
            if (chestObj.model == null) {
                chestObj.model = ClientProxy.chest;
            }
        }
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        EntityPlayer player = (EntityPlayer)entity;
        PlayerData data = PlayerData.getPlayerData(player);
        this.partialTick = AnimatedPlayer.proxy.getPartialTick();
        this.initModels();
        this.setShowModels(data);
        this.setAngles(data);
        this.animate(player, data, f, f1, f2, f3, f4, f5);
        for (int i = 0; i < this.rightEye.length; ++i) {
            if (this.rightEye[i].field_78800_c < -2.5f) {
                this.rightEye[i].field_78800_c = -2.5f;
            }
            if (this.rightEye[i].field_78800_c > -1.5f) {
                this.rightEye[i].field_78800_c = -1.5f;
            }
            if (this.leftEye[i].field_78800_c < 1.5f) {
                this.leftEye[i].field_78800_c = 1.5f;
            }
            if (!(this.leftEye[i].field_78800_c > 2.5f)) continue;
            this.leftEye[i].field_78800_c = 2.5f;
        }
        this.pelvis.func_78785_a(f5);
    }

    private void setShowModels(PlayerData data) {
        for (int i = 0; i < this.iris.length; ++i) {
            this.iris[i][0].field_78806_j = data.textureInfo.animateEyes1;
            this.iris[i][1].field_78806_j = data.textureInfo.animateEyes2;
            this.iris[i][2].field_78806_j = data.textureInfo.animateEyes3;
        }
        this.rightEye[0].field_78806_j = data.textureInfo.animateEyes1;
        this.rightEye[1].field_78806_j = data.textureInfo.animateEyes2;
        this.rightEye[2].field_78806_j = data.textureInfo.animateEyes3;
        this.leftEye[0].field_78806_j = data.textureInfo.animateEyes1;
        this.leftEye[1].field_78806_j = data.textureInfo.animateEyes2;
        this.leftEye[2].field_78806_j = data.textureInfo.animateEyes3;
        this.brow1.field_78806_j = data.textureInfo.animateEyebrows;
        this.brow2.field_78806_j = data.textureInfo.animateEyebrows;
        this.mouth.field_78806_j = data.textureInfo.animateMouth;
        this.insideMouth.field_78806_j = data.textureInfo.animateMouth;
        this.upperTeeth.field_78806_j = data.textureInfo.animateMouth;
        this.lowerTeeth.field_78806_j = data.textureInfo.animateMouth;
    }

    public static void resetAngles(ModelRenderer ... boxes) {
        for (int i = 0; i < boxes.length; ++i) {
            boxes[i].field_78795_f = 0.0f;
            boxes[i].field_78796_g = 0.0f;
            boxes[i].field_78808_h = 0.0f;
        }
    }

    public static void multiplyAngles(float scale, ModelRenderer ... boxes) {
        for (int i = 0; i < boxes.length; ++i) {
            boxes[i].field_78795_f *= scale;
            boxes[i].field_78796_g *= scale;
            boxes[i].field_78808_h *= scale;
        }
    }

    public void setAngles(PlayerData data) {
        ModelPlayer.resetAngles(new ModelRenderer[]{this.head, this.headwear, this.chest, this.pelvis});
        ModelPlayer.resetAngles(new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
        ModelPlayer.resetAngles(new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
        ModelPlayer.resetAngles(new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
        int browAdd = 0;
        if (data.textureInfo.animateEyes1) {
            browAdd = -1;
        } else if (!data.textureInfo.animateEyes2 && data.textureInfo.animateEyes3) {
            browAdd = 1;
        }
        this.pelvis.field_78797_d = 12.8f;
        this.pelvis.field_78798_e = 0.0f;
        for (int i = 0; i < this.rightEye.length; ++i) {
            this.rightEye[i].field_78800_c = -1.7f;
            this.leftEye[i].field_78800_c = 1.7f;
        }
        this.brow1.field_78797_d = -4.6f + (float)browAdd;
        this.brow1.field_78808_h = 0.12083049f;
        this.brow2.field_78797_d = -4.6f + (float)browAdd;
        this.brow2.field_78808_h = -0.12083049f;
        this.mouth.field_78797_d = -1.2f;
        this.arm1.field_78795_f = 0.1f;
        this.arm1.field_78808_h = 0.1f;
        this.arm2.field_78795_f = 0.1f;
        this.arm2.field_78808_h = -0.1f;
        this.forearm1.field_78795_f = -0.3f;
        this.forearm2.field_78795_f = -0.3f;
        this.leg1.field_78795_f = -0.15f;
        this.leg1.field_78808_h = 0.08f;
        this.leg2.field_78795_f = -0.15f;
        this.leg2.field_78808_h = -0.08f;
        this.foot1.field_78795_f = 0.25f;
        this.foot1.field_78808_h = -0.04f;
        this.foot2.field_78795_f = 0.25f;
        this.foot2.field_78808_h = 0.04f;
    }

    public void animate(EntityPlayer player, PlayerData data, float f, float f1, float f2, float f3, float f4, float f5) {
        float oldF1 = Math.min(1.0f, f1);
        float invF1 = 1.0f - f1;
        float breatheAnim = MathHelper.func_76126_a((float)(f2 * 0.1f));
        float faceYaw = f3 * (float)Math.PI / 180.0f;
        float facePitch = f4 * (float)Math.PI / 180.0f;
        float f6 = 0.0f;
        this.brow1.field_78808_h -= (1.0f - (float)player.func_71024_bL().func_75116_a() / 20.0f) * (float)Math.PI / 13.0f;
        this.brow2.field_78808_h += (1.0f - (float)player.func_71024_bL().func_75116_a() / 20.0f) * (float)Math.PI / 13.0f;
        float browAnim = (float)data.prevBrowTick + (float)(data.browTick - data.prevBrowTick) * this.partialTick;
        f1 = browAnim / 8.0f;
        f6 = 1.0f - f1;
        this.brow1.field_78797_d -= f6 * 0.2f;
        this.brow2.field_78797_d -= f6 * 0.2f;
        if (this.brow1.field_78808_h > 0.0f) {
            this.brow1.field_78808_h *= 1.0f - f6 * 0.8f;
        }
        if (this.brow2.field_78808_h < 0.0f) {
            this.brow2.field_78808_h *= 1.0f - f6 * 0.8f;
        }
        float walkSpeed = 0.6f;
        float walkAnim1 = MathHelper.func_76126_a((float)(f * walkSpeed));
        float walkAnim2 = -MathHelper.func_76126_a((float)(f * walkSpeed + (data.moveBackwards ? -1.4f : 1.4f)));
        f1 = oldF1;
        if (!data.isAirborne) {
            this.pelvis.field_78797_d += Math.abs(walkAnim1) * 1.4f * f1;
        }
        this.arm1.field_78795_f -= walkAnim1 * 0.8f * f1;
        this.arm2.field_78795_f += walkAnim1 * 0.8f * f1;
        this.forearm1.field_78795_f -= Math.max(0.0f, walkAnim1) * 0.5f * f1;
        this.forearm2.field_78795_f += Math.min(0.0f, walkAnim1) * 0.5f * f1;
        this.leg1.field_78795_f += walkAnim1 * 0.9f * f1;
        this.leg2.field_78795_f -= walkAnim1 * 0.9f * f1;
        this.foot1.field_78795_f += (0.5f + walkAnim2 * 0.9f) * f1;
        this.foot2.field_78795_f += (0.5f - walkAnim2 * 0.9f) * f1;
        this.arm1.field_78808_h -= f1 * 0.06f;
        this.arm2.field_78808_h += f1 * 0.06f;
        this.leg1.field_78808_h -= f1 * 0.05f;
        this.leg2.field_78808_h += f1 * 0.05f;
        if (data.sprintTick > 0 || data.prevSprintTick > 0) {
            int sprintTick = data.sprintTick;
            int prevSprintTick = data.prevSprintTick;
            float sprint = (float)prevSprintTick + (float)(sprintTick - prevSprintTick) * this.partialTick;
            f6 = 1.0f - sprint / 8.0f;
            if (!data.isAirborne) {
                this.pelvis.field_78797_d = 12.0f + (this.pelvis.field_78797_d - 12.0f) * f6;
            }
            ModelPlayer.multiplyAngles(f6, this.chest, this.pelvis);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            float runSpeed = 0.7f;
            float runAnim1 = MathHelper.func_76126_a((float)(f * runSpeed));
            float runAnim2 = -MathHelper.func_76126_a((float)(f * runSpeed + 1.4f));
            f1 = sprint / 10.0f;
            if (!data.isAirborne) {
                this.pelvis.field_78797_d += Math.abs(runAnim1) * 1.8f * f1;
            }
            this.chest.field_78795_f += f1 * 0.3f;
            this.head.field_78795_f -= f1 * 0.3f;
            this.arm1.field_78795_f -= runAnim1 * 1.2f * f1;
            this.arm2.field_78795_f += runAnim1 * 1.2f * f1;
            this.forearm1.field_78795_f -= Math.max(0.3f, runAnim1) * 1.2f * f1;
            this.forearm2.field_78795_f += Math.min(-0.3f, runAnim1) * 1.2f * f1;
            this.leg1.field_78795_f += runAnim1 * 1.4f * f1;
            this.leg2.field_78795_f -= runAnim1 * 1.4f * f1;
            this.foot1.field_78795_f += (0.9f + runAnim2 * 1.1f) * f1;
            this.foot2.field_78795_f += (0.9f - runAnim2 * 1.1f) * f1;
            this.arm1.field_78808_h += f1 * 0.16f;
            this.arm2.field_78808_h -= f1 * 0.16f;
            this.leg1.field_78808_h += f1 * 0.03f;
            this.leg2.field_78808_h -= f1 * 0.03f;
        }
        if (data.sneakTick > 0 || data.prevSneakTick > 0) {
            float sneak = (float)data.prevSneakTick + (float)(data.sneakTick - data.prevSneakTick) * this.partialTick;
            f1 = sneak / 6.0f;
            f6 = 1.0f - f1;
            ModelPlayer.multiplyAngles(f6, this.chest, this.pelvis);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            this.chest.field_78795_f += 0.3926991f * f1;
            this.head.field_78795_f -= 0.5235988f * f1;
            this.arm1.field_78795_f += 0.2617994f * f1;
            this.arm1.field_78808_h += 0.22439948f * f1;
            this.arm2.field_78795_f += 0.2617994f * f1;
            this.arm2.field_78808_h -= 0.22439948f * f1;
            this.forearm1.field_78795_f -= 0.5235988f * f1;
            this.forearm2.field_78795_f -= 0.5235988f * f1;
            this.leg1.getModel().field_78795_f -= 0.5235988f * f1;
            this.leg1.getModel().field_78808_h += 0.22439948f * f1;
            this.leg2.getModel().field_78795_f -= 0.5235988f * f1;
            this.leg2.getModel().field_78808_h -= 0.22439948f * f1;
            this.foot1.field_78795_f += 0.7853982f * f1;
            this.foot1.field_78808_h -= 0.19634955f * f1;
            this.foot2.field_78795_f += 0.7853982f * f1;
            this.foot2.field_78808_h += 0.19634955f * f1;
            float sneakSpeed = 0.6f;
            float sneakAnim1 = MathHelper.func_76126_a((float)(f * sneakSpeed));
            float sneakAnim2 = -MathHelper.func_76126_a((float)(f * sneakSpeed + (data.moveBackwards2 ? -0.8f : 0.8f)));
            this.pelvis.field_78797_d += (-0.5f + Math.abs(sneakAnim1) * 1.4f) * f1;
            this.arm1.field_78795_f -= sneakAnim1 * 0.8f * f1;
            this.arm2.field_78795_f += sneakAnim1 * 0.8f * f1;
            this.forearm1.field_78795_f -= Math.max(0.0f, sneakAnim1) * 0.6f * f1;
            this.forearm2.field_78795_f += Math.min(0.0f, sneakAnim1) * 0.6f * f1;
            this.leg1.field_78795_f += (-0.1f + sneakAnim1 * 0.7f) * f1;
            this.leg2.field_78795_f += (-0.1f - sneakAnim1 * 0.7f) * f1;
            this.foot1.getModel().field_78795_f += (0.4f + sneakAnim2 * 0.6f) * f1;
            this.foot2.getModel().field_78795_f += (0.4f - sneakAnim2 * 0.6f) * f1;
        }
        if (data.blockTick > 0 || data.prevBlockTick > 0) {
            f1 = (float)data.prevBlockTick + (float)(data.blockTick - data.prevBlockTick) * this.partialTick;
            f6 = 1.0f - f1;
            float blockF1 = Math.min(0.25f, oldF1);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.chest, this.pelvis, this.head});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            this.pelvis.field_78797_d += 1.0f + Math.abs(MathHelper.func_76126_a((float)(f * 0.8f)) * 0.6f) * blockF1 * f1;
            this.chest.field_78795_f += 0.2617994f * f1;
            this.head.field_78795_f -= 0.2617994f * f1;
            this.arm1.field_78795_f -= 0.3926991f * f1;
            this.arm1.field_78796_g -= 0.7853982f * f1;
            this.arm1.field_78808_h += 0.7853982f * f1;
            this.arm2.field_78808_h -= 0.5235988f * f1;
            this.forearm1.field_78795_f -= 0.31415927f * f1;
            this.forearm2.field_78795_f -= 0.5235988f * f1;
            this.leg1.field_78795_f -= 0.3926991f * f1;
            this.leg1.field_78808_h += 0.22439948f * f1;
            this.leg2.field_78795_f -= 0.3926991f * f1;
            this.leg2.field_78808_h -= 0.22439948f * f1;
            this.foot1.field_78808_h -= 0.17453294f * f1;
            this.foot2.field_78808_h += 0.17453294f * f1;
            this.foot1.getModel().field_78795_f += 0.5235988f * f1;
            this.foot2.getModel().field_78795_f += 0.5235988f * f1;
            this.leg1.field_78795_f += MathHelper.func_76126_a((float)(f * 0.8f)) * 2.1f * blockF1 * f1;
            this.leg2.field_78795_f -= MathHelper.func_76126_a((float)(f * 0.8f)) * 2.1f * blockF1 * f1;
            this.foot1.field_78795_f += (0.5f + MathHelper.func_76126_a((float)(f * 0.8f - 1.2f)) * 2.1f) * blockF1 * f1;
            this.foot2.field_78795_f += (0.5f - MathHelper.func_76126_a((float)(f * 0.8f - 1.2f)) * 2.1f) * blockF1 * f1;
        }
        if (data.jumpTick > 0 || data.prevJumpTick > 0) {
            float jumpAnim = (float)data.prevJumpTick + (float)(data.jumpTick - data.prevJumpTick) * this.partialTick;
            f1 = Math.min(4.0f, jumpAnim) / 5.0f;
            f6 = 1.0f - f1;
            float jumpClamp = jumpAnim / 10.0f;
            float jumpMove = MathHelper.func_76126_a((float)(jumpClamp * (float)Math.PI)) * (float)(data.jumpRight ? 1 : -1);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.pelvis, this.head});
            ModelPlayer.multiplyAngles(f6 * 0.6f, this.chest);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            this.pelvis.field_78795_f += 0.2617994f * f1;
            this.head.field_78795_f -= 0.2617994f * f1;
            this.arm1.field_78795_f += (float)Math.PI / (4.0f - oldF1 * 2.0f) * jumpMove * f1;
            this.arm1.field_78808_h += (0.2617994f + MathHelper.func_76126_a((float)(f2 * 0.3f - 0.7f)) * 0.2f) * f1;
            this.arm2.field_78795_f += (float)(-Math.PI) / (4.0f - oldF1 * 2.0f) * jumpMove * f1;
            this.arm2.field_78808_h -= (0.2617994f + MathHelper.func_76126_a((float)(f2 * 0.3f - 1.5f)) * 0.2f) * f1;
            this.forearm1.field_78795_f -= 0.5235988f * f1;
            this.forearm2.field_78795_f -= 0.5235988f * f1;
            this.leg1.field_78795_f += (-0.7853982f + (float)(-Math.PI) / (5.0f - oldF1 * 2.5f) * jumpMove) * f1;
            this.leg1.field_78795_f += MathHelper.func_76126_a((float)(f2 * 0.3f)) * 0.3f * f1;
            this.leg1.field_78808_h += 0.22439948f * f1;
            this.leg2.field_78795_f += (-0.7853982f + (float)Math.PI / (5.0f - oldF1 * 2.5f) * jumpMove) * f1;
            this.leg2.field_78795_f += MathHelper.func_76126_a((float)(f2 * 0.3f - 1.1f)) * 0.3f * f1;
            this.leg2.field_78808_h -= 0.22439948f * f1;
            this.foot1.field_78795_f += 1.2566371f * f1;
            this.foot2.field_78795_f += 1.2566371f * f1;
        }
        if (data.swimTick > 0 || data.prevSwimTick > 0) {
            float swimAnim = (float)data.prevSwimTick + (float)(data.swimTick - data.prevSwimTick) * this.partialTick;
            float swimPitch = data.swimPitch + (data.swimPitch - data.prevSwimPitch) * this.partialTick - 1.5707964f;
            f1 = swimAnim / 16.0f;
            f6 = 1.0f - f1;
            ModelPlayer.multiplyAngles(f6, this.chest, this.pelvis);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            float swimF1 = Math.min(1.0f, oldF1 * 2.5f);
            float swimInvF1 = 1.0f - swimF1;
            this.pelvis.field_78797_d += f1 * 6.0f * swimInvF1;
            this.pelvis.field_78795_f += (0.44879895f + 1.2f * swimF1) * f1;
            this.pelvis.field_78795_f += (0.448799f + 1.2f * swimF1 + swimF1 * swimPitch) * f1;
            this.head.field_78795_f -= this.pelvis.field_78795_f * f1;
            this.arm1.field_78795_f -= (MathHelper.func_76126_a((float)(f * 0.5f)) * 1.4f + 1.8f) * swimF1 * f1;
            this.arm1.field_78796_g -= Math.min(0.0f, MathHelper.func_76126_a((float)(f * 0.5f + 2.2f)) * 1.6f) * swimF1 * f1;
            this.arm1.field_78808_h += (0.7853982f + MathHelper.func_76126_a((float)(f2 * 0.15f)) * 0.2f) * swimInvF1 * f1;
            this.arm2.field_78795_f -= (MathHelper.func_76126_a((float)(f * 0.5f)) * 1.4f + 1.8f) * swimF1 * f1;
            this.arm2.field_78796_g += Math.min(0.0f, MathHelper.func_76126_a((float)(f * 0.5f + 2.2f)) * 1.6f) * swimF1 * f1;
            this.arm2.field_78808_h -= (0.7853982f + MathHelper.func_76126_a((float)(f2 * 0.15f)) * 0.2f) * swimInvF1 * f1;
            this.forearm1.field_78795_f -= 0.5235988f * swimInvF1 * f1;
            this.forearm2.field_78795_f -= 0.5235988f * swimInvF1 * f1;
            this.leg1.field_78795_f -= (0.31415927f + MathHelper.func_76126_a((float)(f2 * 0.3f)) * 0.2f * swimInvF1 + MathHelper.func_76126_a((float)(f * 1.1f)) * 0.8f * swimF1) * f1;
            this.leg1.field_78808_h += (0.3926991f - 0.4f * swimF1) * f1;
            this.leg2.field_78795_f -= (0.31415927f - MathHelper.func_76126_a((float)(f2 * 0.3f)) * 0.2f * swimInvF1 - MathHelper.func_76126_a((float)(f * 1.1f)) * 0.8f * swimF1) * f1;
            this.leg2.field_78808_h -= (0.3926991f - 0.4f * swimF1) * f1;
            this.foot1.field_78795_f += 0.5235988f * invF1 * f1;
            this.foot2.field_78795_f += 0.5235988f * invF1 * f1;
        }
        if (data.climbingTick > 0 || data.prevClimbingTick > 0) {
            float climbAnim = (float)data.prevClimbingTick + (float)(data.climbingTick - data.prevClimbingTick) * this.partialTick;
            f1 = climbAnim / 8.0f;
            f6 = 1.0f - f1;
            ModelPlayer.multiplyAngles(f6, this.chest, this.pelvis);
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            float offset = data.prevClimbingOffset + (data.climbingOffset - data.prevClimbingOffset) * this.partialTick;
            float climb1 = MathHelper.func_76126_a((float)(offset * 0.6f));
            float climb2 = MathHelper.func_76126_a((float)(offset * 0.6f + 1.4f));
            this.arm1.field_78795_f -= 1.3962635f * f1;
            this.arm2.field_78795_f -= 1.3962635f * f1;
            this.forearm1.field_78795_f -= 0.62831855f * f1;
            this.forearm2.field_78795_f -= 0.62831855f * f1;
            this.leg1.field_78808_h += 0.09817477f * f1;
            this.leg1.getModel().field_78795_f -= 1.0471976f * f1;
            this.leg2.field_78808_h -= 0.09817477f;
            this.leg2.getModel().field_78795_f -= 1.0471976f * f1;
            this.foot1.field_78795_f += 0.7853982f * f1;
            this.foot2.field_78795_f += 0.7853982f * f1;
            this.arm1.field_78795_f += climb1 * 0.6f * f1;
            this.arm2.field_78795_f -= climb1 * 0.6f * f1;
            this.forearm1.field_78795_f += climb2 * 0.6f * f1;
            this.forearm2.field_78795_f -= climb2 * 0.6f * f1;
            this.leg1.field_78795_f -= climb1 * 0.5f * f1;
            this.leg2.field_78795_f += climb1 * 0.5f * f1;
            this.foot1.field_78795_f += (0.4f + climb2) * 0.5f * f1;
            this.foot2.field_78795_f += (0.4f - climb2) * 0.5f * f1;
        }
        if (data.eatTick > 0 || data.prevEatTick > 0) {
            float eatAnim = (float)data.prevEatTick + (float)(data.eatTick - data.prevEatTick) * this.partialTick;
            f1 = eatAnim / 8.0f;
            f6 = 1.0f - f1;
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.head, this.arm1, this.forearm1});
            facePitch *= f6;
            faceYaw *= f6;
            float eatMove = MathHelper.func_76126_a((float)(f2 * 1.1f)) * 0.2f;
            this.head.field_78795_f += (0.19634955f + eatMove) * f1 * f1 * f1;
            this.arm1.field_78795_f -= 0.62831855f * f1;
            this.arm1.field_78796_g -= 0.62831855f * f1;
            this.forearm1.field_78795_f -= 0.62831855f * f1;
        }
        if (data.drinkTick > 0 || data.prevDrinkTick > 0) {
            float drinkAnim = (float)data.prevDrinkTick + (float)(data.drinkTick - data.prevDrinkTick) * this.partialTick;
            f1 = drinkAnim / 8.0f;
            f6 = 1.0f - f1;
            ModelPlayer.multiplyAngles(f6, new ModelRenderer[]{this.head, this.arm1, this.forearm1});
            facePitch *= f6;
            faceYaw *= f6;
            this.head.field_78795_f -= 0.19634955f * f1;
            this.arm1.field_78795_f -= 0.7853982f * f1;
            this.arm1.field_78796_g -= 0.5235988f * f1;
            this.forearm1.field_78795_f -= 0.62831855f * f1;
        }
        if (this.field_78093_q) {
            ModelPlayer.resetAngles(this.chest, this.pelvis);
            ModelPlayer.resetAngles(new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            ModelPlayer.resetAngles(new ModelRenderer[]{this.leg1, this.leg2, this.leg1.getModel(), this.leg2.getModel()});
            ModelPlayer.resetAngles(new ModelRenderer[]{this.foot1, this.foot2, this.foot1.getModel(), this.foot2.getModel()});
            this.pelvis.field_78797_d = 12.0f;
            faceYaw = Math.min(1.57f, faceYaw);
            faceYaw = Math.max(-1.57f, faceYaw);
            if (player.field_70154_o instanceof EntityLiving) {
                this.pelvis.field_78798_e += 4.0f;
                this.chest.field_78795_f += 0.31415927f;
                this.head.field_78795_f -= 0.31415927f;
                this.arm1.field_78795_f -= 0.5235988f;
                this.arm2.field_78795_f -= 0.5235988f;
                this.forearm1.field_78795_f -= 0.44879895f;
                this.forearm2.field_78795_f -= 0.44879895f;
                this.leg1.field_78795_f -= 1.2566371f;
                this.leg1.field_78796_g += 0.5235988f;
                this.leg2.field_78795_f -= 1.2566371f;
                this.leg2.field_78796_g -= 0.5235988f;
                this.foot1.field_78795_f += 0.62831855f;
                this.foot2.field_78795_f += 0.62831855f;
            } else {
                this.pelvis.field_78798_e += 2.0f;
                this.arm1.field_78795_f -= 0.62831855f;
                this.arm2.field_78795_f -= 0.62831855f;
                this.leg1.field_78795_f -= 1.2566371f;
                this.leg1.field_78796_g += 0.31415927f;
                this.leg2.field_78795_f -= 1.2566371f;
                this.leg2.field_78796_g -= 0.31415927f;
            }
        }
        if (this.field_78118_o > 0) {
            player.field_70761_aq = player.field_70177_z - 40.0f;
            float aimTick = ((float)(Items.field_151031_f.func_77626_a(null) - this.field_78118_o) + this.partialTick) / 22.0f;
            aimTick = Math.min(1.0f, aimTick);
            ModelPlayer.resetAngles(new ModelRenderer[]{this.arm1, this.arm2, this.forearm1, this.forearm2});
            this.arm1.field_78795_f += facePitch - 1.5f;
            this.arm1.field_78796_g += faceYaw - 0.3f;
            this.arm2.field_78795_f += Math.max(-0.79f, Math.min(0.5f, facePitch)) - 1.5f;
            this.arm2.field_78796_g += faceYaw + 0.6f - aimTick * 0.8f;
            this.forearm2.field_78808_h += aimTick * 0.8f;
        }
        if (this.field_78095_p > 1.0E-4f) {
            float neg;
            ModelPlayer.resetAngles(this.arm1);
            this.arm1.field_78795_f = 0.1f;
            this.arm1.field_78808_h = 0.1f;
            if (!data.holdingSword) {
                if (this.field_78095_p < 0.2f) {
                    float tick = this.field_78095_p / 0.2f;
                    float rot = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    this.chest.field_78796_g += rot * (float)Math.PI / 12.0f;
                    this.arm1.field_78795_f += -rot * (float)Math.PI / 2.5f;
                    this.arm1.field_78808_h += rot * (float)Math.PI / 10.0f;
                    this.arm2.field_78808_h += -rot * (float)Math.PI / 20.0f;
                } else if (this.field_78095_p < 0.5f) {
                    float tick = (this.field_78095_p - 0.2f) / 0.3f;
                    float rot = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    neg = 1.0f - rot;
                    this.chest.field_78796_g += -rot * (float)Math.PI / 12.0f + neg * (float)Math.PI / 12.0f;
                    this.arm1.field_78795_f += rot * (float)Math.PI / 8.0f - neg * (float)Math.PI / 2.5f;
                    this.arm1.field_78796_g += -rot * (float)Math.PI / 16.0f;
                    this.arm1.field_78808_h += rot * (float)Math.PI / 16.0f - neg * (float)Math.PI / 10.0f;
                    this.arm2.field_78795_f += rot * (float)Math.PI / 14.0f;
                    this.arm2.field_78808_h += -0.15707964f;
                } else if (this.field_78095_p < 0.6f) {
                    this.chest.field_78796_g += -0.2617994f;
                    this.arm1.field_78795_f += 0.3926991f;
                    this.arm1.field_78796_g += -0.19634955f;
                    this.arm1.field_78808_h += 0.19634955f;
                    this.arm2.field_78795_f += 0.22439948f;
                    this.arm2.field_78808_h += -0.15707964f;
                } else if (this.field_78095_p < 0.8f) {
                    float tick = (this.field_78095_p - 0.6f) / 0.2f;
                    float rot = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                    this.chest.field_78796_g += -rot * (float)Math.PI / 12.0f;
                    this.arm1.field_78795_f += rot * (float)Math.PI / 8.0f;
                    this.arm1.field_78796_g += -rot * (float)Math.PI / 16.0f;
                    this.arm1.field_78808_h += rot * (float)Math.PI / 16.0f;
                    this.arm2.field_78795_f += rot * (float)Math.PI / 14.0f;
                    this.arm2.field_78808_h += -rot * (float)Math.PI / 20.0f;
                }
            } else if (this.field_78095_p < 0.2f) {
                float tick = this.field_78095_p / 0.2f;
                float rot = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                this.chest.field_78796_g += rot * (float)Math.PI / 10.0f;
                this.arm1.field_78795_f += rot * (float)Math.PI / 8.0f;
                this.arm1.field_78808_h += rot * (float)Math.PI / 6.0f;
                this.arm2.field_78795_f += -rot * (float)Math.PI / 12.0f;
                this.arm2.field_78808_h += -rot * (float)Math.PI / 12.0f;
            } else if (this.field_78095_p < 0.5f) {
                float tick = (this.field_78095_p - 0.2f) / 0.3f;
                float rot = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                neg = 1.0f - rot;
                this.chest.field_78796_g += neg * (float)Math.PI / 10.0f - rot * (float)Math.PI / 8.0f;
                this.arm1.field_78795_f += neg * (float)Math.PI / 8.0f - rot * (float)Math.PI / 2.5f;
                this.arm1.field_78808_h += neg * (float)Math.PI / 6.0f + rot * (float)Math.PI / 2.75f;
                this.arm2.field_78795_f += -neg * (float)Math.PI / 12.0f + rot * (float)Math.PI / 10.0f;
                this.arm2.field_78808_h += -0.2617994f;
            } else if (this.field_78095_p < 0.6f) {
                this.chest.field_78796_g += -0.3926991f;
                this.arm1.field_78795_f += -1.2566371f;
                this.arm1.field_78808_h += 1.1423974f;
                this.arm2.field_78795_f += 0.31415927f;
                this.arm2.field_78808_h += -0.2617994f;
            } else if (this.field_78095_p < 0.9f) {
                float tick = (this.field_78095_p - 0.6f) / 0.3f;
                float rot = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
                this.chest.field_78796_g += -rot * (float)Math.PI / 8.0f;
                this.arm1.field_78795_f += -rot * (float)Math.PI / 2.5f;
                this.arm1.field_78808_h += rot * (float)Math.PI / 2.75f;
                this.arm2.field_78795_f += rot * (float)Math.PI / 10.0f;
                this.arm2.field_78808_h += -rot * (float)Math.PI / 12.0f;
            }
        }
        this.head.getModel().field_78795_f = facePitch;
        this.head.getModel().field_78796_g = faceYaw;
        float rightEye = faceYaw < 0.0f ? 0.6f : 3.0f;
        float leftEye = faceYaw > 0.0f ? 0.6f : 3.0f;
        for (int i = 0; i < this.rightEye.length; ++i) {
            this.rightEye[i].field_78800_c -= faceYaw * rightEye / 4.712389f;
            this.leftEye[i].field_78800_c -= faceYaw * leftEye / 4.712389f;
        }
        this.head.field_78795_f += breatheAnim * 0.01f;
        if (this.chest instanceof ModelObjRenderer) {
            ((ModelObjRenderer)this.chest).setScale(1.0f + breatheAnim * 0.015f);
        }
        this.chest.field_78795_f -= breatheAnim * 0.02f - 0.02f;
        this.brow1.field_78797_d -= breatheAnim * 0.06f;
        this.brow2.field_78797_d -= breatheAnim * 0.06f;
        this.arm1.field_78808_h += breatheAnim * 0.03f + 0.03f;
        this.arm2.field_78808_h -= breatheAnim * 0.03f + 0.03f;
        float mouthAnim = (float)data.prevExhaustionTick + (float)(data.exhaustionTick - data.prevExhaustionTick) * this.partialTick;
        f1 = mouthAnim / 10.0f;
        this.mouth.field_78797_d -= (breatheAnim * 0.25f + 0.25f) * f1;
    }

    public void postRender(float f, ModelRenderer model) {
        if (!this.field_78092_r.contains(model)) {
            throw new IllegalArgumentException("PostRender model is not in box list.");
        }
        this.pelvis.func_78794_c(f);
        if (model == this.head) {
            this.chest.func_78794_c(f);
        } else if (this.isOnHead(model)) {
            this.chest.func_78794_c(f);
            this.head.func_78794_c(f);
        } else if (model == this.forearm1) {
            this.chest.func_78794_c(f);
            this.arm1.func_78794_c(f);
        } else if (model == this.forearm2) {
            this.chest.func_78794_c(f);
            this.arm2.func_78794_c(f);
        } else if (model == this.foot1) {
            this.leg1.func_78794_c(f);
        } else if (model == this.foot2) {
            this.leg2.func_78794_c(f);
        }
        model.func_78794_c(f);
    }

    private boolean isOnHead(ModelRenderer model) {
        if (model == this.headwear || model == this.brow1 || model == this.brow2) {
            return true;
        }
        if (model == this.upperLip || model == this.lowerLip || model == this.insideMouth || model == this.mouth || model == this.upperTeeth || model == this.lowerTeeth) {
            return true;
        }
        for (int i = 0; i < this.rightEye.length; ++i) {
            for (int j = 0; j < this.iris.length; ++j) {
                if (model != this.iris[j][i]) continue;
                return true;
            }
            if (model == this.rightEye[i]) {
                return true;
            }
            if (model != this.leftEye[i]) continue;
            return true;
        }
        return false;
    }
}

