/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api;

import biomesoplenty.common.world.layer.GenLayerBiomeBOP;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class BOPBiomeHelper {
    public static HashMap<String, BOPBiomeEntry>[] biomeLists = new HashMap[256];

    public static void init() {
        BOPBiomeHelper.biomeLists[0] = new HashMap();
        BOPBiomeHelper.biomeLists[1] = new HashMap();
    }

    public static void registerBiome(BOPBiomeEntry biome, int dimID, String name) {
        biomeLists[dimID + 1].put(name, biome);
    }

    public static void registerBiome(BOPBiomeEntry biome, String name) {
        BOPBiomeHelper.registerBiome(biome, 0, name);
    }

    public static BiomeGenBase get(int dimID, String name) {
        return BOPBiomeHelper.biomeLists[dimID + 1].get((Object)new StringBuilder().append((String)"biomesoplenty:").append((String)name).toString()).biome;
    }

    public static BiomeGenBase get(String name) {
        return BOPBiomeHelper.get(0, name);
    }

    public static String convertBiomeName(String originalName) {
        return StringUtils.remove((String)StringUtils.uncapitalize((String)WordUtils.capitalize((String)originalName)), (String)" ");
    }

    public static List<BOPBiomeEntry> getCorrespondingTemperatureTypeList(TemperatureType type) {
        switch (type) {
            case HOT: {
                return GenLayerBiomeBOP.desertBiomes;
            }
            case WARM: {
                return GenLayerBiomeBOP.warmBiomes;
            }
            case COOL: {
                return GenLayerBiomeBOP.coldBiomes;
            }
            case ICY: {
                return GenLayerBiomeBOP.icyBiomes;
            }
        }
        return GenLayerBiomeBOP.warmBiomes;
    }

    public static class BOPBiomeEntry
    extends WeightedRandom.Item {
        public BiomeGenBase biome;
        public TemperatureType temperatureType;

        public BOPBiomeEntry(BiomeGenBase biome, TemperatureType temperatureType, int weight) {
            super(weight);
            this.biome = biome;
            this.temperatureType = temperatureType;
        }

        public BOPBiomeEntry(BiomeGenBase biome, int weight) {
            this(biome, TemperatureType.WARM, weight);
        }

        public void addToCorrespondingTemperatureTypeList() {
            BOPBiomeHelper.getCorrespondingTemperatureTypeList(this.temperatureType).add(this);
        }
    }

    public static enum TemperatureType {
        HOT,
        WARM,
        COOL,
        ICY;

    }
}

