/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biomes;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.biomes.BOPBiome;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPTallGrass;
import biomesoplenty.common.world.features.trees.WorldGenCypress;
import biomesoplenty.common.world.features.trees.WorldGenDeadTree1;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;

public class BiomeGenLushDesert
extends BOPBiome {
    private static final BiomeGenBase.Height biomeHeight = new BiomeGenBase.Height(0.2f, 0.5f);

    public BiomeGenLushDesert(int id) {
        super(id);
        this.func_150570_a(biomeHeight);
        this.func_76739_b(9087277);
        this.func_76732_a(1.0f, 0.3f);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityHorse.class, 5, 2, 6));
        this.field_76752_A = Blocks.field_150405_ch;
        this.field_76753_B = Blocks.field_150405_ch;
        this.field_76760_I.field_76832_z = 6;
        this.field_76760_I.field_76803_B = 8;
        this.field_76760_I.field_76800_F = 20;
        this.field_76760_I.field_76804_C = 2;
        this.bopWorldFeatures.setFeature("shrubsPerChunk", 10);
        this.bopWorldFeatures.setFeature("oasesPerChunk", 999);
        this.bopWorldFeatures.setFeature("bopFlowersPerChunk", 5);
        this.bopWorldFeatures.setFeature("tinyCactiPerChunk", 5);
        this.bopWorldFeatures.setFeature("waterLakesPerChunk", 5);
        this.bopWorldFeatures.setFeature("waterReedsPerChunk", 4);
        this.bopWorldFeatures.setFeature("bromeliadsPerChunk", 3);
        this.bopWorldFeatures.setFeature("leafPilesPerChunk", 2);
        this.bopWorldFeatures.setFeature("deadLeafPilesPerChunk", 4);
        this.bopWorldFeatures.setFeature("generateSand", true);
        this.bopWorldFeatures.setFeature("generatePumpkins", false);
        this.bopWorldFeatures.setFeature("bopGrassPerChunk", 8);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPDoubleFlora(4, 5), 4);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 7), 8);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 10), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 11), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("plants"), 1), 1.0);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass((Block)Blocks.field_150329_H, 1), 1.0);
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        return random.nextInt(4) == 0 ? new WorldGenCypress(Blocks.field_150363_s, (Block)Blocks.field_150361_u, 0, 0, false, 7, 10, 2) : (random.nextInt(18) == 0 ? new WorldGenDeadTree1(false, new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, BOPBlockHelper.get("grass"), BOPBlockHelper.get("driedDirt"), Blocks.field_150405_ch}) : (random.nextInt(2) == 0 ? this.field_76757_N : new WorldGenShrub(0, 0)));
    }

    @Override
    public void func_76728_a(World world, Random random, int chunkX, int chunkZ) {
        Block block;
        int z;
        int y;
        int x;
        int var6;
        super.func_76728_a(world, random, chunkX, chunkZ);
        int var5 = 12 + random.nextInt(6);
        for (var6 = 0; var6 < var5; ++var6) {
            x = chunkX + random.nextInt(16);
            block = world.func_147439_a(x, y = random.nextInt(28) + 4, z = chunkZ + random.nextInt(16));
            if (block == null || !block.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) continue;
            world.func_147465_d(x, y, z, BOPBlockHelper.get("gemOre"), 2, 2);
        }
        for (var6 = 0; var6 < var5; ++var6) {
            x = chunkX + random.nextInt(16);
            block = world.func_147439_a(x, y = random.nextInt(53) + 75, z = chunkZ + random.nextInt(16));
            if (block == null || !block.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b) && block != BOPBlockHelper.get("redRock")) continue;
            world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 2);
        }
    }

    public void func_150573_a(World p_150573_1_, Random p_150573_2_, Block[] p_150573_3_, byte[] p_150573_4_, int p_150573_5_, int p_150573_6_, double p_150573_7_) {
        if (p_150573_7_ > 1.75) {
            this.field_76752_A = Blocks.field_150349_c;
            this.field_76753_B = Blocks.field_150346_d;
            this.field_150604_aj = 0;
        } else if (p_150573_7_ > -0.5) {
            this.field_76752_A = Blocks.field_150405_ch;
            this.field_76753_B = Blocks.field_150405_ch;
            this.field_150604_aj = 0;
        }
        this.func_150560_b(p_150573_1_, p_150573_2_, p_150573_3_, p_150573_4_, p_150573_5_, p_150573_6_, p_150573_7_);
    }
}

