/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biomes;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.biomes.BOPBiome;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPTallGrass;
import biomesoplenty.common.world.features.trees.WorldGenBOPSwampTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class BiomeGenLushSwamp
extends BOPBiome {
    private static final BiomeGenBase.Height biomeHeight = new BiomeGenBase.Height(0.0f, 0.1f);

    public BiomeGenLushSwamp(int id) {
        super(id);
        this.func_150570_a(biomeHeight);
        this.func_76739_b(5746228);
        this.func_76732_a(0.7f, 1.0f);
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 1, 1, 1));
        this.field_76760_I.field_76832_z = 10;
        this.field_76760_I.field_76803_B = 4;
        this.field_76760_I.field_76798_D = 8;
        this.field_76760_I.field_76799_E = 16;
        this.bopWorldFeatures.setFeature("bopFlowersPerChunk", 1);
        this.bopWorldFeatures.setFeature("cattailsPerChunk", 10);
        this.bopWorldFeatures.setFeature("highCattailsPerChunk", 5);
        this.bopWorldFeatures.setFeature("riverCanePerChunk", 5);
        this.bopWorldFeatures.setFeature("wildCarrotsPerChunk", 1);
        this.bopWorldFeatures.setFeature("shrubsPerChunk", 5);
        this.bopWorldFeatures.setFeature("koruPerChunk", 1);
        this.bopWorldFeatures.setFeature("waterReedsPerChunk", 6);
        this.bopWorldFeatures.setFeature("cloverPatchesPerChunk", 10);
        this.bopWorldFeatures.setFeature("seaweedPerChunk", 10);
        this.bopWorldFeatures.setFeature("bopGrassPerChunk", 4);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 4), 8);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora((Block)Blocks.field_150328_O, 2), 4);
        this.bopWorldFeatures.weightedFlowerGen.put(new WorldGenBOPFlora((Block)Blocks.field_150328_O, 1), 6);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 10), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass(BOPBlockHelper.get("foliage"), 11), 0.5);
        this.bopWorldFeatures.weightedGrassGen.put(new WorldGenBOPTallGrass((Block)Blocks.field_150329_H, 1), 1.0);
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        return new WorldGenBOPSwampTree(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, 8, 6, BOPBlockHelper.get("ivy"), -1);
    }

    @Override
    public void func_76728_a(World world, Random random, int chunkX, int chunkZ) {
        super.func_76728_a(world, random, chunkX, chunkZ);
        int var5 = 12 + random.nextInt(6);
        for (int var6 = 0; var6 < var5; ++var6) {
            int z;
            int y;
            int x = chunkX + random.nextInt(16);
            Block block = world.func_147439_a(x, y = random.nextInt(28) + 4, z = chunkZ + random.nextInt(16));
            if (block == null || !block.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) continue;
            world.func_147465_d(x, y, z, BOPBlockHelper.get("gemOre"), 10, 2);
        }
    }
}

