/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.configuration;

import biomesoplenty.api.BOPBiomeHelper;
import biomesoplenty.common.core.BOPBiomes;
import biomesoplenty.common.world.layer.hell.BiomeLayerHellBiomes;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;

public class BOPConfigurationBiomeGen {
    public static Configuration config;
    public static ArrayList<String> disabledBiomes;
    public static boolean oceanGen;
    public static boolean frozenOceanGen;
    public static boolean deepOceanGen;
    public static boolean mushroomIslandGen;
    public static boolean mesaPlateauFGen;
    public static boolean mesaPlateauGen;
    public static boolean jungleGen;
    public static boolean megaTaigaGen;

    public static void addDefaultDisabledBiomes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        BOPConfigurationBiomeGen.addDefaultDisabledBiomes();
        config = new Configuration(configFile);
        try {
            String convertedName;
            String name;
            BiomeGenBase biome;
            config.load();
            for (BOPBiomeHelper.BOPBiomeEntry entry : BOPBiomeHelper.biomeLists[0].values()) {
                biome = entry.biome;
                convertedName = BOPBiomeHelper.convertBiomeName(name = biome.field_76791_y);
                if (!config.get("Nether Biomes To Generate (There must be at least one from each category)", name, !disabledBiomes.contains(convertedName)).getBoolean(!disabledBiomes.contains(convertedName))) continue;
                BiomeLayerHellBiomes.netherBiomes.add(biome);
            }
            for (BOPBiomeHelper.BOPBiomeEntry entry : BOPBiomeHelper.biomeLists[1].values()) {
                biome = entry.biome;
                name = biome.field_76791_y;
                convertedName = BOPBiomeHelper.convertBiomeName(name);
                if (!config.get("Overworld Biomes To Generate (There must be at least one from each category)", name + " (" + WordUtils.capitalize((String)entry.temperatureType.toString().toLowerCase()) + ")", !disabledBiomes.contains(convertedName)).getBoolean(!disabledBiomes.contains(convertedName)) || BOPBiomes.onlyBiome != null && entry != BOPBiomes.onlyBiome) continue;
                entry.addToCorrespondingTemperatureTypeList();
            }
            if (BOPBiomes.onlyBiome != null) {
                for (BOPBiomeHelper.TemperatureType temperatureType : BOPBiomeHelper.TemperatureType.values()) {
                    BOPBiomeHelper.getCorrespondingTemperatureTypeList(temperatureType).add(BOPBiomes.onlyBiome);
                }
            } else {
                oceanGen = config.get("Special Biomes To Generate", "Ocean", true).getBoolean(true);
                frozenOceanGen = config.get("Special Biomes To Generate", "FrozenOcean", true).getBoolean(true);
                deepOceanGen = config.get("Special Biomes To Generate", "Deep Ocean", true).getBoolean(true);
                mushroomIslandGen = config.get("Special Biomes To Generate", "MushroomIsland", true).getBoolean(true);
                mesaPlateauFGen = config.get("Special Biomes To Generate", "Mesa Plateau F", true).getBoolean(true);
                mesaPlateauGen = config.get("Special Biomes To Generate", "Mesa Plateau", true).getBoolean(true);
                jungleGen = config.get("Special Biomes To Generate", "Jungle", true).getBoolean(true);
                megaTaigaGen = config.get("Special Biomes To Generate", "Mega Taiga", true).getBoolean(true);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Biomes O Plenty has had a problem loading its configuration", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        disabledBiomes = new ArrayList();
        oceanGen = false;
        frozenOceanGen = false;
        deepOceanGen = false;
        mushroomIslandGen = false;
        mesaPlateauFGen = false;
        mesaPlateauGen = false;
        jungleGen = false;
        megaTaigaGen = false;
    }
}

