/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.decoration;

import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.generation.WorldGenFieldAssociation;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BOPWorldFeatures {
    public HashMap<WorldGenerator, Double> weightedGrassGen = new HashMap();
    public HashMap<WorldGenBOPFlora, Integer> weightedFlowerGen = new HashMap();
    private HashMap<String, Object> featureValueMap = new HashMap();

    protected BOPWorldFeatures() {
        this.addFeature("generatePumpkins", true);
        this.addFeature("generateQuicksand", false);
        this.addFeature("generateCanyon", false);
        this.addFeature("generateStoneInGrass", false);
        this.addFeature("generateStoneInGrass2", false);
        this.addFeature("generateGrass", false);
        this.addFeature("generateSand", false);
        this.addFeature("generateQuagmire", false);
        this.addFeature("generateAsh", false);
        this.addFeature("generateMelons", false);
        this.addFeature("waterPoolsPerChunk", 50);
        this.addFeature("lavaPoolsPerChunk", 20);
        this.addFeature("waterLakesPerChunk", 0);
        this.addFeature("lavaLakesPerChunk", 0);
        this.addFeature("mudPerChunk", 0);
        this.addFeature("riverCanePerChunk", 0);
        this.addFeature("shrubsPerChunk", 0);
        this.addFeature("bushesPerChunk", 0);
        this.addFeature("cloverPatchesPerChunk", 0);
        this.addFeature("seaweedPerChunk", 0);
        this.addFeature("leafPilesPerChunk", 0);
        this.addFeature("deadLeafPilesPerChunk", 0);
        this.addFeature("lavenderPerChunk", 0);
        this.addFeature("thornsPerChunk", 0);
        this.addFeature("stalagmitesPerChunk", 3);
        this.addFeature("stalactitesPerChunk", 6);
        this.addFeature("desertSproutsPerChunk", 0);
        this.addFeature("bromeliadsPerChunk", 0);
        this.addFeature("waterReedsPerChunk", 0);
        this.addFeature("wildCarrotsPerChunk", 0);
        this.addFeature("poisonIvyPerChunk", 0);
        this.addFeature("berryBushesPerChunk", 0);
        this.addFeature("portobellosPerChunk", 0);
        this.addFeature("koruPerChunk", 0);
        this.addFeature("toadstoolsPerChunk", 0);
        this.addFeature("blueMilksPerChunk", 0);
        this.addFeature("cattailsPerChunk", 0);
        this.addFeature("highCattailsPerChunk", 0);
        this.addFeature("algaePerChunk", 0);
        this.addFeature("sproutsPerChunk", 0);
        this.addFeature("tinyCactiPerChunk", 0);
        this.addFeature("oasesPerChunk", 0);
        this.addFeature("minersDelightPerChunk", 2);
        this.addFeature("rootsPerChunk", 9);
        this.addFeature("grassSplatterPerChunk", 0);
        this.addFeature("rockpilesPerChunk", 0);
        this.addFeature("logsPerChunk", 0);
        this.addFeature("lavaSpoutsPerChunk", 0);
        this.addFeature("cobwebsPerChunk", 0);
        this.addFeature("cobwebNestsPerChunk", 0);
        this.addFeature("wasteland1PerChunk", 0);
        this.addFeature("wasteland2PerChunk", 0);
        this.addFeature("wasteland3PerChunk", 0);
        this.addFeature("wasteland4PerChunk", 0);
        this.addFeature("wastelandRockPilesPerChunk", 0);
        this.addFeature("bopFlowersPerChunk", 0);
        this.addFeature("bopGrassPerChunk", 0);
    }

    private <T> void setFeature(String name, T value, boolean initialize) {
        if (!initialize && !this.featureValueMap.containsKey(name)) {
            throw new NoSuchFeatureException(name);
        }
        this.featureValueMap.put(name, value);
    }

    public <T> void setFeature(String name, T value) {
        this.setFeature(name, value, false);
    }

    protected <T> void addFeature(String name, T value) {
        this.setFeature(name, value, true);
    }

    public Object getFeature(String name) {
        return this.featureValueMap.get(name);
    }

    public Set<String> getFeatureNames() {
        return this.featureValueMap.keySet();
    }

    static {
        WorldGenFieldAssociation.init();
    }

    public class NoSuchFeatureException
    extends RuntimeException {
        public NoSuchFeatureException(String name) {
            super("Feature " + name + " does not exist!");
        }
    }
}

