/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.gels.entity;

import cpw.mods.fml.common.registry.EntityRegistry;
import net.lomeli.gels.GelsPlus;
import net.lomeli.gels.block.BlockGel;
import net.lomeli.gels.block.ModBlocks;
import net.lomeli.gels.block.TileGel;
import net.lomeli.gels.core.GelRegistry;
import net.lomeli.gels.item.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityGelThrowable
extends EntityThrowable {
    public static ItemStack blockCheck = new ItemStack(Blocks.field_150348_b);
    protected int gelBlock;

    public static void init() {
        if (GelsPlus.allowThrowable) {
            EntityRegistry.registerModEntity(EntityGelThrowable.class, (String)"gel", (int)EntityRegistry.findGlobalUniqueEntityId(), (Object)GelsPlus.instance, (int)64, (int)1, (boolean)true);
        }
    }

    public EntityGelThrowable(World world) {
        super(world);
    }

    public EntityGelThrowable(World world, int gel) {
        super(world);
        this.gelBlock = gel;
        this.setSyncBlock();
    }

    public EntityGelThrowable(World world, EntityLivingBase entity, int gel) {
        super(world, entity);
        this.gelBlock = gel;
        this.setSyncBlock();
    }

    public EntityGelThrowable(World world, double x, double y, double z, int gel) {
        super(world, x, y, z);
        this.gelBlock = gel;
        this.setSyncBlock();
    }

    public EntityGelThrowable(World world, int gel, float velocity) {
        this(world, gel);
        this.gelBlock = gel;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityGelThrowable(World world, double x, double y, double z, int gel, float velocity) {
        this(world, x, y, z, gel);
        this.gelBlock = gel;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void setSyncBlock() {
        this.field_70180_af.func_75692_b(16, (Object)this.gelBlock);
    }

    public int getSyncBlock() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K && this.gelBlock > -1) {
            this.gelBlock = this.getSyncBlock();
        }
        super.func_70030_z();
    }

    protected void func_70184_a(MovingObjectPosition pos) {
        int meta = 0;
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        if (pos.field_72308_g != null) {
            x = (int)pos.field_72308_g.field_70165_t;
            y = (int)pos.field_72308_g.field_70163_u + 1;
            z = (int)pos.field_72308_g.field_70161_v;
            if (this.gelBlock > -1) {
                boolean doEffect = true;
                if (pos.field_72308_g instanceof EntityPlayer) {
                    boolean bl = doEffect = !((EntityPlayer)pos.field_72308_g).func_70093_af();
                }
                if (this.gelBlock < GelRegistry.getInstance().getRegistry().size()) {
                    GelRegistry.getInstance().getGel(this.gelBlock).gelThrownEffect(this.field_70170_p, x, y, z, pos.field_72308_g, doEffect);
                }
            }
        }
        if (!this.field_70170_p.func_147439_a(x, y, z).func_149739_a().equals(Blocks.field_150433_aE.func_149739_a()) || !this.field_70170_p.func_147439_a(x, y, z).func_149739_a().equals(Blocks.field_150431_aC.func_149739_a())) {
            switch (pos.field_72310_e) {
                case 0: {
                    --y;
                    meta = 1;
                    break;
                }
                case 1: {
                    ++y;
                    meta = 0;
                    break;
                }
                case 2: {
                    --z;
                    meta = 5;
                    break;
                }
                case 3: {
                    ++z;
                    meta = 4;
                    break;
                }
                case 4: {
                    --x;
                    meta = 3;
                    break;
                }
                case 5: {
                    ++x;
                    meta = 2;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_82247_a(x, y, z, pos.field_72310_e, blockCheck)) {
                EntityGelThrowable.dropItemStackIntoWorld(new ItemStack(ModItems.gelBlob, 1, this.gelBlock), this.field_70170_p, x, y, z, true);
                this.func_70106_y();
                return;
            }
            if (this.field_70170_p.func_147437_c(x, y, z) && BlockGel.canGelStay(this.field_70170_p, x, y, z, meta)) {
                if (this.gelBlock > -1) {
                    this.field_70170_p.func_147465_d(x, y, z, ModBlocks.gel, this.gelBlock, 3);
                    TileGel tile = (TileGel)this.field_70170_p.func_147438_o(x, y, z);
                    if (tile != null) {
                        tile.setSide(meta);
                    }
                    this.field_70170_p.func_147471_g(x, y, z);
                }
            } else {
                EntityGelThrowable.dropItemStackIntoWorld(new ItemStack(ModItems.gelBlob, 1, this.gelBlock), this.field_70170_p, x, y, z, true);
            }
        }
        this.func_70106_y();
    }

    public static void dropItemStackIntoWorld(ItemStack stack, World world, double x, double y, double z, boolean velocity) {
        if (stack != null) {
            float x2 = 0.5f;
            float y2 = 0.0f;
            float z2 = 0.5f;
            if (velocity) {
                x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            }
            EntityItem entity = new EntityItem(world, x + (double)x2, y + (double)y2, z + (double)z2, stack.func_77946_l());
            if (velocity) {
                entity.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                entity.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                entity.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
            } else {
                entity.field_70181_x = -0.0500000007450581;
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
            }
            world.func_72838_d((Entity)entity);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.gelBlock = nbt.func_74762_e("gelBlock");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.gelBlock > -1) {
            nbt.func_74768_a("gelBlock", this.gelBlock);
        }
    }
}

