/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.gui.GuiBiblioTextField;
import jds.bibliocraft.gui.GuiButtonClipboard;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class GuiMapWaypoint
extends GuiScreen {
    private int guiImageWidth = 256;
    private int guiImageHeight = 128;
    private GuiBiblioTextField textField;
    private String text = " ";
    private int colorState = 1;
    private float xLoc;
    private float yLoc;
    private int xcoord;
    private int ycoord;
    private int zcoord;
    private boolean editing = false;
    private int waypointNumber;
    private String wayPointName = " ";
    private GuiButton buttonAccept;
    private GuiButton buttonCancel;
    private GuiButton buttonRemove;
    TileEntityMapFrame mapFrame;

    public GuiMapWaypoint(World world, EntityPlayer player, float xPin, float yPin, TileEntityMapFrame tile, int pinPoint) {
        this.xLoc = xPin;
        this.yLoc = yPin;
        this.mapFrame = tile;
        this.xcoord = tile.field_145851_c;
        this.ycoord = tile.field_145848_d;
        this.zcoord = tile.field_145849_e;
        if (pinPoint == -1) {
            this.editing = false;
            this.waypointNumber = this.mapFrame.getPinXCoords().size() + 1;
            this.wayPointName = StatCollector.func_74838_a((String)"gui.mapWaypoint.waypoint") + " " + this.waypointNumber;
        } else {
            this.editing = true;
            this.waypointNumber = pinPoint;
            if (this.mapFrame.getPinNames().size() > 0) {
                System.out.println("attempting to get waypoint name");
                this.wayPointName = (String)this.mapFrame.getPinNames().get(this.waypointNumber);
                System.out.println(this.wayPointName);
            }
            if (this.mapFrame.getPinColors().size() > 0) {
                float cs = ((Float)this.mapFrame.getPinColors().get(this.waypointNumber)).floatValue();
                this.colorState = (int)cs;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.field_146292_n.add(new GuiButtonClipboard(0, widthRender + 120, heightRender + 58, 16, 16, "", true));
        this.buttonAccept = new GuiButton(1, widthRender + 166, heightRender + 56, 52, 20, StatCollector.func_74838_a((String)"gui.mapWaypoint.accept"));
        this.field_146292_n.add(this.buttonAccept);
        if (this.editing) {
            this.buttonRemove = new GuiButton(3, widthRender + 38, heightRender + 56, 52, 20, StatCollector.func_74838_a((String)"gui.mapWaypoint.remove"));
            this.field_146292_n.add(this.buttonRemove);
        } else {
            this.buttonCancel = new GuiButton(2, widthRender + 38, heightRender + 56, 52, 20, StatCollector.func_74838_a((String)"gui.mapWaypoint.cancel"));
            this.field_146292_n.add(this.buttonCancel);
        }
        this.textField = new GuiBiblioTextField(this.field_146289_q, widthRender + 17, heightRender + 34, 222, 12);
        this.textField.setEnableBackgroundDrawing(false);
        this.textField.setTextColor(0x404040);
        this.textField.setMaxStringLength(42);
        this.textField.setText(this.wayPointName);
    }

    public void func_73863_a(int x, int y, float f) {
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.MAPPINGUI);
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.func_73729_b(widthRender, heightRender, 0, 0, this.guiImageWidth, this.guiImageHeight);
        this.textField.drawTextBox();
        super.func_73863_a(x, y, f);
        switch (this.colorState) {
            case 0: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BLACKWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 1: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.REDWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 2: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.GREENWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 3: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.LIMEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 4: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BROWNWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 5: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BLUEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 6: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.CYANWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 7: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.LBLUEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 8: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.PURPLEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 9: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.MAGENTAWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 10: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.PINKWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 11: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.YELOOWWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 12: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.ORANGEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 13: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.GRAYWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 14: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.LGRAYWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
            case 15: {
                this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.WHITEWOOL);
                this.func_73729_b(widthRender + 120, heightRender + 58, 0, 0, 16, 16);
                break;
            }
        }
    }

    public void increaseColor() {
        this.colorState = this.colorState >= 15 ? 0 : ++this.colorState;
    }

    public void decreaseColor() {
        this.colorState = this.colorState <= 0 ? 15 : --this.colorState;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton click) {
        if (click.field_146127_k == 0) {
            this.increaseColor();
        }
        if (click.field_146127_k == 1) {
            this.sendPacket(false);
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        if (click.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        if (click.field_146127_k == 3) {
            this.sendPacket(true);
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
    }

    public void sendPacket(boolean removePin) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            buffer.writeInt(this.xcoord);
            buffer.writeInt(this.ycoord);
            buffer.writeInt(this.zcoord);
            buffer.writeFloat(this.xLoc);
            buffer.writeFloat(this.yLoc);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.textField.getText());
            buffer.writeInt(this.colorState);
            buffer.writeInt(this.waypointNumber);
            buffer.writeBoolean(removePin);
            buffer.writeBoolean(this.editing);
            BiblioCraft.ch_BiblioMapPin.sendToServer(new FMLProxyPacket(buffer, "BiblioMapPin"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void func_146281_b() {
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.textField.mouseClicked(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) {
        if (!this.textField.textboxKeyTyped(par1, par2)) {
            super.func_73869_a(par1, par2);
        }
    }

    private void updateButtons() {
    }
}

