/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky;

import java.util.ArrayList;
import java.util.Random;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import mod.lucky.LuckyFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ExpressionParser {
    private final ScriptEngine expressionParser;
    private final Random random;
    private final LuckyFunction luckyFunction;
    public EntityPlayer player;
    public World world;
    public int harvestX;
    public int harvestY;
    public int harvestZ;

    public ExpressionParser() {
        ScriptEngineManager mgr = new ScriptEngineManager(null);
        this.expressionParser = mgr.getEngineByName("JavaScript");
        this.luckyFunction = new LuckyFunction();
        this.random = new Random();
    }

    private String getFormattedString(String value) throws ExpressionParserException {
        if (value.contains("random-") || value.contains("randomPositiveOrNegative-")) {
            value = this.replaceRandoms(value);
        }
        value = value.replaceAll("#randomPotionDamage", String.valueOf(this.luckyFunction.getRandomPotionDamage()));
        value = value.replaceAll("#randomPotionEffect", String.valueOf(this.luckyFunction.getRandomPotionEffect()));
        value = value.replaceAll("#randomSpawnEggDamage", String.valueOf(this.luckyFunction.getRandomMobEgg()));
        value = value.replaceAll("#bPosX", String.valueOf(this.harvestX));
        value = value.replaceAll("#bPosY", String.valueOf(this.harvestY));
        value = value.replaceAll("#bPosZ", String.valueOf(this.harvestZ));
        value = value.replaceAll("#pPosX", String.valueOf(MathHelper.func_76128_c((double)this.player.field_70165_t)));
        value = value.replaceAll("#pPosY", String.valueOf(MathHelper.func_76128_c((double)this.player.field_70163_u)));
        value = value.replaceAll("#pPosZ", String.valueOf(MathHelper.func_76128_c((double)this.player.field_70161_v)));
        value = value.replaceAll("'#'", "'\u00a7'");
        value = value.replaceAll("#", "\u00a7");
        value = value.replaceAll("'\u00a7'", "#");
        return value;
    }

    private String getNewLines(String value) {
        value = value.replaceAll("\\\\t", "\t");
        value = value.replaceAll("\\\\b", "\b");
        value = value.replaceAll("\\\\n", "\n");
        value = value.replaceAll("\\\\r", "\r");
        value = value.replaceAll("\\\\f", "\f");
        return value;
    }

    public String replaceRandoms(String value) throws ExpressionParserException {
        ArrayList<Integer> points = new ArrayList<Integer>();
        int count = 0;
        while (true) {
            boolean randomType;
            int random2Point;
            int random1Point;
            if ((random1Point = value.indexOf("#random-", count == 0 ? 0 : (Integer)points.get(count - 1) + 1)) < (random2Point = value.indexOf("#randomPositiveOrNegative-", count == 0 ? 0 : (Integer)points.get(count - 1) + 1)) && random1Point != -1 || random2Point == -1 && random1Point > -1) {
                randomType = false;
                points.add(count, random1Point);
            } else {
                if ((random2Point >= random1Point || random2Point == -1) && (random1Point != -1 || random2Point <= -1)) break;
                randomType = true;
                points.add(count, random2Point);
            }
            char[] invalidChars = new char[]{' ', '+', '*', '(', ')', ',', ';', '/'};
            int currEndPoint = this.getEndPoint(value, (Integer)points.get(count), invalidChars);
            String currRandom = value.substring((Integer)points.get(count), currEndPoint);
            String[] splitValue = currRandom.split("-");
            int min = this.getInteger(splitValue[1]);
            int max = this.getInteger(splitValue[2]);
            int num = 0;
            if (!randomType) {
                num = this.random.nextInt(max - min + 1) + min;
            } else if (randomType) {
                num = this.random.nextInt(max - min + 1) + min;
                if (this.random.nextInt(2) == 0) {
                    num *= -1;
                }
            }
            String valuePart1 = value.substring(0, (Integer)points.get(count));
            String valuePart2 = value.substring(currEndPoint, value.length());
            value = valuePart1 + "" + num + "" + valuePart2;
            ++count;
        }
        return value;
    }

    private int getEndPoint(String value, int startPoint, char[] invalidChars) {
        char[] chars = value.toCharArray();
        int endPoint = chars.length;
        for (int a = startPoint; a < chars.length; ++a) {
            boolean shouldBreak = false;
            for (char invalidChar : invalidChars) {
                if (chars[a] != invalidChar) continue;
                endPoint = a;
                shouldBreak = true;
                break;
            }
            if (shouldBreak) break;
        }
        return endPoint;
    }

    public String getString(String value) {
        try {
            value = this.getFormattedString(value);
            Object obj = this.expressionParser.eval(value);
            if (obj instanceof String) {
                String s = (String)obj;
                return this.getNewLines(s);
            }
            if (obj instanceof Double && String.valueOf(obj).endsWith(".0")) {
                String s = String.valueOf(obj);
                int i = this.getInteger(s);
                return this.getNewLines(String.valueOf(i));
            }
            return this.getNewLines(String.valueOf(obj));
        }
        catch (Exception e) {
            return value;
        }
    }

    public boolean getBoolean(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.expressionParser.eval(value);
            if (obj instanceof Boolean) {
                boolean b = (Boolean)obj;
                return b;
            }
            throw new ExpressionParserException(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value);
        }
    }

    public int getInteger(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.expressionParser.eval(value);
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Double) {
                double d = (Double)obj;
                return (int)d;
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return (int)f;
            }
            throw new ExpressionParserException(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value);
        }
    }

    public double getDouble(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.expressionParser.eval(value);
            if (obj instanceof Double) {
                double d = (Double)obj;
                return d;
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return f;
            }
            throw new ExpressionParserException(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value);
        }
    }

    public float getFloat(String value) throws ExpressionParserException {
        value = this.getFormattedString(value);
        try {
            Object obj = this.expressionParser.eval(value);
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return f;
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return i;
            }
            if (obj instanceof Double) {
                double d = (Double)obj;
                return (float)d;
            }
            throw new ExpressionParserException(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value);
        }
    }

    public short getShort(String value) throws ExpressionParserException {
        try {
            return (short)this.getInteger(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value);
        }
    }

    public byte getByte(String value) throws ExpressionParserException {
        try {
            return (byte)this.getInteger(value);
        }
        catch (Exception e) {
            throw new ExpressionParserException(value);
        }
    }

    public class ExpressionParserException
    extends Exception {
        public ExpressionParserException(String value) {
            super("Invalid input string: " + value);
        }

        public ExpressionParserException() {
        }
    }
}

