/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import mod.lucky.Lucky;
import net.minecraft.item.Item;

public class LuckyConfiguration {
    public static String getConfigVersion() {
        File file = new File("config/lucky/LuckyBlockProperties.txt");
        if (!file.exists()) {
            return "";
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/LuckyBlockProperties.txt")));
            String version = br.readLine();
            br.close();
            if (version != null) {
                return version;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void readConfig() {
        try {
            String currLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/LuckyBlockProperties.txt")));
            String id = "";
            String section = "";
            boolean addSeparator = false;
            ArrayList<String> drops = new ArrayList<String>();
            int dropNum = 0;
            while ((currLine = br.readLine()) != null) {
                if (currLine.startsWith(">")) {
                    section = currLine;
                    continue;
                }
                if (currLine.startsWith("/") || currLine.equals("")) continue;
                if (section.equals(">spawnrate")) {
                    Lucky.instance.spawnrate = Integer.valueOf(currLine);
                }
                if (section.equals(">recipe")) {
                    Lucky.instance.recipe = currLine;
                }
                if (!section.equals(">drops")) continue;
                boolean newLine = true;
                if (currLine.endsWith(">")) {
                    currLine = currLine.substring(0, currLine.length() - 1);
                    newLine = false;
                }
                if (drops.size() - 1 < dropNum) {
                    drops.add(dropNum, currLine);
                } else {
                    drops.set(dropNum, (String)drops.get(dropNum) + currLine);
                }
                if (!newLine) continue;
                ++dropNum;
            }
            br.close();
            Lucky.instance.allDrops = drops.toArray(new String[drops.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createNewConfigFile() {
        try {
            String currLine;
            File destFile = new File("config/lucky/LuckyBlockProperties.txt");
            destFile.getParentFile().mkdirs();
            destFile.createNewFile();
            BufferedReader br = new BufferedReader(new InputStreamReader(Lucky.class.getResourceAsStream("files/LuckyBlockProperties.txt")));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("config/lucky/LuckyBlockProperties.txt")));
            boolean firstLine = true;
            while ((currLine = br.readLine()) != null) {
                if (!firstLine) {
                    bw.newLine();
                }
                firstLine = false;
                bw.write(currLine);
            }
            br.close();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fixIds(String drop) {
        int[] point = new int[10];
        String[] idWholeString = new String[10];
        String[] idWholeStringNew = new String[10];
        int amountOfIds = 0;
        for (int b = 0; b < 10; ++b) {
            point[b] = drop.indexOf("ID=", b == 0 ? 0 : point[b - 1] + 1);
            if (point[b] == -1) break;
            int endPoint = -1;
            int currEndPoint = drop.indexOf(44, point[b]);
            if (currEndPoint != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.indexOf(59, point[b])) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.indexOf(41, point[b])) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.length()) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            idWholeString[b] = drop.substring(point[b], endPoint);
            try {
                int idInt = Integer.valueOf(idWholeString[b].split("=")[1]);
                String idName = Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)idInt)).split(":")[1];
                idWholeStringNew[b] = "ID=" + idName;
            }
            catch (Exception e) {
                idWholeStringNew[b] = idWholeString[b];
            }
            ++amountOfIds;
        }
        String newDrop = drop;
        for (int b = 0; b < amountOfIds; ++b) {
            newDrop = newDrop.replaceAll(idWholeString[b], idWholeStringNew[b]);
        }
        newDrop = newDrop.replaceAll("name", "ID");
        System.out.println(newDrop);
    }
}

