/*
 * Decompiled with CFR 0.152.
 */
package com.pauljoda.modularfurnace.tileentity;

import com.pauljoda.modularfurnace.blocks.BlockFurnaceCoreSmeltery;
import com.pauljoda.modularfurnace.blocks.BlockManager;
import com.pauljoda.modularfurnace.lib.ModularFurnacesSmelteryRecipies;
import com.pauljoda.modularfurnace.tileentity.TileEntityFurnaceDummySmeltery;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityFurnaceCoreSmeltery
extends TileEntity
implements ISidedInventory {
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1, 3};
    private static final int[] slots_sides = new int[]{1};
    private static final int[] slots_output_only = new int[]{2, 3};
    private ItemStack[] furnaceItems = new ItemStack[5];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    private String field_94130_e;
    int direction;
    private boolean isValidMultiblock = false;
    Random r = new Random();

    public boolean getIsValid() {
        return this.isValidMultiblock;
    }

    public void invalidateMultiblock() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 2);
        this.revertDummies();
        this.direction = 0;
        this.isValidMultiblock = false;
    }

    public boolean checkIfProperlyFormed() {
        int dir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int depthMultiplier = dir == 2 || dir == 4 ? 1 : -1;
        boolean forwardZ = dir == 2 || dir == 3;
        for (int horiz = -1; horiz <= 1; ++horiz) {
            for (int vert = -1; vert <= 1; ++vert) {
                for (int depth = 0; depth <= 2; ++depth) {
                    int x = this.field_145851_c + (forwardZ ? horiz : depth * depthMultiplier);
                    int y = this.field_145848_d + vert;
                    int z = this.field_145849_e + (forwardZ ? depth * depthMultiplier : horiz);
                    Block blockId = this.field_145850_b.func_147439_a(x, y, z);
                    if (horiz == 0 && vert == 0) {
                        if (depth == 0) continue;
                        if (depth == 1 && blockId != BlockManager.lavaCore) {
                            return false;
                        }
                    }
                    if (blockId == Blocks.field_150350_a) {
                        return false;
                    }
                    if (blockId == BlockManager.furnaceSmelteryBrick || blockId == BlockManager.furnaceDummySmeltery || blockId == BlockManager.lavaCore) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void convertDummies() {
        int dir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int depthMultiplier = dir == 2 || dir == 4 ? 1 : -1;
        boolean forwardZ = dir == 2 || dir == 3;
        for (int horiz = -1; horiz <= 1; ++horiz) {
            for (int vert = -1; vert <= 1; ++vert) {
                for (int depth = 0; depth <= 2; ++depth) {
                    int x = this.field_145851_c + (forwardZ ? horiz : depth * depthMultiplier);
                    int y = this.field_145848_d + vert;
                    int z = this.field_145849_e + (forwardZ ? depth * depthMultiplier : horiz);
                    if (horiz == 0 && vert == 0 && depth == 1 || horiz == 0 && vert == 0 && depth == 0 || this.field_145850_b.func_147439_a(x, y, z) != BlockManager.furnaceSmelteryBrick) continue;
                    this.field_145850_b.func_147449_b(x, y, z, BlockManager.furnaceDummySmeltery);
                    this.field_145850_b.func_147471_g(x, y, z);
                    TileEntityFurnaceDummySmeltery dummy = (TileEntityFurnaceDummySmeltery)this.field_145850_b.func_147438_o(x, y, z);
                    dummy.setCore(this);
                }
            }
            this.isValidMultiblock = true;
        }
    }

    private void revertDummies() {
        int dir = this.direction;
        int depthMultiplier = dir == 2 || dir == 4 ? 1 : -1;
        boolean forwardZ = dir == 2 || dir == 3;
        for (int horiz = -1; horiz <= 1; ++horiz) {
            for (int vert = -1; vert <= 1; ++vert) {
                for (int depth = 0; depth <= 2; ++depth) {
                    int x = this.field_145851_c + (forwardZ ? horiz : depth * depthMultiplier);
                    int y = this.field_145848_d + vert;
                    int z = this.field_145849_e + (forwardZ ? depth * depthMultiplier : horiz);
                    Block blockId = this.field_145850_b.func_147439_a(x, y, z);
                    if (horiz == 0 && vert == 0 && (depth == 0 || depth == 1)) continue;
                    if (blockId == BlockManager.furnaceDummySmeltery) {
                        this.field_145850_b.func_147449_b(x, y, z, BlockManager.furnaceSmelteryBrick);
                        this.field_145850_b.func_147471_g(x, y, z);
                        continue;
                    }
                    this.field_145850_b.func_147471_g(x, y, z);
                }
            }
        }
        this.isValidMultiblock = false;
    }

    public void func_145845_h() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnaceCoreSmeltery.getItemBurnTime(this.furnaceItems[1]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.furnaceItems[1] != null) {
                        --this.furnaceItems[1].field_77994_a;
                        if (this.furnaceItems[1].field_77994_a == 0) {
                            this.furnaceItems[1] = this.furnaceItems[1].func_77973_b().getContainerItem(this.furnaceItems[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 200) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockFurnaceCoreSmeltery.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int func_70302_i_() {
        return this.furnaceItems.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.furnaceItems[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.furnaceItems[slot] != null) {
            ItemStack itemStack = this.furnaceItems[slot].func_77979_a(count);
            if (this.furnaceItems[slot].field_77994_a <= 0) {
                this.furnaceItems[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.furnaceItems[slot] != null) {
            ItemStack stack = this.furnaceItems[slot];
            this.furnaceItems[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.furnaceItems[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public void setGuiDisplayName(String par1Str) {
        this.field_94130_e = par1Str;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        if (par1 == 2) {
            return false;
        }
        if (par1 == 1 && TileEntityFurnaceCoreSmeltery.isItemFuel(par2ItemStack)) {
            return true;
        }
        return par1 == 0;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityFurnaceCoreSmeltery.getItemBurnTime(par0ItemStack) > 0;
    }

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        Item i = par0ItemStack.func_77973_b();
        if (i == Items.field_151145_ak) {
            return 800;
        }
        return GameRegistry.getFuelValue((ItemStack)par0ItemStack);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        tagCompound.func_74762_e("BlockMeta");
        this.isValidMultiblock = tagCompound.func_74767_n("isValidMultiblock");
        NBTTagList itemsTag = tagCompound.func_150295_c("Items", 10);
        this.furnaceItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = itemsTag.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.furnaceItems.length) continue;
            this.furnaceItems[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = tagCompound.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityFurnaceCoreSmeltery.getItemBurnTime(this.furnaceItems[1]);
        this.direction = tagCompound.func_74762_e("Direction");
        if (tagCompound.func_74764_b("CustomName")) {
            this.field_94130_e = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("isValidMultiblock", this.isValidMultiblock);
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        tagCompound.func_74768_a("Direction", this.direction);
        NBTTagList itemsList = new NBTTagList();
        for (int i = 0; i < this.furnaceItems.length; ++i) {
            if (this.furnaceItems[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.furnaceItems[i].func_77955_b(nbttagcompound1);
            itemsList.func_74742_a((NBTBase)nbttagcompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)itemsList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.field_94130_e);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private boolean canSmelt() {
        if (this.furnaceItems[0] == null) {
            return false;
        }
        int resultingStackSize = 0;
        int resultingStackSize1 = 0;
        ItemStack itemStack = ModularFurnacesSmelteryRecipies.smelting().getSmeltingResult(this.furnaceItems[0]);
        if (itemStack == null) {
            return false;
        }
        if (this.furnaceItems[2] == null && this.furnaceItems[3] == null) {
            return true;
        }
        if (this.furnaceItems[2] != null) {
            resultingStackSize = this.furnaceItems[2].field_77994_a + itemStack.field_77994_a;
            if (this.furnaceItems[3] != null) {
                resultingStackSize1 = this.furnaceItems[3].field_77994_a + itemStack.field_77994_a;
                if (!this.furnaceItems[2].func_77969_a(itemStack) && !this.furnaceItems[3].func_77969_a(itemStack)) {
                    return false;
                }
            }
        }
        return resultingStackSize <= this.func_70297_j_() && resultingStackSize1 <= this.func_70297_j_() && resultingStackSize <= itemStack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = ModularFurnacesSmelteryRecipies.smelting().getSmeltingResult(this.furnaceItems[0]);
            ItemStack itemstack2 = ModularFurnacesSmelteryRecipies.smelting().getSmeltingResult2(this.furnaceItems[0]);
            if (this.furnaceItems[2] == null) {
                this.furnaceItems[2] = itemstack.func_77946_l();
            } else if (this.furnaceItems[2].func_77969_a(itemstack)) {
                this.furnaceItems[2].field_77994_a += itemstack.field_77994_a;
            }
            if (this.furnaceItems[3] == null) {
                this.furnaceItems[3] = itemstack2.func_77946_l();
            } else if (this.furnaceItems[3].func_77969_a(itemstack2)) {
                this.furnaceItems[3].field_77994_a += itemstack2.field_77994_a;
            }
            --this.furnaceItems[0].field_77994_a;
            if (this.furnaceItems[0].field_77994_a <= 0) {
                this.furnaceItems[0] = null;
            }
        }
    }

    public int[] func_94128_d(int par1) {
        switch (par1) {
            case 0: {
                return slots_bottom;
            }
            case 1: {
                return slots_top;
            }
            case 2: {
                return slots_output_only;
            }
        }
        return slots_sides;
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par3 != 0 || par1 != 1 || par2ItemStack.func_77973_b() == Items.field_151133_ar;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return this.field_94130_e != null && this.field_94130_e.length() > 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145951_a(String p_145951_1_) {
        this.field_94130_e = p_145951_1_;
    }
}

