/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.buildingtools;

import com.mrcrayfish.construction.buildingtools.BuildingData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class ConstructionUtil {
    public static HashMap<String, BuildingData> buildingData = new HashMap();

    public static void loadData() {
        File folder = new File("buildings/");
        folder.mkdir();
        File[] listOfFiles = folder.listFiles();
        try {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fileName;
                if (!listOfFiles[i].isFile() || !(fileName = listOfFiles[i].getName()).endsWith(".txt")) continue;
                File file = new File("buildings/" + fileName);
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
                boolean hasWidth = false;
                boolean hasHeight = false;
                int[] data = new int[6];
                int depth = 0;
                int height = -1;
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("offset:")) {
                        String newLine = line.replace("offset:", "");
                        String[] offsetData = newLine.split(":");
                        for (int j = 0; j < 3; ++j) {
                            data[j + 3] = Integer.parseInt(offsetData[j]);
                        }
                    }
                    if (line.startsWith("#")) {
                        ++depth;
                    }
                    if (!line.startsWith("#") && !hasWidth) {
                        String[] blocks = line.split("\\s+");
                        data[0] = blocks.length;
                        hasWidth = true;
                    }
                    if (height == -1 | (!hasHeight && !line.startsWith("#"))) {
                        ++height;
                        continue;
                    }
                    hasHeight = true;
                }
                data[1] = height;
                data[2] = depth;
                buildingData.put(fileName.replace(".txt", ""), new BuildingData(data[0], data[1], data[2], data[3], data[4], data[5]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addData(String buildingName) {
        try {
            File file = new File("buildings/" + buildingName + ".txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
            boolean hasWidth = false;
            boolean hasHeight = false;
            int[] data = new int[6];
            int depth = 0;
            int height = -1;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("offset:")) {
                    String newLine = line.replace("offset:", "");
                    String[] offsetData = newLine.split(":");
                    for (int j = 0; j < 3; ++j) {
                        data[j + 3] = Integer.parseInt(offsetData[j]);
                    }
                } else {
                    for (int j = 0; j < 3; ++j) {
                        data[j + 3] = 0;
                    }
                }
                if (line.startsWith("#")) {
                    ++depth;
                }
                if (!line.startsWith("#") && !hasWidth) {
                    String[] blocks = line.split("\\s+");
                    data[0] = blocks.length;
                    hasWidth = true;
                }
                if (height == -1 | (!hasHeight && !line.startsWith("#"))) {
                    ++height;
                    continue;
                }
                hasHeight = true;
            }
            data[1] = height;
            data[2] = depth;
            buildingData.put(buildingName, new BuildingData(data[0], data[1], data[2], data[3], data[4], data[5]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getWidth(String buildingName) {
        BuildingData data = buildingData.get(buildingName);
        return data.getWidth();
    }

    public static int getHeight(String buildingName) {
        BuildingData data = buildingData.get(buildingName);
        return data.getHeight();
    }

    public static int getDepth(String buildingName) {
        BuildingData data = buildingData.get(buildingName);
        return data.getDepth();
    }

    public static int getOffsetX(String buildingName) {
        BuildingData data = buildingData.get(buildingName);
        return data.getOffsetX();
    }

    public static int getOffsetY(String buildingName) {
        BuildingData data = buildingData.get(buildingName);
        return data.getOffsetY();
    }

    public static int getOffsetZ(String buildingName) {
        BuildingData data = buildingData.get(buildingName);
        return data.getOffsetZ();
    }
}

