/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.buildingtools;

import com.mrcrayfish.construction.buildingtools.BlockData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class MaterialList {
    private static MaterialList materialList = new MaterialList();
    public Map<String, BlockData> materials = new HashMap<String, BlockData>();
    private String[] filteredIDs = new String[]{"bed", "piston_head", "skull", "iron_door", "wooden_door", "double_wooden_slab", "flowing_water", "water", "flowing_lava", "lava", "farmland", "double_stone_slab", "flower_pot"};
    private String[] newIDs = new String[]{"air", "air", "air", "air", "air", "wooden_slab", "air", "air", "air", "air", "dirt", "stone_slab", "air"};

    public static MaterialList instance() {
        return materialList;
    }

    public void loadMaterials() {
        File folder = new File("buildings/");
        folder.mkdir();
        File[] listOfFiles = folder.listFiles();
        try {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fileName;
                if (!listOfFiles[i].isFile() || !(fileName = listOfFiles[i].getName()).endsWith(".txt")) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(listOfFiles[i])));
                String line = null;
                BlockData tuple = new BlockData();
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#") || line.startsWith("offset")) continue;
                    String[] blocks = line.split("\\s+");
                    for (int j = 0; j < blocks.length; ++j) {
                        String[] blockData = blocks[j].split("-");
                        String blockName = blockData[0];
                        int[] data = new int[]{Integer.parseInt(blockData[1]), 1};
                        for (int k = 0; k < this.filteredIDs.length; ++k) {
                            if (!blockName.equals("minecraft:" + this.filteredIDs[k])) continue;
                            blockName = "minecraft:" + this.newIDs[k];
                            break;
                        }
                        tuple.addToMaterialList(blockName, data);
                    }
                }
                this.addMaterials(fileName.replace(".txt", ""), tuple);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadMaterials(String fileName) {
        File folder = new File("buildings/");
        folder.mkdir();
        File file = new File(folder, fileName + ".txt");
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = null;
            BlockData tuple = new BlockData();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("offset")) continue;
                String[] blocks = line.split("\\s+");
                for (int j = 0; j < blocks.length; ++j) {
                    String[] blockData = blocks[j].split("-");
                    String blockName = blockData[0];
                    int[] data = new int[]{Integer.parseInt(blockData[1]), 1};
                    for (int k = 0; k < this.filteredIDs.length; ++k) {
                        if (!blockName.equals("minecraft:" + this.filteredIDs[k])) continue;
                        blockName = "minecraft:" + this.newIDs[k];
                        break;
                    }
                    tuple.addToMaterialList(blockName, data);
                }
            }
            this.addMaterials(fileName.replace(".txt", ""), tuple);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addMaterials(String buildingName, BlockData tuple) {
        this.materials.put(buildingName, tuple);
    }

    public BlockData getMaterials(String buildingName) {
        return this.materials.get(buildingName);
    }
}

