/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.network.packets;

import com.mrcrayfish.construction.buildingtools.Construct;
import com.mrcrayfish.construction.buildingtools.ConstructionManager;
import com.mrcrayfish.construction.network.AbstractPacket;
import com.mrcrayfish.construction.tileentity.TileEntityBuildingBlock;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class PacketBuild
extends AbstractPacket {
    private String buildingName;
    private int x;
    private int y;
    private int z;
    private boolean buildAll = false;

    public PacketBuild() {
    }

    public PacketBuild(String buildingName, int x, int y, int z, boolean buildAll) {
        this.buildingName = buildingName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.buildAll = buildAll;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.buildingName);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.buildAll);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.buildingName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.buildAll = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        int metadata = player.field_70170_p.func_72805_g(this.x, this.y, this.z);
        int stage = 0;
        try {
            TileEntity tile_entity = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
            if (tile_entity instanceof TileEntityBuildingBlock) {
                TileEntityBuildingBlock tileEntityBuildingBlock = (TileEntityBuildingBlock)tile_entity;
                ++tileEntityBuildingBlock.stage;
                tileEntityBuildingBlock.subStage = 0;
                stage = tileEntityBuildingBlock.stage;
                if (this.buildAll) {
                    stage = Construct.getDepth(this.buildingName);
                }
                if (stage >= Construct.getDepth(this.buildingName) - 1) {
                    ItemStack blueprint2;
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + this.buildingName + " Constructed!"));
                    player.field_70170_p.func_72908_a((double)this.x, (double)this.y, (double)this.z, "ccm:hammerhit", 0.75f, 1.0f);
                    player.field_70170_p.func_72908_a((double)this.x, (double)this.y, (double)this.z, "random.levelup", 0.75f, 1.0f);
                    ConstructionManager.getInstance().addLayerToConstruct(player, this.buildingName, this.x, this.y, this.z, metadata, stage, this.buildAll);
                    tileEntityBuildingBlock.stage = 0;
                    tileEntityBuildingBlock.hasStartedBuilding = false;
                    ItemStack blueprint = tileEntityBuildingBlock.blueprintSlot[0];
                    if (blueprint.func_77960_j() != 4) {
                        blueprint.func_77964_b(blueprint.func_77960_j() + 1);
                        tileEntityBuildingBlock.func_70299_a(0, blueprint);
                    }
                    if ((blueprint2 = tileEntityBuildingBlock.blueprintSlot[0]).func_77960_j() == 4) {
                        tileEntityBuildingBlock.func_70299_a(0, null);
                        tileEntityBuildingBlock.resetBOffset();
                    }
                } else {
                    player.field_70170_p.func_72908_a((double)this.x, (double)this.y, (double)this.z, "ccm:hammerhit", 0.75f, 1.0f);
                    player.field_70170_p.func_72908_a((double)this.x, (double)this.y, (double)this.z, "random.orb", 0.75f, 1.0f);
                    player.func_145747_a((IChatComponent)new ChatComponentText("Stage " + EnumChatFormatting.RED + stage + EnumChatFormatting.RESET + " of " + EnumChatFormatting.RED + (Construct.getDepth(this.buildingName) - 1) + EnumChatFormatting.RESET + " Complete!"));
                    ConstructionManager.getInstance().addLayerToConstruct(player, this.buildingName, this.x, this.y, this.z, metadata, stage, this.buildAll);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

