/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.network.packets;

import com.mrcrayfish.construction.network.AbstractPacket;
import com.mrcrayfish.construction.tileentity.TileEntityPlanningBlock;
import com.mrcrayfish.construction.util.NBTHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketDraw
extends AbstractPacket {
    private String buildingName;
    private int x;
    private int y;
    private int z;
    private int price;
    private boolean clearAll;

    public PacketDraw() {
    }

    public PacketDraw(String buildingName, int x, int y, int z, int option, boolean clearAll) {
        this.buildingName = buildingName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.price = option;
        this.clearAll = clearAll;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.buildingName);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.price);
        buffer.writeBoolean(this.clearAll);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.buildingName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.price = buffer.readInt();
        this.clearAll = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        TileEntity tile_entity = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (tile_entity instanceof TileEntityPlanningBlock) {
            TileEntityPlanningBlock tileEntityPlanningBlock = (TileEntityPlanningBlock)tile_entity;
            ItemStack item = tileEntityPlanningBlock.func_70301_a(0);
            NBTHelper.setString(item, "buildingType", this.buildingName);
            item.func_77964_b(0);
            tileEntityPlanningBlock.setContents(0, item);
            if (this.clearAll) {
                tileEntityPlanningBlock.clearMoneySlot();
            } else {
                tileEntityPlanningBlock.takeMoneyFromSlot(this.price);
            }
        }
        player.field_70170_p.func_147471_g(this.x, this.y, this.z);
    }
}

