/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.network.packets;

import com.mrcrayfish.construction.network.AbstractPacket;
import com.mrcrayfish.construction.util.NBTHelper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class PacketPencilSelect
extends AbstractPacket {
    private int x;
    private int y;
    private int z;

    public PacketPencilSelect() {
    }

    public PacketPencilSelect(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != null) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (!NBTHelper.getBoolean(currentItem, "corner1") | NBTHelper.getBoolean(currentItem, "both")) {
                NBTHelper.setInteger(currentItem, "x1", this.x);
                NBTHelper.setInteger(currentItem, "y1", this.y);
                NBTHelper.setInteger(currentItem, "z1", this.z);
                NBTHelper.setBoolean(currentItem, "corner1", true);
                NBTHelper.setBoolean(currentItem, "corner2", false);
                NBTHelper.setBoolean(currentItem, "both", false);
                player.func_70062_b(0, currentItem);
            } else if (!NBTHelper.getBoolean(currentItem, "corner2")) {
                NBTHelper.setInteger(currentItem, "x2", this.x);
                NBTHelper.setInteger(currentItem, "y2", this.y);
                NBTHelper.setInteger(currentItem, "z2", this.z);
                NBTHelper.setBoolean(currentItem, "corner2", true);
                NBTHelper.setBoolean(currentItem, "both", true);
                player.func_70062_b(0, currentItem);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "You can now save the selection by holding Shift and pressing Right Click."));
            }
        }
    }
}

