/*
 * Decompiled with CFR 0.152.
 */
package ghostmod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import ghostmod.CommonProxy;
import ghostmod.entity.EntityGhost;
import ghostmod.event.EventSpawnGhost;
import ghostmod.item.ItemGhostDust;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="ghostmod", name="Ghost Mod", version="ghostmod")
public class GhostMod {
    public static final String MODID = "ghostmod";
    public static final String VERSION = "???";
    @Mod.Instance(value="ghostmod")
    public static GhostMod instance;
    @SidedProxy(clientSide="ghostmod.ClientProxy", serverSide="ghostmod.CommonProxy")
    public static CommonProxy proxyGhost;
    public static Item.ToolMaterial materialGhost;
    public static int ghostDustID;
    public static int ghostIngotID;
    public static int ghostSwordHandleID;
    public static int ghostSwordID;
    public static Item ghostDust;
    public static Item ghostIngot;
    public static Item ghostSwordHandle;
    public static Item ghostSword;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ghostDustID = config.get("general", "Ghost Dust ID", 5000).getInt();
        ghostIngotID = config.get("general", "Ghost Dust ID", 5001).getInt();
        ghostSwordHandleID = config.get("general", "Ghost Sword Handle ID", 5002).getInt();
        ghostSwordID = config.get("general", "Ghost Sword ID", 5003).getInt();
        config.save();
        ghostDust = new ItemGhostDust().func_77637_a(CreativeTabs.field_78035_l).func_77655_b("ghost_dust").func_111206_d(MODID + ":ghost_dust");
        ghostIngot = new Item().func_77637_a(CreativeTabs.field_78035_l).func_77655_b("ghost_ingot").func_111206_d(MODID + ":ghost_ingot");
        ghostSwordHandle = new Item().func_77637_a(CreativeTabs.field_78026_f).func_77655_b("ghost_sword_handle").func_111206_d(MODID + ":ghost_sword_handle");
        ghostSword = new ItemSword(materialGhost).func_77637_a(CreativeTabs.field_78037_j).func_77655_b("ghost_sword").func_111206_d(MODID + ":ghost_sword");
        this.registerObjects();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.addEvents();
        proxyGhost.registerRenderers();
        this.addEntities();
        this.addRecipes();
    }

    public void addEntities() {
        int ghostID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityGhost.class, (String)"ghost", (int)ghostID);
        EntityRegistry.registerModEntity(EntityGhost.class, (String)"ghost", (int)ghostID, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.addSpawn(EntityGhost.class, (int)5, (int)5, (int)7, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76772_c, BiomeGenBase.field_150585_R, BiomeGenBase.field_76767_f, BiomeGenBase.field_150583_P, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_76770_e, BiomeGenBase.field_76785_t, BiomeGenBase.field_150578_U, BiomeGenBase.field_150581_V, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u, BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T, BiomeGenBase.field_76780_h});
        EntityList.field_75627_a.put(ghostID, new EntityList.EntityEggInfo(ghostID, 0xF9F9F9, 0xBCBCBC));
    }

    public void registerObjects() {
        GameRegistry.registerItem((Item)ghostDust, (String)"ghost_dust");
        GameRegistry.registerItem((Item)ghostIngot, (String)"ghost_ingot");
        GameRegistry.registerItem((Item)ghostSwordHandle, (String)"ghost_sword_handle");
        GameRegistry.registerItem((Item)ghostSword, (String)"ghost_sword");
    }

    public void addRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(ghostIngot, 1), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ghostDust});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ghostSwordHandle, 1), (Object[])new Object[]{"XO", "SX", Character.valueOf('X'), ghostDust, Character.valueOf('O'), Items.field_151079_bi, Character.valueOf('S'), Items.field_151055_y});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ghostSword, 1), (Object[])new Object[]{" X ", " X ", " H ", Character.valueOf('X'), ghostIngot, Character.valueOf('H'), ghostSwordHandle});
    }

    public void addEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new EventSpawnGhost());
    }

    static {
        materialGhost = EnumHelper.addToolMaterial((String)"GHOST", (int)3, (int)1000, (float)5.0f, (float)5.0f, (int)30);
    }
}

