/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Function {
    public static boolean setBlock(World world, int x, int y, int z, Block block, int metadata, boolean notify) {
        int update = notify ? 3 : 0;
        return world.func_147465_d(x, y, z, block, metadata, update);
    }

    public static boolean setMeta(World world, int x, int y, int z, int metadata, boolean notify) {
        int update = notify ? 3 : 0;
        return world.func_72921_c(x, y, z, metadata, update);
    }

    public static void removeBlock(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        world.func_147475_p(x, y, z);
    }

    public static int getFace(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return -1;
    }

    public static void syncTile(TileEntity tile) {
        tile.func_145831_w().func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        tile.func_145831_w().func_147476_b(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile);
    }

    public static int[] getBlockXZ(double posX, double posZ) {
        int blockX = (int)posX;
        int blockZ = (int)posZ;
        if (posX - (double)((int)posX) < 0.0) {
            --blockX;
        }
        if (posZ - (double)((int)posZ) < 0.0) {
            // empty if block
        }
        return new int[]{blockX, --blockZ};
    }

    public static void giveItem(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (!entityPlayer.field_71071_by.func_70441_a(itemStack)) {
            Function.dropItem(entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v, itemStack);
        }
    }

    public static void dropItem(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack != null) {
            double rndX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityItem = new EntityItem(world, (double)x + rndX, (double)y + rndY, (double)z + rndZ, itemStack);
            entityItem.field_145804_b = 10;
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static MovingObjectPosition fakeMOP(World world, int x, int y, int z, int side) {
        Vec3 vec3 = Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
        return new MovingObjectPosition(x, y, z, side, vec3);
    }

    public static Entity getEntityInFront(World theWorld, EntityPlayer thePlayer, double distance) {
        EntityLiving theTarget = null;
        List entityList = thePlayer.field_70170_p.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)thePlayer.field_70165_t, (double)thePlayer.field_70163_u, (double)thePlayer.field_70161_v, (double)(thePlayer.field_70165_t + 1.0), (double)(thePlayer.field_70163_u + 1.0), (double)(thePlayer.field_70161_v + 1.0)).func_72314_b(distance, distance, distance));
        if (entityList.isEmpty()) {
            return null;
        }
        for (int count = 0; count < entityList.size(); ++count) {
            EntityLiving entityLiving = (EntityLiving)entityList.get(count);
            Vec3 vec3d = thePlayer.func_70676_i(1.0f).func_72432_b();
            Vec3 vec3d1 = Vec3.func_72443_a((double)(entityLiving.field_70165_t - thePlayer.field_70165_t), (double)(entityLiving.field_70121_D.field_72338_b + (double)(entityLiving.field_70131_O / 2.0f) - (thePlayer.field_70163_u + (double)thePlayer.func_70047_e())), (double)(entityLiving.field_70161_v - thePlayer.field_70161_v));
            double d = vec3d1.func_72433_c();
            double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
            if (!(d1 > 1.0 - 0.025 / d) || !thePlayer.func_70685_l((Entity)entityLiving)) continue;
            theTarget = entityLiving;
        }
        return theTarget;
    }

    public static BlockInfo getBlockInfront(World world, EntityPlayer entityplayer, double reach) {
        MovingObjectPosition mop = Function.getMovingObjectPositionFromPlayer(world, entityplayer, true, reach);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return new BlockInfo(world, mop);
        }
        return null;
    }

    private static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer entityplayer, boolean includeLiquids, double reach) {
        float f = 1.0f;
        float playerPitch = entityplayer.field_70127_C + (entityplayer.field_70125_A - entityplayer.field_70127_C) * f;
        float playerYaw = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * f;
        double playerPosX = entityplayer.field_70169_q + (entityplayer.field_70165_t - entityplayer.field_70169_q) * (double)f;
        double playerPosY = entityplayer.field_70167_r + (entityplayer.field_70163_u - entityplayer.field_70167_r) * (double)f + 1.62 - (double)entityplayer.field_70129_M;
        double playerPosZ = entityplayer.field_70166_s + (entityplayer.field_70161_v - entityplayer.field_70166_s) * (double)f;
        Vec3 vecPlayer = Vec3.func_72443_a((double)playerPosX, (double)playerPosY, (double)playerPosZ);
        float cosYaw = MathHelper.func_76134_b((float)(-playerYaw * 0.01745329f - 3.141593f));
        float sinYaw = MathHelper.func_76126_a((float)(-playerYaw * 0.01745329f - 3.141593f));
        float cosPitch = -MathHelper.func_76134_b((float)(-playerPitch * 0.01745329f));
        float sinPitch = MathHelper.func_76126_a((float)(-playerPitch * 0.01745329f));
        float pointX = sinYaw * cosPitch;
        float pointY = sinPitch;
        float pointZ = cosYaw * cosPitch;
        Vec3 vecPoint = vecPlayer.func_72441_c((double)pointX * reach, (double)pointY * reach, (double)pointZ * reach);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vecPlayer, vecPoint, includeLiquids);
        return movingobjectposition;
    }

    public static class BlockInfo {
        public final Block block;
        public final int metadata;
        public final int x;
        public final int y;
        public final int z;
        public final int face;
        public final int sub;

        public BlockInfo(World world, MovingObjectPosition mop) {
            this.x = mop.field_72311_b;
            this.y = mop.field_72312_c;
            this.z = mop.field_72309_d;
            this.block = world.func_147439_a(this.x, this.y, this.z);
            this.metadata = world.func_72805_g(this.x, this.y, this.z);
            this.face = mop.field_72310_e;
            this.sub = mop.subHit;
        }
    }
}

