/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public class GameData {
    private static Table<String, String, ItemStack> customItemStacks = HashBasedTable.create();
    public static final FMLControlledNamespacedRegistry<Block> blockRegistry = new FMLControlledNamespacedRegistry("air", 4095, 0, Block.class, '\u0001');
    public static final FMLControlledNamespacedRegistry<Item> itemRegistry = new FMLControlledNamespacedRegistry(null, 32000, 4096, Item.class, '\u0002');
    private static Map<GameRegistry.UniqueIdentifier, ModContainer> customOwners = Maps.newHashMap();

    public static Map<String, Integer> buildItemDataList() {
        HashMap idMapping = Maps.newHashMap();
        blockRegistry.serializeInto((Map)idMapping);
        itemRegistry.serializeInto((Map)idMapping);
        return idMapping;
    }

    static Item findItem(String modId, String name) {
        return (Item)itemRegistry.func_82594_a(modId + ":" + name);
    }

    static Block findBlock(String modId, String name) {
        String key = modId + ":" + name;
        return blockRegistry.contains(key) ? (Block)blockRegistry.func_82594_a(key) : null;
    }

    static ItemStack findItemStack(String modId, String name) {
        Block b;
        Item i;
        ItemStack is = (ItemStack)customItemStacks.get((Object)modId, (Object)name);
        if (is == null && (i = GameData.findItem(modId, name)) != null) {
            is = new ItemStack(i, 0, 0);
        }
        if (is == null && (b = GameData.findBlock(modId, name)) != null) {
            is = new ItemStack(b, 0, Short.MAX_VALUE);
        }
        return is;
    }

    static void registerCustomItemStack(String name, ItemStack itemStack, String modId) {
        if (modId == null) {
            modId = Loader.instance().activeModContainer().getModId();
        }
        customItemStacks.put((Object)modId, (Object)name, (Object)itemStack);
    }

    public static void dumpRegistry(File minecraftDir) {
        if (customItemStacks == null) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("fml.dumpRegistry", "false")).booleanValue()) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String modId : customItemStacks.rowKeySet()) {
                builder.putAll((Object)modId, customItemStacks.row((Object)modId).keySet());
            }
            File f = new File(minecraftDir, "itemStackRegistry.csv");
            Joiner.MapJoiner mapJoiner = Joiner.on((String)"\n").withKeyValueSeparator(",");
            try {
                Files.write((CharSequence)mapJoiner.join((Iterable)builder.build().entries()), (File)f, (Charset)Charsets.UTF_8);
                FMLLog.log((Level)Level.INFO, (String)"Dumped item registry data to %s", (Object[])new Object[]{f.getAbsolutePath()});
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Failed to write registry data to %s", (Object[])new Object[]{f.getAbsolutePath()});
            }
        }
    }

    static GameRegistry.UniqueIdentifier getUniqueName(Block block) {
        if (block == null) {
            return null;
        }
        String name = blockRegistry.func_148750_c((Object)block);
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(name);
        if (customItemStacks.contains((Object)ui.modId, (Object)ui.name)) {
            return null;
        }
        return ui;
    }

    static GameRegistry.UniqueIdentifier getUniqueName(Item item) {
        if (item == null) {
            return null;
        }
        String name = itemRegistry.func_148750_c((Object)item);
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(name);
        if (customItemStacks.contains((Object)ui.modId, (Object)ui.name)) {
            return null;
        }
        return ui;
    }

    static void registerBlockAndItem(ItemBlock item, Block block, String name, String modId) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (modId != null) {
            customOwners.put(new GameRegistry.UniqueIdentifier(modId, name), mc);
        }
        BitSet blockAvailability = blockRegistry.slots();
        BitSet itemAvailability = itemRegistry.slots();
        blockAvailability.or(itemAvailability);
        int blockId = blockAvailability.nextClearBit(0);
        if (blockId >= GameData.blockRegistry.maxId) {
            throw new RuntimeException(String.format("No more space for block allocations: used %d block ids", blockId - 1));
        }
        int actualBlockId = blockRegistry.add(blockId, name, (Object)block);
        int itemId = itemRegistry.add(blockId, name, (Object)item);
        if (blockId != actualBlockId || itemId != blockId) {
            throw new RuntimeException(String.format("There was a failure to allocate a matching block and item pair for %s: requested %d, got %d and %d", name, blockId, actualBlockId, itemId));
        }
    }

    static void registerItem(Item item, String name, String modId) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (modId != null) {
            customOwners.put(new GameRegistry.UniqueIdentifier(modId, name), mc);
        }
        if (item instanceof ItemBlock) {
            throw new RuntimeException("Cannot register an itemblock separately from it's block");
        }
        int itemId = itemRegistry.add(0, name, (Object)item);
        blockRegistry.useSlot(itemId);
    }

    static void registerBlock(Block block, String name, String modId) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (modId != null) {
            customOwners.put(new GameRegistry.UniqueIdentifier(modId, name), mc);
        }
        int blockId = blockRegistry.add(0, name, (Object)block);
        itemRegistry.useSlot(blockId);
    }

    public static ModContainer findModOwner(String string) {
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(string);
        if (customOwners.containsKey(ui)) {
            return customOwners.get(ui);
        }
        return (ModContainer)Loader.instance().getIndexedModList().get(ui.modId);
    }

    public static void fixupRegistries() {
        for (Integer id : blockRegistry.usedIds()) {
            itemRegistry.useSlot(id.intValue());
        }
        for (Integer id : itemRegistry.usedIds()) {
            blockRegistry.useSlot(id.intValue());
        }
    }

    public static List<String> injectWorldIDMap(Map<String, Integer> dataList, boolean injectFrozenData, boolean isLocalWorld) {
        HashMap remaps = Maps.newHashMap();
        ArrayListMultimap missing = ArrayListMultimap.create();
        blockRegistry.dump();
        itemRegistry.dump();
        blockRegistry.beginIdSwap();
        itemRegistry.beginIdSwap();
        for (Map.Entry<String, Integer> entry : dataList.entrySet()) {
            String itemName = entry.getKey();
            char discriminator = itemName.charAt(0);
            itemName = itemName.substring(1);
            Integer newId = entry.getValue();
            boolean isBlock = discriminator == '\u0001';
            int currId = isBlock ? blockRegistry.getId(itemName) : itemRegistry.getId(itemName);
            if (currId == -1) {
                FMLLog.info((String)"Found a missing id from the world %s", (Object[])new Object[]{itemName});
                missing.put((Object)itemName.substring(0, itemName.indexOf(58)), (Object)itemName);
            } else if (currId != newId) {
                FMLLog.info((String)"Found %s id mismatch %s : %d %d", (Object[])new Object[]{isBlock ? "block" : "item", itemName, currId, newId});
                remaps.put(itemName, new Integer[]{currId, newId});
            }
            if (isBlock) {
                blockRegistry.reassignMapping(itemName, newId.intValue());
                continue;
            }
            itemRegistry.reassignMapping(itemName, newId.intValue());
        }
        List missedMappings = Loader.instance().fireMissingMappingEvent(missing, isLocalWorld);
        if (!missedMappings.isEmpty()) {
            blockRegistry.revertSwap();
            itemRegistry.revertSwap();
            return missedMappings;
        }
        if (injectFrozenData) {
            FMLLog.info((String)"Injecting new block and item data into this server instance", (Object[])new Object[0]);
            HashMap missingBlocks = Maps.newHashMap((Map)blockRegistry.getMissingMappings());
            HashMap missingItems = Maps.newHashMap((Map)itemRegistry.getMissingMappings());
            for (Map.Entry item : missingItems.entrySet()) {
                String itemName = (String)item.getKey();
                if (missingBlocks.containsKey(itemName)) {
                    int blockId = blockRegistry.swap(((Integer)item.getValue()).intValue(), itemName, blockRegistry.get(itemName));
                    itemRegistry.swap(blockId, itemName, itemRegistry.get(itemName));
                    FMLLog.info((String)"Injecting new block/item %s : %d", (Object[])new Object[]{itemName, blockId});
                    missingBlocks.remove(itemName);
                    if (Integer.valueOf(blockId) == item.getValue()) continue;
                    remaps.put(itemName, new Integer[]{(Integer)item.getValue(), blockId});
                    continue;
                }
                FMLLog.info((String)"Injecting new item %s", (Object[])new Object[]{itemName});
                int itemId = itemRegistry.swap(((Integer)item.getValue()).intValue(), itemName, itemRegistry.get(itemName));
                if (Integer.valueOf(itemId) == item.getValue()) continue;
                remaps.put(itemName, new Integer[]{(Integer)item.getValue(), itemId});
            }
            for (Map.Entry block : missingBlocks.entrySet()) {
                FMLLog.info((String)"Injecting new block %s", (Object[])new Object[]{block.getKey()});
                int blockId = blockRegistry.swap(((Integer)block.getValue()).intValue(), (String)block.getKey(), blockRegistry.get((String)block.getKey()));
                if (Integer.valueOf(blockId) == block.getValue()) continue;
                remaps.put(block.getKey(), new Integer[]{(Integer)block.getValue(), blockId});
            }
        }
        blockRegistry.completeIdSwap();
        itemRegistry.completeIdSwap();
        blockRegistry.dump();
        itemRegistry.dump();
        Loader.instance().fireRemapEvent((Map)remaps);
        return ImmutableList.of();
    }

    public static List<String> processIdRematches(List<FMLMissingMappingsEvent.MissingMapping> remaps, boolean isLocalWorld) {
        ArrayList failed = Lists.newArrayList();
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        for (FMLMissingMappingsEvent.MissingMapping remap : remaps) {
            FMLMissingMappingsEvent.Action action = remap.getAction();
            if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(remap.name);
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.FAIL) {
                failed.add(remap.name);
                continue;
            }
            warned.add(remap.name);
        }
        if (!failed.isEmpty()) {
            FMLLog.severe((String)"This world contains blocks and items that refuse to be remapped. The world will not be loaded", (Object[])new Object[0]);
            return failed;
        }
        if (!warned.isEmpty()) {
            FMLLog.severe((String)"This world contains block and item mappings that may cause world breakage", (Object[])new Object[0]);
            return failed;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine((String)"There were %d missing mappings that have been ignored", (Object[])new Object[]{ignored.size()});
        }
        return failed;
    }

    public static void freezeData() {
        FMLLog.fine((String)"Freezing block and item id maps", (Object[])new Object[0]);
        blockRegistry.freezeMap();
        itemRegistry.freezeMap();
    }

    public static void revertToFrozen() {
        FMLLog.fine((String)"Reverting to frozen data state", (Object[])new Object[0]);
        blockRegistry.revertToFrozen();
        itemRegistry.revertToFrozen();
    }
}

