/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.logging.log4j.Level;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void generateWorld(int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : sortedGeneratorList) {
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        Collections.sort(list, new Comparator<IWorldGenerator>(){

            @Override
            public int compare(IWorldGenerator o1, IWorldGenerator o2) {
                return Ints.compare((int)((Integer)worldGeneratorIndex.get(o1)), (int)((Integer)worldGeneratorIndex.get(o2)));
            }
        });
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    public static Item registerItem(Item item, String name) {
        return GameRegistry.registerItem(item, name, null);
    }

    public static Item registerItem(Item item, String name, String modId) {
        GameData.registerItem(item, name, modId);
        return item;
    }

    public static void addAlias(String alias, String forName, Type type) {
    }

    public static Block registerBlock(Block block, String name) {
        return GameRegistry.registerBlock(block, ItemBlock.class, name);
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name) {
        return GameRegistry.registerBlock(block, itemclass, name, null, new Object[0]);
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name, String modId, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning((String)"The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", (Object[])new Object[]{Loader.instance().activeModContainer()});
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            ItemBlock i = null;
            if (itemclass != null) {
                Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
                }
                Constructor<? extends ItemBlock> itemCtor = itemclass.getConstructor(ctorArgClasses);
                i = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            if (i != null) {
                GameData.registerBlockAndItem(i, block, name, modId);
            } else {
                GameData.registerBlock(block, name, modId);
            }
            return block;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Caught an exception during block registration", (Object[])new Object[0]);
            throw new LoaderException((Throwable)e);
        }
    }

    public static void addRecipe(ItemStack output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static IRecipe addShapedRecipe(ItemStack output, Object ... params) {
        return CraftingManager.func_77594_a().func_92103_a(output, params);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... params) {
        CraftingManager.func_77594_a().func_77596_b(output, params);
    }

    public static void addRecipe(IRecipe recipe) {
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
    }

    public static void addSmelting(Block input, ItemStack output, float xp) {
        FurnaceRecipes.func_77602_a().func_151393_a(input, output, xp);
    }

    public static void addSmelting(Item input, ItemStack output, float xp) {
        FurnaceRecipes.func_77602_a().func_151396_a(input, output, xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String id) {
        TileEntity.func_145826_a(tileEntityClass, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends TileEntity> tileEntityClass, String id, String ... alternatives) {
        TileEntity.func_145826_a(tileEntityClass, (String)id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"field_145855_i", "nameToClassMap"});
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(ItemStack itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static Block findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static Item findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, ItemStack itemStack) {
        GameRegistry.registerCustomItemStack(name, itemStack, null);
    }

    public static void registerCustomItemStack(String name, ItemStack itemStack, String modId) {
        GameData.registerCustomItemStack(name, itemStack, modId);
    }

    public static ItemStack findItemStack(String modId, String name, int stackSize) {
        ItemStack foundStack = GameData.findItemStack(modId, name);
        if (foundStack != null) {
            ItemStack is = foundStack.func_77946_l();
            is.field_77994_a = Math.min(stackSize, is.func_77976_d());
            return is;
        }
        return null;
    }

    public static UniqueIdentifier findUniqueIdentifierFor(Block block) {
        return GameData.getUniqueName(block);
    }

    public static UniqueIdentifier findUniqueIdentifierFor(Item item) {
        return GameData.getUniqueName(item);
    }

    public static enum Type {
        BLOCK,
        ITEM;

    }

    public static final class UniqueIdentifier {
        public final String modId;
        public final String name;

        UniqueIdentifier(String modId, String name) {
            this.modId = modId;
            this.name = name;
        }

        public UniqueIdentifier(String string) {
            String[] parts = string.split(":");
            this.modId = parts[0];
            this.name = parts[1];
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UniqueIdentifier other = (UniqueIdentifier)obj;
            return Objects.equal((Object)this.modId, (Object)other.modId) && Objects.equal((Object)this.name, (Object)other.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.modId, this.name});
        }

        public String toString() {
            return String.format("%s:%s", this.modId, this.name);
        }
    }
}

